(define-module (sound)
  #:use-module (utils)
  #:use-module (sly game)
  #:use-module (sly signal)
  #:use-module (sly audio)
  #:use-module (tiled)
  #:export (play-step-sound
            play-portal-sound
            play-muri-sound
            no-step-sound))

(define-syntax-rule (play-with-timer sample time-offset)
  (begin
    (when (and sample
               (> (- (signal-ref *time*)
                     time-offset)
                  30))
      (set! time-offset (signal-ref *time*))
      (play-sample sample))
    #f))

(define-signal no-step-sound #t)
(define-signal step-sound (on-start (load-sample "sounds/step-less-aggressive.ogg")))
(define last-step-sound-played 0)
(define (play-step-sound tilemap position)
  (if (signal-ref no-step-sound)
      #f
      (play-with-timer (signal-ref step-sound) last-step-sound-played)))

(define last-portal-sample-played 0)
(define (play-portal-sound portal)
  (define path (object-get-property-value portal 'sound))
  (define sample (and path (load-sample path)))
  (warn path portal)
  (play-with-timer sample last-portal-sample-played))

(define-signal muri-sample (on-start (load-sample "sounds/negative_2.ogg")))
(define last-muri-sample-played 0)
(define (play-muri-sound)
  (play-with-timer (signal-ref muri-sample) last-muri-sample-played))



;; (define-signal set-step-volume
;;   (signal-map (lambda (no-step-sound game-started?)
;;                 (and game-started?
;;                      (if no-step-sound
;;                          (set-sample-volume 0)
;;                          (set-sample-volume 5))))
;;               no-step-sound game-started?))
