(define-module (music)
  #:use-module (utils)
  #:use-module (tiled)
  #:use-module (sly game)
  #:use-module (sly signal)
  #:use-module (sly audio)
  #:use-module (tilemap)
  #:export (music-name))

(define-signal music-name
  (signal-map (lambda (tilemap)
                (and tilemap (tilemap-property tilemap 'music)))
              tilemap))
(define-signal no-music
  (signal-map (lambda (tilemap)
                (and tilemap (tilemap-property tilemap 'no-music)))
              tilemap))
(define-signal music
  (signal-let ((music-name music-name)
               (game-started? game-started?))
              (and music-name game-started?
                   (begin
                     (and music-name
                          (file-exists? music-name)
                          (load-music music-name))))))
(define-signal play-music-signal
  (signal-let ((music music)
               (no-music no-music))
              (cond ((and no-music (music-playing?))
                     (stop-music))
                    ((and music (not no-music))
                     (play-music music #:loop? #t))
                    (else #f))
              music))

;; (define (change-music name)
;;   (if (string=? (signal-ref music-name) name)
;;       name
;;       (signal-set! music-name name)))
