(use-modules (ice-9 match)
             (ice-9 vlist)
             (srfi srfi-1)              ;lists?
             (srfi srfi-9)              ;records?
             (srfi srfi-26)             ;partial?
             (sdl2)
             (sly game)
             (sly audio)
             (sly repl)
             (sly window)
             (sly signal)
             (sly utils)
             (sly render)
             (sly render camera)
             (sly render color)
             (sly render mesh)
             (sly render shader)
             (sly render sprite)
             (sly render texture)
             (sly render tileset)
             (sly render tile-map)
             (sly math rect)
             (sly math vector)
             (sly math tween)
             (sly input keyboard)

             (utils)
             (tiled)
             (tilemap)
             (fade)
             (sound)
             (music)
             (character)
             (player))

(load "common.scm")

(define (build-map tileset tile-indices)
  (list->vlist*
   (map (lambda (row)
          (map (cut tileset-ref tileset <>) row))
        tile-indices)))

(define (random-map tileset width height)
  (let ((n (vector-length (tileset-tiles tileset))))
    (list->vlist*
     (list-tabulate
      height
      (lambda (y)
        (list-tabulate
         width
         (lambda (x)
           (tileset-ref tileset (random n)))))))))



;;; MAIN

(define-signal direction-keys-old (key-directions-no-diagonal 'w 's 'a 'd))

(define main-character #f)
(define (init-workaround)
  ;; (set! main-character (load-character "images/madotsuki.png"))
  'done)

(define (align-to-tile-grid vector)
  (vector2 (+ (- (vx vector) (modulo (floor (vx vector)) tile-width)) 8)
           (- (vy vector) (modulo (floor (vy vector)) tile-width))))

(define-signal mc (signal-let ((tilemap tilemap)
                               (game-started? game-started?)
                               (needs-to-spawn-value needs-to-spawn))
                              (if needs-to-spawn-value
                                  (and game-started? tilemap
                                       (let ((prev-c (signal-ref mc))
                                             (c (load-character "images/madotsuki.png")))
                                         (signal-set! needs-to-spawn #f)
                                         ;; keep direction when passing rooms
                                         (if prev-c
                                             (init-player-position
                                              tilemap
                                              (character-set-direction
                                               c
                                               (character-direction prev-c)))
                                             (init-player-position tilemap c))))
                                  (signal-ref mc))))



(define-signal change-map-by-sleeping
  (signal-let ((sleep-timer-offset-num sleep-timer-offset)
               (time *time*))
              (if (and sleep-timer-offset-num
                       (> (- time sleep-timer-offset-num) 190))
                  (begin
                    (signal-set! sleep-timer-offset #f)
                    (cond ((not (signal-ref locked-action))
                           (signal-set! *player* (player-set-last-sleep-location (signal-ref *player*) 'room-awake))
                           (change-map "sleep" "rooms/nexus.tmx" 23 "images/fade-z.png" 90 #t))
                          ((eq? (signal-ref locked-action) 'balcony-sleep)
                           (signal-set! *player* (player-set-last-sleep-location (signal-ref *player*) 'balcony))
                           (change-map "sleep" "rooms/competiton.tmx" 23 "images/fade-z.png" 90 #t))
                          (else
                           (signal-set! *player* (player-set-last-sleep-location (signal-ref *player*) (signal-ref map-current-name)))
                           (change-map "sleep" "rooms/nexus.tmx" 23 "images/fade-z.png" 90 #t))))
                  #f)))
(define-signal player-position
  ;; TODO this thing is a horrible hack
  (signal-let*
   ((w map-width)
    (h map-height)
    (tm tilemap)
    (loops map-loops)
    (time *time*)
    (a (signal-map (lambda (v) (v* v tile-width))
                   direction-keys-old)))
   (cond ((not (signal-ref mc)) 'no-character)
         ((and (not (character-is-moving? (signal-ref mc)))
               (not (and (= (vx a) 0)
                         (= (vy a) 0))))
          (let ()
            (define b (if (signal-ref mc)
                          (character-position (signal-ref mc))
                          (vector2 0 0)))
            (define added (align-to-tile-grid (v+ a b)))
            (define mw (/ w 2))
            (define mh (/ h 2))
            (define warp-position
              (cond ((not loops) #f)
                    ((> (vx added) w) (v- b (vector2 w 0)))
                    ((< (vx added) 0) (v+ b (vector2 w 0)))
                    ((> (vy added) h) (v- b (vector2 0 h)))
                    ((< (vy added) 0) (v+ b (vector2 0 h)))
                    (else #f)))
            (define new-position
              (cond ((not warp-position) added)
                    ((> (vx added) w) (v- added (vector2 w 0)))
                    ((< (vx added) 0) (v+ added (vector2 w 0)))
                    ((> (vy added) h) (v- added (vector2 0 h)))
                    ((< (vy added) 0) (v+ added (vector2 0 h)))
                    (else added)))
            (define direction
              (cond ((and (< 0 (vx a))) 'right)
                    ((and (> 0 (vx a))) 'left)
                    ((and (< 0 (vy a))) 'up)
                    ((and (> 0 (vy a))) 'down)))
            (cond ((and tm
                        (collides-with-map tm
                                           (character-collision-rect new-position)))
                   b)
                  (warp-position
                   (signal-set!
                    mc
                    (character-set-direction
                     (character-set-next-position
                      (character-set-position (signal-ref mc) warp-position)
                      new-position)
                     direction)))
                  (else
                   (signal-set!
                    mc
                    (character-set-direction
                     (character-set-next-position (signal-ref mc) new-position)
                     direction))
                   new-position))))
         ((character-is-moving? (signal-ref mc))
          (play-step-sound tm (character-next-position (signal-ref mc)))
          (let ((new-mc (character-move (signal-ref mc) time)))
            (signal-set! mc new-mc)
            (when (not (character-is-moving? new-mc))
              (handle-collision-with-portals tm (character-collision-rect
                                                 (character-position new-mc))))))
         ((character-is-in-move-animation? (signal-ref mc))
          (signal-set!
           mc
           (character-finalize-move-animation (signal-ref mc)))
          ;; TODO use hooks, we are in too deep
          (cond ((eq? (signal-ref action-on-next-tile) 'sleep)
                 (signal-set! sleep-timer-offset (signal-ref *time*))
                 (signal-set! action-on-next-tile #f)
                 (signal-set! mc (character-set-stance (signal-ref mc) 'sleep))
                 (signal-set! tilemap (unhide-layer tm 'bed-sleep)))
                ((eq? (signal-ref action-on-next-tile) 'balcony-sleep)
                 (signal-set! sleep-timer-offset (signal-ref *time*))
                 (signal-set! action-on-next-tile #f))))
         (else 'no-new-position))))

(define-signal camera-size (v* (vector2 320 240) *scale*))
(define camera (2d-camera #:area (make-rect (vector2 0 0) (signal-ref camera-size))))
(define-signal camera-position
  (signal-let ((camera-size camera-size)
               (map-dimensions map-dimensions)
               (map-loops map-loops)
               (map-centers map-centers)
               (map-clamps map-clamps)
               (player mc))
              (if (and player camera-size map-width map-height)
                  (let ()
                    (define pos (v+ (v* (character-position player)
                                        (v* (vector2 -1 -1) *scale*))
                                    (v* camera-size 0.5)))
                    (define clamped (cond (map-loops pos)
                                          (map-centers
                                           (vclamp (v+ (v* map-dimensions -0.5)
                                                       (v* camera-size 0.5))
                                                   (v* camera-size 0.25)
                                                   pos))
                                          (map-clamps (vclamp (vmap
                                                               (lambda (n) (min 0))
                                                               (v+ (v* map-dimensions -1)
                                                                   camera-size))
                                                              (vector2 0 0)
                                                              pos))
                                          (else pos)))
                    (define result (vmap round clamped))
                    result)
                  (vector2 0 0))))

(define-signal action-button-trigger
  (key-down-any?
   (lambda (key)
     (if (and key (signal-ref mc) (signal-ref tilemap))
         (let ()
           (define trigger (colliding-logic-object
                            (signal-ref tilemap)
                            (character-collision-rect (signal-ref mc))
                            'trigger))
           (define value (and trigger
                              (object-get-property-value trigger 'trigger)))
           (define portrait (colliding-logic-object
                             (signal-ref tilemap)
                             (character-collision-rect (signal-ref mc))
                             'image))
           (define balcony-chair (colliding-logic-object
                                  (signal-ref tilemap)
                                  (character-collision-rect (signal-ref mc))
                                  'balcony-chair))
           (cond ((and portrait (object-get-property-value portrait 'image))
                  (fade-activate! (make-fade
                                   fade-scale-in
                                   fade-scale-out
                                   30 230 (object-get-property-value portrait 'image)
                                   #t
                                   (lambda () #f))))
                 ;; cancel sleep
                 ((and (signal-ref locked-action) (equal? 'sleep (signal-ref locked-action)))
                  (fade-cleanup!)
                  (signal-set! locked-action #f)
                  (signal-set! sleep-timer-offset #f)
                  (signal-set! tilemap (hide-layer (signal-ref tilemap) 'bed-sleep))
                  (signal-set!
                   mc
                   (character-set-next-position
                    (character-set-direction (signal-ref mc) 'left)
                    (v- (character-position (signal-ref mc)) (vector2 (* tile-width 1.5) 0)))))
                 ((and (signal-ref locked-action) (equal? 'balcony-sleep
                                                          (signal-ref locked-action)))
                  (fade-cleanup!)
                  (signal-set! locked-action #f)
                  (signal-set! sleep-timer-offset #f)
                  (signal-set! tilemap (hide-layer (signal-ref tilemap) 'balcony-sleep))
                  ;; make birb fly away
                  (birb-fly-away)
                  (signal-set!
                   mc
                   (character-set-next-position
                    (character-set-direction (signal-ref mc) 'up)
                    (v+ (character-position (signal-ref mc)) (vector2 0 (* tile-height 2))))))
                 ;; nothing
                 ((not trigger) #f)
                 ;; start sleep
                 ((equal? value "sleep")
                  (signal-set! locked-action 'sleep)
                  (signal-set! action-on-next-tile 'sleep)
                  (signal-set!
                   mc
                   (character-set-next-position
                    (character-set-direction (signal-ref mc) 'right)
                    (v+ (character-position (signal-ref mc)) (vector2 (* tile-width 1.5) 0)))))
                 ;; birb chair
                 ((equal? value "balcony-chair")
                  (if (find (lambda (c) (eq? (character-id c) 'birb))
                            (signal-ref map-characters))
                      (begin
                        (signal-set! locked-action 'balcony-sleep)
                        (signal-set! action-on-next-tile 'balcony-sleep)
                        (signal-set!
                         mc
                         (character-set-next-position
                          (character-set-direction (signal-ref mc) 'down)
                          (v- (character-position (signal-ref mc)) (vector2 0 (* tile-height 2))))))
                      (muri)))
                 (else (warn "do not know how to action trigger" value)
                       (muri))))))
   'y 'z 'c 'e 'return 'enter 'num-0 'num-plus 'num-9))
(define-signal show-menu #f)
(define-signal menu-button-trigger
  (key-down-any? (lambda (key)
                   (cond ((and key (not (signal-ref show-menu)))
                          (signal-set! show-menu #t))
                         ((and show-menu (not (eq? key 'escape)))
                          (signal-set! show-menu #f))))
                 'x 'escape 'num-7))

(define (muri)
  (play-muri-sound))

(define (birb-fly-away)
  (signal-set!
   map-characters
   (map (lambda (c)
          (if (equal? (character-id c) 'birb)
              (character-set-next-position
               (character-set-direction c 'right)
               (rect-position
                (tilemap-object-rect
                 (tilemap-object-with-name (signal-ref tilemap)
                                           'waypoint-birb-away))))
              c))
        (signal-ref map-characters)))  )


(define-signal closer-to-bottom
  (signal-let ((h map-height)
               (mc mc))
              (and mc
                   (< (vy (character-position mc))
                      (/ h 2)))))

(define-signal closer-to-right
  (signal-let ((w map-width)
               (mc mc))
              (and mc
                   (> (vx (character-position mc))
                      (/ w 2)))))

(define-signal tilemap-render
  (signal-let
   ((tilemap tilemap))
   (define tileset (if tilemap (tilemap-tileset tilemap) #f))
   (define (render-layer layer)
     (list->renderer (compile-tile-layer (build-map tileset (tilemap-layer-indices layer))
                                         tile-width tile-height)))
   (if tilemap
       (let* ((layers (tilemap-layers tilemap))
              (character-layer-z (or (find-compute
                                      (lambda (layer)
                                        (if (eq? (tilemap-layer-name layer) 'main-2)
                                            (tilemap-layer-z layer)
                                            #f))
                                      layers)
                                     (begin (warn "NO LAYER NAMED main-2" layers) 99)))
              (pre-character-layers (filter (lambda (layer)
                                              (<= (tilemap-layer-z layer)
                                                  character-layer-z))
                                            layers))
              (post-character-layers (filter (lambda (layer)
                                               (> (tilemap-layer-z layer)
                                                  character-layer-z))
                                             layers))
              (render-pre-character-layers
               (list->renderer
                (map render-layer pre-character-layers)))
              (render-post-character-layers
               (list->renderer
                (map render-layer post-character-layers))))
         (lambda () (values
                     render-pre-character-layers
                     render-post-character-layers)))
       (lambda () (values
                   render-nothing
                   render-nothing)))))

(define (render-layer render-things-on-map loops h w cr cb)
  (if loops
      (render-begin
       ;; diagonal loop
       (cond
        ;; br
        ((and cr cb)
         (move (v* (vector2 w (* -1 h)) *scale*)
               render-things-on-map))
        ;; tr
        (cr (move (v* (vector2 w h) *scale*)
                  render-things-on-map))
        ;; bl
        (cb (move (v* (vector2 (* -1 w)
                               (* -1 h)) *scale*)
                  render-things-on-map))
        ;; tl
        (else (move (v* (vector2 (* -1 w)
                                 h) *scale*)
                    render-things-on-map)))

       ;; horizontal loop
       (if cr
           (move (v* (vector2 w 0) *scale*) render-things-on-map)
           (move (v* (vector2 (* -1 w) 0) *scale*) render-things-on-map))

       ;; vertical loop
       (if cb
           (move (v* (vector2 0 (* -1 h)) *scale*) render-things-on-map)
           (move (v* (vector2 0 h) *scale*) render-things-on-map))

       ;; original map
       render-things-on-map)
      render-things-on-map))

(define (render tilemap-render time pos loops w h cr cb mc fade map-background debug-wind-rose
                map-characters)
  (define (render-things-on-map)
    (call-with-values tilemap-render
      (lambda (pre-character-layers post-character-layers)
        (render-layer (render-begin (move (signal-ref map-background-position)
                                          (if map-background
                                              render-nothing
                                              ;; (render-sprite map-background)
                                              render-nothing))
                                    pre-character-layers
                                    (if mc
                                        (character-render time mc)
                                        render-nothing)
                                    (list->renderer (map (lambda (c)
                                                           (character-render time c))
                                                         map-characters))
                                    post-character-layers)
                      loops h w cr cb)
        ;; (render-begin (render-layer pre-character-layers h w cr cb)
        ;;               (render-layer (if mc
        ;;                                 (character-render time mc)
        ;;                                 render-nothing)
        ;;                             h w cr cb)
        ;;               (render-layer post-character-layers h w cr cb))
        )))
  (render-begin
   (move pos
         (render-begin
          (if debug-wind-rose
              ;; (render-sprite debug-wind-rose)
              render-nothing
              render-nothing)
          (render-things-on-map)))
   (fade-render time fade)))

(define (init-player-position tilemap c)
  (and tilemap c
       (let ()
         (define logic-layer (layer-named tilemap 'logic))
         (define spawn-object (or (tilemap-object-with-property tilemap 'spawn
                                                                (signal-ref map-use-spawn))
                                  (tilemap-object-with-property tilemap 'spawn)))
         (define spawn-position (if spawn-object
                                    (rect-position (tilemap-object-rect spawn-object))
                                    (vector2 0 0)))
         (define new-c (character-set-position c (align-to-tile-grid spawn-position)))
         new-c)))

(define-signal init-workaround-signal
  (on-start (init-workaround)))
(define-signal fuck
  (on-start (load-sprite "images/madotsuki.png")))
(define-signal debug-wind-rose
  (on-start (load-sprite "images/test-rose.png")))

(define-signal scene
  (signal-let* ((tilemap-render tilemap-render)
                (cr closer-to-right)
                (cb closer-to-bottom)
                (w map-width)
                (h map-height)
                (fuck fuck)
                (mc mc)
                (time *time*)
                (loops map-loops)
                (map-characters map-characters)
                (map-background map-background)
                (fade fade)
                (init init-workaround-signal)

                (pos camera-position)
                (debug-wind-rose debug-wind-rose))
               (if (and init fuck)
                   (with-camera camera
                     (scale *scale* (render tilemap-render time pos loops w h cr cb mc
                                            fade map-background debug-wind-rose
                                            map-characters)))
                   ;; mc-r
                   render-nothing)))

(start-sly-repl)
(enable-audio)
(set-sample-volume 75)
(set-music-volume 95)
(with-window (make-window #:title "YN"
                          #:resolution (v* (vector2 320 240) *scale*)
                          #:fullscreen? #f)
             (run-game-loop scene))
