(define-module (collision)
  #:use-module (sly math rect)
  #:use-module (sly math vector)
  #:export (rects-touch?
            rect-above?
            rect-inside?))

(define (rects-touch? a b)
  (not (or (> (rect-left   a) (rect-right  b))
           (< (rect-right  a) (rect-left   b))
           (< (rect-top    a) (rect-bottom b))
           (> (rect-bottom a) (rect-top    b)))))

(define (rect-above? a b)
  (< (rect-bottom a) (rect-top b)))

(define (rect-inside? v rect)
  (and (and (> (vx v) (rect-left   rect))
            (< (vx v) (rect-right  rect))
            (< (vy v) (rect-top    rect))
            (> (vy v) (rect-bottom rect)))))
