(define-module (player)
  #:use-module (srfi srfi-1)            ;list utils
  #:use-module (srfi srfi-9)            ;record
  #:use-module (srfi srfi-9 gnu)        ;immutable record
  #:use-module (sound)
  #:use-module (sly)
  #:use-module (sly window)
  #:use-module (sly game)
  #:use-module (sly signal)
  #:export (*player*
            player-last-sleep-location player-set-last-sleep-location
            player-add-visit player-has-visited
            player-add-influence player-has-influence
            save-game
            load-game))

;; (define-immutable-record-type <player>
;;   (%make-player last-sleep-location room-visits)
;;   (last-sleep-location player-last-sleep-location)
;;   (room-visits player-room-visits))

(define (player-last-sleep-location player) (list-ref player 0))
(define (player-visits player) (list-ref player 1))
(define (player-influences player) (list-ref player 2))
(define (make-player)
  (list 'room-floor (list) (list)))
(define (player-set-last-sleep-location player location)
  (list location (player-visits player) (player-influences player)))
(define (player-add-visit player visit)
  (define visits (player-visits player))
  (list (player-last-sleep-location player)
        (cons visit visits)
        (player-influences player)))
(define (player-add-influence player influence)
  (define influences (player-influences player))
  (if (player-has-influence player influence)
      player
      (list (player-last-sleep-location player)
            (player-visits player)
            (cons influence influences))))
(define (player-has-influence player influence)
  (find (lambda (i) (eq? i influence))
        (player-influences player)))
(define (player-has-visited player visit)
  (find (lambda (i) (eq? i visit))
        (player-visits player)))

(define (mkdir-p path)
  (warn "TODO impl mkdir-p" path)
  (system* "mkdir" "-p" path))

(define (save-file-path)
  (define home-save-dir "/.local/yn/")
  (define dir (cond ((getenv "YN_SAVEDIR") (getenv "YN_SAVEDIR"))
                    ((getenv "HOME_DRIVE") (string-append
                                            (getenv "HOME_DRIVE")
                                            "/"
                                            (getenv "HOME_DIR")
                                            home-save-dir))
                    ((getenv "HOME") (string-append (getenv "HOME")
                                                    home-save-dir))
                    (else "./saves")))
  (define file (string-append dir "/" "save.alist"))
  (mkdir-p dir)
  file)

(define (save-game)
  ;; (warn "saving" (save-file-path))
  ;; (and (signal-ref *player*)
  ;;      (call-with-output-file (save-file-path)
  ;;        (lambda (port)
  ;;          (write (signal-ref *player*) port))))
  #f)

(define (load-game)
  ;; (define file (save-file-path))
  ;; (and (file-exists? file)
  ;;      (call-with-input-file file
  ;;        (lambda (port)
  ;;          (define player (read port))
  ;;          (if (eof-object? player)
  ;;              #f
  ;;              player))))
  #f
  )

(define (on-quit)
  (save-game)
  (stop-game-loop))

(define-signal *player* (or (load-game) (make-player)))
(add-hook! window-close-hook on-quit)

(add-hook! key-press-hook (lambda (key)
                            (when (eq? key 'escape)
                              (on-quit))
                            (when (eq? key 'f)
                              (signal-set! window-fullscreen (not (signal-ref window-fullscreen))))
                            (when (eq? key 'm)
                              (signal-set! no-step-sound (not (signal-ref no-step-sound))))))
