(define-module (fade)
  #:use-module (srfi srfi-9)            ; record
  #:use-module (srfi srfi-9 gnu)        ; record-immutable
  #:use-module (utils)
  #:use-module (sly game)
  #:use-module (sly window)
  #:use-module (sly signal)
  #:use-module (sly utils)
  #:use-module (sly render)
  #:use-module (sly render color)
  #:use-module (sly render shader)
  #:use-module (sly render sprite)
  #:use-module (sly render texture)
  #:use-module (sly math)
  #:use-module (sly math rect)
  #:use-module (sly math vector)
  #:use-module (sly math tween)
  #:export (make-fade
            fade-activate!
            fade-cleanup!
            fade-to-black
            fade-from-black
            fade-scale-in
            fade-scale-out
            fade-scale-in-true-res
            fade-scale-out-true-res
            fade
            fade-render))

(define-immutable-record-type <fade>
  (%make-fade type time-offset tween render-proc duration stay-duration sprite
              allow-simple-override callback)
  fade?
  (type fade-type)
  (time-offset fade-time-offset)
  (tween fade-tween)
  (render-proc fade-render-proc)
  (duration fade-duration)
  (stay-duration fade-stay-duration)
  (sprite fade-sprite)
  (allow-simple-override fade-allow-simple-override)
  (callback fade-callback fade-set-callback))

(define* (make-fade out in duration stay-duration image allow-simple-override callback)
  (define time (or (signal-ref *time*) 0))
  (define raw-fade (out time duration stay-duration image allow-simple-override))
  (define newfade (fade-set-callback raw-fade
                                     (lambda ()
                                       (define time (or (signal-ref *time*) 0))
                                       (fade-activate! (in time duration stay-duration image #t) newfade)
                                       (callback))))
  newfade)

(define* (fade-activate! newfade #:optional (oldfade #f))
  (define currentfade (signal-ref fade))
  (if (or (not newfade)
          (eq? oldfade currentfade)
          (and currentfade (fade-allow-simple-override currentfade))
          (not currentfade))
      (signal-set! fade newfade)
      #f))

(define (fade-cleanup!)
  (fade-activate! #f))

;;; TODO make it like the rendering thing in SICP, so i can compose more
(define (fade-render-alpha fade progress)
  (move (v* (signal-ref window-size) 0.5)
        (with-color (make-color 1 1 1 progress)
          (render-sprite (fade-sprite fade)))))

(define* (fade-to-black time #:optional (duration 15) (stay-duration 5)
                        (image-path "images/fade.png") (allow-simple-override #f))
  (define fadetween (tween lerp ease-out-quad
                           0.0
                           1.0
                           duration))
  (%make-fade 'to-black time fadetween
              fade-render-alpha
              duration
              stay-duration
              (if (signal-ref game-started?)
                  (load-sprite image-path)
                  #f)
              allow-simple-override
              fade-cleanup!))
(define* (fade-from-black time #:optional (duration 15) (stay-duration 5)
                          (image-path "images/fade.png") (allow-simple-override #f))
  (define fadetween (tween lerp ease-out-quad 1.0 0.0 duration))
  (%make-fade 'to-black time fadetween
              fade-render-alpha
              duration
              stay-duration
              (if (signal-ref game-started?)
                  (load-sprite image-path)
                  #f)
              allow-simple-override
              fade-cleanup!))

(define (fade-render-scale fade progress)
  (scale progress
         (with-color (make-color 1 1 1 progress)
           (move (v* (signal-ref window-size) 0.5)
                 (render-sprite (fade-sprite fade))))))
(define (fade-render-scale-true-res fade progress)
  ;; make sure it is displayed in it's actual resolution
  (scale (* progress (/ 1.0 *scale*))
         (with-color (make-color 1 1 1 progress)
           (move (v* (signal-ref window-size) 0.5)
                 (render-sprite (fade-sprite fade))))))
;;; TODO really shit copy pasta, but I don't wan tot change the references
(define* (fade-scale-in time #:optional (duration 15) (stay-duration 5)
                        (image-path "images/fade.png") (allow-simple-override #f))
  (define fadetween (tween lerp ease-out-quad 0.0 1.0 duration))
  (%make-fade 'to-black time fadetween
              fade-render-scale
              duration
              stay-duration
              (if (signal-ref game-started?)
                  (load-sprite image-path)
                  #f)
              allow-simple-override
              fade-cleanup!))
(define* (fade-scale-out time #:optional (duration 15) (stay-duration 5)
                         (image-path "images/fade.png") (allow-simple-override #f))
  (define fadetween (tween lerp ease-out-quad 1.0 0.0 duration))
  (%make-fade 'to-black time fadetween
              fade-render-scale
              duration
              stay-duration
              (if (signal-ref game-started?)
                  (load-sprite image-path)
                  #f)
              allow-simple-override
              fade-cleanup!))
(define* (fade-scale-in-true-res time #:optional (duration 15) (stay-duration 5)
                                 (image-path "images/fade.png") (allow-simple-override #f))
  (define fadetween (tween lerp ease-out-quad 0.0 1.0 duration))
  (%make-fade 'to-black time fadetween
              fade-render-scale-true-res
              duration
              stay-duration
              (if (signal-ref game-started?)
                  (load-sprite image-path)
                  #f)
              allow-simple-override
              fade-cleanup!))
(define* (fade-scale-out-true-res time #:optional (duration 15) (stay-duration 5)
                                  (image-path "images/fade.png") (allow-simple-override #f))
  (define fadetween (tween lerp ease-out-quad 1.0 0.0 duration))
  (%make-fade 'to-black time fadetween
              fade-render-scale-true-res
              duration
              stay-duration
              (if (signal-ref game-started?)
                  (load-sprite image-path)
                  #f)
              allow-simple-override
              fade-cleanup!))

(define-signal fade #f)
(define (fade-render time fade)
  (if (and fade (fade-sprite fade))
      (let ((tween (fade-tween fade)))
        (cond
         ;; after the stay
         ;; TODO add hooks or some shit, because it would be better
         ;; to load the next map and then stay a minimum of time on the fade
         ;; rather than staying and only loading when the stay-duration is over
         ((> (- time (fade-time-offset fade)) (+ (fade-duration fade)
                                                 (fade-stay-duration fade)))
          ((fade-callback fade))
          ((fade-render-proc fade) fade (tween (fade-duration fade))))
         ;; during the stay
         ((> (- time (fade-time-offset fade)) (fade-duration fade))
          ((fade-render-proc fade) fade (tween (fade-duration fade))))
         ;; normal in progress before the stay
         (else
          ((fade-render-proc fade) fade (tween (- time (fade-time-offset fade))))))
        )
      render-nothing))
