(define-module (utils)
  #:use-module (ice-9 match)
  #:use-module (sly)
  #:use-module (sly math)
  #:use-module (sly signal)
  #:use-module (srfi srfi-1)
  #:use-module (sly input keyboard)
  #:export (signal-unpack-signal
            signal-unpack-signal-maybe
            *time*
            *scale*
            sprite*
            alist->hash-table
            v/
            vclamp
            rect-scale-center
            key-directions-no-diagonal
            car-safe
            cdr-safe
            find-compute
            string->numberM
            string->symbolM
            key-down-any?
            random-chance))

(define (string->numberM str) (and str (string->number str)))
(define (string->symbolM str) (and str (string->symbol str)))

(define (find-compute test-proc lst)
  "Like find, but it returns the value from test-proc instead of the list item"
  (define (itr current rest)
    (define result (test-proc current))
    (if result
        result
        (if (null? rest)
            #f
            (itr (car rest) (cdr rest)))))
  (if (null? lst)
      #f
      (itr (car lst) (cdr lst))))

(define (alist->hash-table alist)
  (define database (make-hash-table))
  (for-each (lambda (entry)
              (hash-set! database (car entry) (cdr entry)))
            alist)
  database)

(define (signal-unpack-signal proc signal . rest)
  ;; Call PROC, if it returns a signal, directly return the signal.
  ;; Otherwise create a signal that waits until PROC returns a signal.
  ;; Once PROC returns the first signal splice the waiting-signal with it.
  ;;
  ;; This is useful for unpackaging signals from records which are signals themselves.

  ;; TODO signal PROC signal changes, update this signal
  ;; TODO sub-signal changes, change this signal

  (let ((inputs (cons signal rest)))
    (define (current-value)
      (apply proc (map signal-ref inputs)))
    (define first-value (current-value))
    (define value 'init)
    (define proxy-signal
      (apply signal-map (lambda _
                          (define new-value (current-value))
                          (cond ((eq? value 'init)
                                 (set! value new-value))
                                ((and (signal? new-value)
                                      (not (eq? value new-value)))
                                 ;; disconnect old and splice the new
                                 (hash-for-each (lambda (signal unused)
                                                  (signal-disconnect! signal proxy-signal))
                                                (signal-outputs (signal-unbox proxy-signal)))
                                 (set! value new-value)
                                 (splice-signals! proxy-signal new-value)))
                          value)
             inputs))
    ;; (define (waiting-signal)
    ;;   (define ws (apply signal-map
    ;;                     (lambda _
    ;;                       (define new-value (current-value))
    ;;                       (if (signal? new-value)
    ;;                           (splice-signals! ws new-value)
    ;;                           new-value)
    ;;                       first-value)
    ;;                     inputs))
    ;;   ws)
    (when (signal? first-value)
      (splice-signals! proxy-signal first-value)
      ;; (signal-set! proxy-signal first-value)
      )
    proxy-signal))
(define (signal-unpack-signal-maybe proc signal . rest)
  (apply signal-unpack-signal
         (lambda (. args)
           (if (fold (lambda (v acc) (and acc (not (eqv? v #f)))) #t args)
               (begin (warn "APPL" args "TO" proc) (apply proc args))
               #f)) signal rest))

(define-signal *time* (signal-timer))
(define sprite* (memoize make-sprite))

(define (v/ vector number)
  (vector2 (/ (vx vector) number)
           (/ (vy vector) number)))
(define (vclamp min max v)
  (match v
    (($ <vector2> x y)
     (vector2 (clamp (vx min) (vx max) x)
              (clamp (vy min) (vy max) y)))
    (($ <vector3> x y z)
     (vector3 (clamp (vx min) (vx max) x)
              (clamp (vy min) (vy max) y)
              (clamp (vz min) (vz max) z)))
    (($ <vector4> x y z w)
     (vector4 (clamp (vx min) (vx max) x)
              (clamp (vy min) (vy max) y)
              (clamp (vz min) (vz max) z)
              (clamp (vw min) (vw max) w)))))
(define (rect-scale-center rect scale)
  ;; TODO make it work
  rect
  ;; (define size (rect-size rect))
  ;; (define new-size (v* (rect-size rect) scale))
  ;; (define size-diff (v- new-size size))
  ;; (define pos (rect-size rect))
  ;; (make-rect (v- pos (v* size-diff 0.5))
  ;;            new-size)
  )

(define (recent-key-name name key-down-signal)
  (signal-map (lambda (v) (if v name #f) ) key-down-signal))

(define (car-safe lst)
  (if (or (not lst) (null? lst))
      #f
      (car lst)))
(define (cdr-safe lst)
  (if (or (not lst) (null? lst))
      #f
      (cdr lst)))

(define (key-directions-no-diagonal up down left right)
  "Move into the direction of one key.
Sort all pressed keys by recentness.
Filter out the not pressed keys."
  (signal-map (lambda (up? down? left? right?)
                (define most-recent
                  (car-safe
                   (car-safe
                    ;; ('up <time> . #f)
                    (sort (filter (lambda (x)
                                    (cdr (cdr x)))
                                  (list (cons 'up    up?)
                                        (cons 'down  down?)
                                        (cons 'left  left?)
                                        (cons 'right right?)))
                          (lambda (a b)
                            (> (cadr a) (cadr b)))))))
                (cond ((and (cdr left?)  (or (eq? 'left  most-recent)))  (vector2 -1  0))
                      ((and (cdr right?) (eq? 'right most-recent))  (vector2  1  0))
                      ((and (cdr up?)    (eq? 'up    most-recent))  (vector2  0  1))
                      ((and (cdr down?)  (eq? 'down  most-recent))  (vector2  0 -1))
                      (else   (vector2  0  0))))
              (signal-timestamp (key-down? up))
              (signal-timestamp (key-down? down))
              (signal-timestamp (key-down? left))
              (signal-timestamp (key-down? right))))

(define* (key-down-any? proc . keys)
  (define signals (map (lambda (k) (key-down? k)) keys))
  (apply signal-map (lambda* (. keys)
                      (define key (find identity keys))
                      (proc key))
         signals))

(define *scale* 2)

(define (random-chance max)
  ;; (eqv? 1 (random max))
  #t
  )
