;;; Copyright (C) 2014, 2015 David Thompson <davet@gnu.org>
;;; Copyright (C) 2017 nee (https://hidamari.blue)

(use-modules (ice-9 match)
             (srfi srfi-1)
             (guix gexp)
             (guix packages)
             (guix licenses)
             (guix download)
             (guix git-download)
             (guix build-system gnu)
             (gnu packages)
             (gnu packages autotools)
             (gnu packages pkg-config)
             (gnu packages texinfo)
             (gnu packages guile)
             (gnu packages gl)
             (gnu packages sdl)
             (gnu packages maths)
             (gnu packages image))

(define guile-sdl2
  (package
   (name "guile-sdl2")
   (version "0.1.0")
   (source (origin
            (method git-fetch)
            (uri (git-reference
                  (url "git://dthompson.us/guile-sdl2.git")
                  (commit "55c4eef")))
            (sha256
             (base32
              "1yckf6n2iwp5l3yz4y0rks5qbylnmfnpcxmlwl74aqyqfxd586ix"))))
   (build-system gnu-build-system)
   (arguments
    '(#:configure-flags
      (list (string-append "--with-libsdl2-prefix="
                           (assoc-ref %build-inputs "sdl2"))
            (string-append "--with-libsdl2-image-prefix="
                           (assoc-ref %build-inputs "sdl2-image"))
            (string-append "--with-libsdl2-ttf-prefix="
                           (assoc-ref %build-inputs "sdl2-ttf"))
            (string-append "--with-libsdl2-mixer-prefix="
                           (assoc-ref %build-inputs "sdl2-mixer")))
      #:make-flags '("GUILE_AUTO_COMPILE=0")
      #:phases
      (modify-phases %standard-phases
                     (add-after 'unpack 'bootstrap
                                (lambda _ (zero? (system* "sh" "bootstrap"))))
                     (add-after 'configure 'patch-makefile
                                (lambda _
                                  ;; Install compiled Guile files in the expected place.
                                  (substitute* '("Makefile")
                                               (("^godir = .*$")
                                                "godir = $(moddir)\n")))))))
   (native-inputs
    `(("autoconf" ,autoconf)
      ("automake" ,automake)
      ("pkg-config" ,pkg-config)))
   (inputs
    `(("guile" ,guile-2.2)
      ("sdl2" ,sdl2)
      ("sdl2-image" ,sdl2-image)
      ("sdl2-mixer" ,sdl2-mixer)
      ("sdl2-ttf" ,sdl2-ttf)))
   (synopsis "Guile bindings for SDL2")
   (description "Guile-sdl2 provides pure Guile Scheme bindings to the
SDL2 C shared library via the foreign function interface.")
   (home-page "https://git.dthompson.us/guile-sdl2.git")
   (license lgpl3+)))

(define sly
  (package
   (name "sly")
   (version "0.2.0-blue")
   (source
    (origin
     (method url-fetch)
     (uri "https://hidamari.blue/yn/sly-0.2.0-blue.tar.gz")
     (sha256
      (base32
       "0gpzkqngwgf6l95jvmvx6bwvdv3p3p65bf4iymmc9qx5jzzkwchz"))))
   (build-system gnu-build-system)
   (arguments
    '(#:phases
      (modify-phases %standard-phases
                     (add-after 'unpack 'bootstrap
                                (lambda _ (zero? (system* "sh" "bootstrap")))))))
   (native-inputs
    `(("pkg-config" ,pkg-config)
      ("autoconf" ,autoconf)
      ("automake" ,automake)
      ("texinfo" ,texinfo)))
   (propagated-inputs
    `(("guile-sdl2" ,guile-sdl2)
      ("guile-opengl" ,guile-opengl)))
   (inputs
    `(("guile" ,guile-2.2)
      ("sdl2" ,sdl2)
      ("guile-sdl2" ,guile-sdl2)
      ("gsl" ,gsl)
      ("mesa" ,mesa)))
   (synopsis "2D/3D game engine for GNU Guile")
   (description "Sly is a 2D/3D game engine written in Guile Scheme.
Sly differs from most game engines in that it emphasizes functional
reactive programming and live coding.")
   (home-page "http://dthompson.us/pages/software/sly.html")
   (license gpl3+)))


(define yn
  (package
   (name "yn")
   (version "0.0.0")
   (source
    ;; "/home/nee/workspace/yn/yn-0.0.0.tar.gz"
    (origin
     (method url-fetch)
     (uri "https://hidamari.blue/yn/yn-0.0.0.tar.gz")
     (sha256
      (base32
       "00jkhmdci8j9wqs1y9qr4bgf6f9nicvwcwila63h05mlpyimkl3q"))))
   (build-system gnu-build-system)
   (arguments
    '(#:tests?
      #f
      #:make-flags (let ((out (assoc-ref %outputs "out")))
                     (list (string-append "PREFIX=" out)))
      #:phases (modify-phases %standard-phases
                              (delete 'configure))))
   (propagated-inputs
    `(("guile-sdl2" ,guile-sdl2)
      ("guile-opengl" ,guile-opengl)
      ("sly" ,sly)))
   (inputs
    `(("guile" ,guile-2.2)
      ("sdl2" ,sdl2)
      ("guile-sdl2" ,guile-sdl2)
      ("gsl" ,gsl)
      ("mesa" ,mesa)))
   (synopsis "yume nikki fangame in guile")
   (description "yume nikki fangame")
   (home-page "https://hidamari.blue/yn")
   (license agpl3+)))

yn
