/*:
 * @target MZ
 * @plugindesc Remove "Always Dash and Command Remember" in-game options.
 * @author Caethyril
 * @url https://forums.rpgmakerweb.com/threads/169748/
 * @help Free to use and/or modify for any project, no credit required.
 */
void (() => {
'use strict';

  /* Symbols of options to hide/remove. */
  const REMOVE = ["alwaysDash", "commandRemember"];

  // Patch - don't add removed options.
  const addCommand = Window_Options.prototype.addCommand;
  Window_Options.prototype.addCommand = function(name, symbol, enabled, ext) {
    if (!REMOVE.includes(symbol))
      addCommand.apply(this, arguments);
  };

  // Patch - reduce number of options commands accordingly.
  const maxCommands = Scene_Options.prototype.maxCommands;
  Scene_Options.prototype.maxCommands = function() {
    return maxCommands.apply(this, arguments) - REMOVE.length;
  };

})();