var mainScript = (() => {
  var __defProp = Object.defineProperty;
  var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
  var __getOwnPropNames = Object.getOwnPropertyNames;
  var __hasOwnProp = Object.prototype.hasOwnProperty;
  var __export = (target, all) => {
    for (var name in all)
      __defProp(target, name, { get: all[name], enumerable: true });
  };
  var __copyProps = (to, from, except, desc) => {
    if (from && typeof from === "object" || typeof from === "function") {
      for (let key of __getOwnPropNames(from))
        if (!__hasOwnProp.call(to, key) && key !== except)
          __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
    }
    return to;
  };
  var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

  // index.js
  var script_files_exports = {};
  __export(script_files_exports, {
    addMenuPanels: () => addMenuPanels,
    addReplaceLink: () => addReplaceLink,
    addWrapperHtml: () => addWrapperHtml,
    preload: () => preload
  });

  // ../node_modules/svg-tag-names/index.js
  var svgTagNames = [
    "a",
    "altGlyph",
    "altGlyphDef",
    "altGlyphItem",
    "animate",
    "animateColor",
    "animateMotion",
    "animateTransform",
    "animation",
    "audio",
    "canvas",
    "circle",
    "clipPath",
    "color-profile",
    "cursor",
    "defs",
    "desc",
    "discard",
    "ellipse",
    "feBlend",
    "feColorMatrix",
    "feComponentTransfer",
    "feComposite",
    "feConvolveMatrix",
    "feDiffuseLighting",
    "feDisplacementMap",
    "feDistantLight",
    "feDropShadow",
    "feFlood",
    "feFuncA",
    "feFuncB",
    "feFuncG",
    "feFuncR",
    "feGaussianBlur",
    "feImage",
    "feMerge",
    "feMergeNode",
    "feMorphology",
    "feOffset",
    "fePointLight",
    "feSpecularLighting",
    "feSpotLight",
    "feTile",
    "feTurbulence",
    "filter",
    "font",
    "font-face",
    "font-face-format",
    "font-face-name",
    "font-face-src",
    "font-face-uri",
    "foreignObject",
    "g",
    "glyph",
    "glyphRef",
    "handler",
    "hkern",
    "iframe",
    "image",
    "line",
    "linearGradient",
    "listener",
    "marker",
    "mask",
    "metadata",
    "missing-glyph",
    "mpath",
    "path",
    "pattern",
    "polygon",
    "polyline",
    "prefetch",
    "radialGradient",
    "rect",
    "script",
    "set",
    "solidColor",
    "stop",
    "style",
    "svg",
    "switch",
    "symbol",
    "tbreak",
    "text",
    "textArea",
    "textPath",
    "title",
    "tref",
    "tspan",
    "unknown",
    "use",
    "video",
    "view",
    "vkern"
  ];

  // ../node_modules/dom-chef/index.js
  var svgTags = new Set(svgTagNames);
  svgTags.delete("a");
  svgTags.delete("audio");
  svgTags.delete("canvas");
  svgTags.delete("iframe");
  svgTags.delete("script");
  svgTags.delete("video");
  var IS_NON_DIMENSIONAL = /acit|ex(?:s|g|n|p|$)|rph|grid|ows|mnc|ntw|ine[ch]|zoo|^ord|itera/i;
  var isFragment = (type) => type === DocumentFragment;
  var setCSSProps = (element, style) => {
    for (const [name, value] of Object.entries(style)) {
      if (name.startsWith("-")) {
        element.style.setProperty(name, value);
      } else if (typeof value === "number" && !IS_NON_DIMENSIONAL.test(name)) {
        element.style[name] = `${value}px`;
      } else {
        element.style[name] = value;
      }
    }
  };
  var create = (type) => {
    if (typeof type === "string") {
      if (svgTags.has(type)) {
        return document.createElementNS("http://www.w3.org/2000/svg", type);
      }
      return document.createElement(type);
    }
    if (isFragment(type)) {
      return document.createDocumentFragment();
    }
    return type(type.defaultProps);
  };
  var setAttribute = (element, name, value) => {
    if (value === void 0 || value === null) {
      return;
    }
    if (/^xlink[AHRST]/.test(name)) {
      element.setAttributeNS("http://www.w3.org/1999/xlink", name.replace("xlink", "xlink:").toLowerCase(), value);
    } else {
      element.setAttribute(name, value);
    }
  };
  var addChildren = (parent, children) => {
    for (const child of children) {
      if (child instanceof Node) {
        parent.appendChild(child);
      } else if (Array.isArray(child)) {
        addChildren(parent, child);
      } else if (typeof child !== "boolean" && typeof child !== "undefined" && child !== null) {
        parent.appendChild(document.createTextNode(child));
      }
    }
  };
  var booleanishAttributes = /* @__PURE__ */ new Set([
    // These attributes allow "false" as a valid value
    "contentEditable",
    "draggable",
    "spellCheck",
    "value",
    // SVG-specific
    "autoReverse",
    "externalResourcesRequired",
    "focusable",
    "preserveAlpha"
  ]);
  var h = (type, attributes, ...children) => {
    var _a;
    const element = create(type);
    addChildren(element, children);
    if (element instanceof DocumentFragment || !attributes) {
      return element;
    }
    for (let [name, value] of Object.entries(attributes)) {
      if (name === "htmlFor") {
        name = "for";
      }
      if (name === "class" || name === "className") {
        const existingClassname = (_a = element.getAttribute("class")) !== null && _a !== void 0 ? _a : "";
        setAttribute(element, "class", (existingClassname + " " + String(value)).trim());
      } else if (name === "style") {
        setCSSProps(element, value);
      } else if (name.startsWith("on")) {
        const eventName = name.slice(2).toLowerCase().replace(/^-/, "");
        element.addEventListener(eventName, value);
      } else if (name === "dangerouslySetInnerHTML" && "__html" in value) {
        element.innerHTML = value.__html;
      } else if (name !== "key" && (booleanishAttributes.has(name) || value !== false)) {
        setAttribute(element, name, value === true ? "" : value);
      }
    }
    return element;
  };

  // addWrapperHtml.tsx
  function addWrapperHtml() {
    if (document.getElementById("contents") === null) {
      const iffSnippet = document.getElementById("iff-snippet");
      if (iffSnippet === null) {
        console.error("iffSnippet is null");
        return;
      }
      iffSnippet.remove();
      const contents = /* @__PURE__ */ h("div", { id: "contents" }, /* @__PURE__ */ h("div", { id: "bg", className: "fullscreenBg" }), /* @__PURE__ */ h("div", { id: "passages" }, /* @__PURE__ */ h("div", { id: "screenContents", className: "absoluteAlign" }, iffSnippet), /* @__PURE__ */ h("div", { id: "screenCover", className: "fullscreenBg" })));
      document.getElementById("iff-story")?.appendChild(contents);
    }
  }

  // addReplaceLink.ts
  function clickReplaceLink(event) {
    const identifier = event.target.getAttribute("identifier");
    const replacers = document.querySelectorAll(".linkReplacer[identifier='" + identifier + "']");
    if (replacers.length === 0) {
      console.error("Replacelink without replacer! Identifier " + identifier);
      console.error(event.target);
      return;
    }
    replacers.forEach((r) => {
      if (!r.classList.contains("hidden")) {
        return;
      }
      r.classList.remove("hidden");
    });
    const removed = document.querySelectorAll(".removedOnClick[identifier='" + identifier + "']");
    removed.forEach((r) => {
      r.classList.add("hidden");
    });
  }
  function clickHideText(event) {
    const identifier = event.target.getAttribute("identifier");
    const replacers = document.querySelectorAll(".linkReplacer[identifier='" + identifier + "']");
    if (replacers.length === 0) {
      console.error("Replacelink without replacer! Identifier " + identifier);
      console.error(event.target);
      return;
    }
    replacers.forEach((r) => {
      if (r.classList.contains("hidden")) {
        return;
      }
      r.classList.add("hidden");
    });
    const removed = document.querySelectorAll(".removedOnClick[identifier='" + identifier + "']");
    removed.forEach((r) => {
      r.classList.remove("hidden");
    });
  }
  function addReplaceLink() {
    Array.from(document.getElementsByClassName("linkReplaced")).forEach((e) => {
      e.addEventListener("click", clickReplaceLink);
    });
    Array.from(document.getElementsByClassName("linkHider")).forEach((e) => {
      e.addEventListener("click", clickHideText);
    });
  }

  // addMenuPanels.tsx
  function openMenuPanel(event) {
    if (event.target === null) {
      return;
    }
    const identifier = event.target.getAttribute("identifier");
    const replacer = document.querySelector(
      ".panelFull[identifier='" + identifier + "']"
    );
    if (replacer === null) {
      console.error("Replacelink without replacer!");
      console.error(event.target);
      return;
    }
    replacer.classList.remove("hidden");
  }
  function editMenuPanel(menuPanel) {
    const closeButton = /* @__PURE__ */ h("button", { type: "button", className: "closeButton" }, "X");
    closeButton.addEventListener("click", () => {
      menuPanel.classList.add("hidden");
    });
    menuPanel.prepend(closeButton);
  }
  function addMenuPanels() {
    Array.from(document.getElementsByClassName("panelOpener")).forEach((e) => {
      e.addEventListener("click", openMenuPanel);
    });
    Array.from(document.getElementsByClassName("panelFull")).forEach((e) => {
      editMenuPanel(e);
    });
  }

  // utility.ts
  function preload(imageList) {
    if (!window.hasOwnProperty("_ImageCache")) {
      window._ImageCache = [];
      window.preloadedImages = [];
    }
    imageList.map(function(url) {
      if (!window.preloadedImages.includes(url)) {
        const image = document.createElement("img");
        image.src = url;
        window._ImageCache.push(image);
        window.preloadedImages.push(url);
      }
    });
  }
  return __toCommonJS(script_files_exports);
})();
window.mainScript = mainScript;
