extends CanvasLayer

signal scene_changed()

onready var animationPlayer = $AnimationPlayer
onready var open = $OpenSFX
onready var close = $CloseSFX
onready var bed = $BedSFX
onready var black = $Control/Black
onready var loading = $Loading
	

func change_scene(path):
	layer = 100
	if GlobalVars.transitionType == "door":
		open.play()
	if GlobalVars.transitionType == "longfade":
		animationPlayer.play("LongFade")
	if GlobalVars.transitionType == "smashcut":
		animationPlayer.play("SmashCut")
	else:
		animationPlayer.play("Fade")
	yield(animationPlayer, "animation_finished")
	loading.visible = true
	get_tree().change_scene(path)
	yield(get_tree().create_timer(.5), "timeout")
	if GlobalVars.transitionType == "door":
		close.play()
	if GlobalVars.wakeUp == true:
		GlobalVars.wakeUp = false
		bed.play()
	animationPlayer.play_backwards("Fade")
	loading.visible = false
	layer = -10
