extends "res://scripts/SystemScripts/SaveandLoad.gd"


onready var startButton = $MenuItems/Start
onready var continueButton = $MenuItems/Continue
onready var controlsButton = $MenuItems/Controls
onready var quitButton = $MenuItems/Quit
var savePath = "savegame"


# Called when the node enters the scene tree for the first time.
func _ready():
	startButton.grab_focus()


# Called every frame. 'delta' is the elapsed time since the previous frame.
func _process(delta):
	if Input.is_action_just_pressed("fullscreen_toggle"):
		OS.window_fullscreen = !OS.window_fullscreen
	if $ControllerMenu.visible == true && Input.is_action_just_pressed("ui_cancel"):
		$ControllerMenu.hide()
		$MenuItems.visible = true
		startButton.grab_focus()


func _on_Start_pressed():
	$MenuItems.hide()
	$HowToPlay.visible = true
	$HowToPlay/HowtoPlayButton.grab_focus()
	


func _on_Continue_pressed():
	var file = File.new()
	if not file.file_exists("res://savegame"):
		$ErrorDisplay.visible = true
		print_debug("save file not found")
		return 0
	else:
		#add effects and unlocks here
		GlobalVars.gotTorch = _load(GlobalVars.gotTorch, savePath)
		GlobalVars.gotKnife = _load(GlobalVars.gotKnife, savePath)
		GlobalVars.gotBike = _load(GlobalVars.gotBike, savePath)
		GlobalVars.toggleDither = _load(GlobalVars.toggleDither, savePath)
		GlobalVars.toggleFootstepSFX = _load(GlobalVars.toggleFootstepSFX, savePath)
		GlobalVars.turnSpeed = _load(GlobalVars.turnSpeed, savePath)
		GlobalVars.muteMusic = _load(GlobalVars.muteMusic, savePath)
		GlobalVars.toggleCompass = _load(GlobalVars.toggleCompass, savePath)
		GlobalVars.transitionType = "fade"
		GlobalVars.currentScene = "room"
		SceneChanger.change_scene("res://Levels/Room.tscn")


func _on_Controls_pressed():
	$MenuItems.hide()
	$ControllerMenu.visible = true


func _on_Quit_pressed():
	get_tree().quit()


func _on_HowtoPlayButton_pressed():
	GlobalVars.transitionType = "fade"
	GlobalVars.currentScene = "room"
	SceneChanger.change_scene("res://levels/Room.tscn")
