extends Control

var gotFocus = false

var controllerMenuVisible = false
var optionsMenuVisible = false
onready var ui = get_node("/root/Game/HUD/UI")
onready var player = get_node("/root/Game/Player")
onready var dither = get_node("/root/Game/HUD/DitherTexture")
onready var compass = get_node("/root/Game/Player/Camera/Compass")
# Declare member variables here. Examples:
# var a = 2
# var b = "text"


# Called when the node enters the scene tree for the first time.
func _ready():
	if GlobalVars.toggleFootstepSFX == 1:
		$OptionsMenu/FootstepSFX/Text.text = "Footstep SFX [ON]"
	else:
		$OptionsMenu/FootstepSFX/Text.text = "Footstep SFX [OFF]"
	
	if GlobalVars.muteMusic == 1:
		$OptionsMenu/Music/Text.text = "Music [OFF]"
	else:
		$OptionsMenu/Music/Text.text = "Music [ON]"

	if GlobalVars.toggleCompass == 1:
		$OptionsMenu/Compass/Text.text = "Compass [ON]"
	else:
		$OptionsMenu/Compass/Text.text = "Compass [OFF]"
	
	if GlobalVars.toggleDither == 1:
		$OptionsMenu/Dither/Text.text = "Overlay [ON]"
	else:
		$OptionsMenu/Dither/Text.text = "Overlay [OFF]"
	
	if GlobalVars.turnSpeed == 1:
		$OptionsMenu/TurnSpeed/Text.text = "Turn Speed [MED]"
	elif GlobalVars.turnSpeed == 2:
		$OptionsMenu/TurnSpeed/Text.text = "Turn Speed [FAST]"
	elif GlobalVars.turnSpeed == 0:
		$OptionsMenu/TurnSpeed/Text.text = "Turn Speed [SLOW]"


# Called every frame. 'delta' is the elapsed time since the previous frame.
func _process(delta):
	if player.playerState != "talk":
		if optionsMenuVisible == true || controllerMenuVisible == true:
			player.playerState = "stop"
		else:
			player.playerState = "move"
		if controllerMenuVisible == true:
			if Input.is_action_just_pressed("ui_cancel"):
				$ControllerMenu.hide()
				$OptionsMenu.visible = true
				$OptionsMenu/TurnSpeed.grab_focus()
				controllerMenuVisible = false
			
	if optionsMenuVisible == true && controllerMenuVisible == false:
		if Input.is_action_just_pressed("ui_cancel") || Input.is_action_just_pressed("pause"):
			visible = false
			ui.visible = true
			optionsMenuVisible = false
			gotFocus = false
			#if GlobalVars.toggleCompass == 1:
			#	compass.visible = true
			#else:
			#	compass.visible = false
		#	player.playerState = "move"
	elif Input.is_action_just_pressed("ui_cancel") || Input.is_action_just_pressed("pause"):
		optionsMenuVisible = true
		visible = true
		ui.visible = false
		#player.playerState = "talk"
		if !gotFocus:
			$OptionsMenu/TurnSpeed.grab_focus()
			gotFocus = true

func _on_FootstepSFX_pressed():
	if GlobalVars.toggleFootstepSFX == 0:
		GlobalVars.toggleFootstepSFX = 1
		$OptionsMenu/FootstepSFX/Text.text = "Footstep SFX [ON]"
	else:
		GlobalVars.toggleFootstepSFX = 0
		$OptionsMenu/FootstepSFX/Text.text = "Footstep SFX [OFF]"


func _on_Dither_pressed():
	if GlobalVars.toggleDither == 0:
		GlobalVars.toggleDither = 1
		dither.visible = true
		$OptionsMenu/Dither/Text.text = "Overlay [ON]"
	else:
		GlobalVars.toggleDither = 0
		dither.visible = false
		$OptionsMenu/Dither/Text.text = "Overlay [OFF]"


func _on_Controls_pressed():
	$OptionsMenu.hide()
	$ControllerMenu.visible = true
	controllerMenuVisible = true


func _on_Quit_pressed():
	_save(GlobalVars.gotTorch, "savegame")
	_save(GlobalVars.gotKnife, "savegame")
	_save(GlobalVars.gotBike, "savegame")
	_save(GlobalVars.toggleDither, "savegame")
	_save(GlobalVars.toggleFootstepSFX, "savegame")
	_save(GlobalVars.toggleCompass, "savegame")
	_save(GlobalVars.turnSpeed, "savegame")
	_save(GlobalVars.muteMusic, "savegame")
	yield(get_tree().create_timer(1), "timeout")
	get_tree().quit()
func _save(content, path):
	print_debug("saved!")
	var file = File.new()
	file.open("res://" + path, file.WRITE)
	file.store_var(content)
	file.close()
	
	


func _on_TurnSpeed_pressed():
	if GlobalVars.turnSpeed == 1:
		$OptionsMenu/TurnSpeed/Text.text = "Turn Speed [FAST]"
		GlobalVars.turnSpeed = 2
		#print("fast")
		#print(GlobalVars.turnSpeed)
	elif GlobalVars.turnSpeed == 2:
		#print("slow")
		#print(GlobalVars.turnSpeed)
		$OptionsMenu/TurnSpeed/Text.text = "Turn Speed [SLOW]"
		GlobalVars.turnSpeed = 0
		#print("slow")
		#print(GlobalVars.turnSpeed)
	elif GlobalVars.turnSpeed == 0:
		#print("med")
		#print(GlobalVars.turnSpeed)
		$OptionsMenu/TurnSpeed/Text.text = "Turn Speed [MED]"
		GlobalVars.turnSpeed = 1
		#print("med")
		#print(GlobalVars.turnSpeed)


func _on_Music_pressed():
	if GlobalVars.muteMusic == 1:
		GlobalVars.muteMusic = 0
		$OptionsMenu/Music/Text.text = "Music [ON]"
	else:
		GlobalVars.muteMusic = 1
		$OptionsMenu/Music/Text.text = "Music [OFF]"


func _on_Compass_pressed():
	if GlobalVars.toggleCompass == 0:
		if GlobalVars.currentScene != "room":
			compass.visible = true
		GlobalVars.toggleCompass = 1
		$OptionsMenu/Compass/Text.text = "Compass [ON]"
	else:
		GlobalVars.toggleCompass = 0
		compass.visible = false
		$OptionsMenu/Compass/Text.text = "Compass [OFF]"
