extends KinematicBody

export var mouse_sens = 0.5

var controlType = 0 #0 = controller, 1 = m/k

var effect = 1

var autoWalk = false

var itemNum = 0

var rotateSpeed = rotate_y(+0.03)

var zoomLevel = 40
var zoomSpeed = 2
var zoomDefault = 70

var lookLevel = 0

var collisionBody = null
var cameraAngle = 0
var mouseLock = 0
var playerState = "move"
var move_vec = Vector3()
#"move" player can interact with world normally
#"talk" player cannot move or look without dismissing text box
#"stop" player can only look with mouse

onready var HUD = get_node("/root/Game/HUD")
onready var textBox = get_node("/root/Game/HUD/TextBox")
#onready var textPanel = get_node("/root/Game/HUD/Panel/AnimationPlayer")
onready var hudCrosshair = get_node("/root/Game/HUD/UI/Crosshair")
onready var hudCrosshairActive = get_node("/root/Game/HUD/UI/CrosshairActive")
#onready var hudCrosshairActiveAnim = get_node("/root/Game/HUD/UI/CrosshairActive/AnimationPlayer")
#onready var nextButton = get_node("/root/Game/HUD/NextButton")
onready var playerBody = get_node("/root/Game/Player")
#onready var compass = get_node("/root/Game/Compass/Viewport/MeshInstance")

#onready var anim = $POVBody/AnimationPlayer
onready var camera = $Camera
#onready var headBobCam = $Camera/AnimationPlayer
onready var character_mover = $CharacterMover
onready var meshBody = $MeshBody
onready var ambLight = $Camera/AmbLight
onready var torch = $Camera/Torch
onready var torchModel = $Items/Viewport/Torch
onready var torchSFX = $Camera/Torch/TorchSFX
onready var knifeModel = $Items/Viewport/Knife
onready var knifeSFX = $Items/Viewport/Knife/AudioStreamPlayer
onready var stabSFX = $Items/Viewport/Knife/AudioStreamPlayer2
onready var knifeAnim = $Items/Viewport/Knife/AnimationPlayer
onready var bikeModel = $Items/Viewport/Bike
onready var bikeSFX = $Items/Viewport/Bike/AudioStreamPlayer
onready var redFlash = get_node("/root/Game/HUD/Flash/AnimationPlayer")
onready var bedSFX = $SFXBed
onready var compass = $Camera/Compass/Viewport/MeshInstance

#var myOrigin = get_global_transform().origin

var rayCast 
var rayCastKnife

func _ready():
	compass.rotation.y = rotation.y
	meshBody.visible = false
	$AudioStreamPlayer.play()
	$AudioStreamPlayer.stream_paused = true
	#show equipped item
	GlobalVars.itemEquipped = ""
	#Input.set_mouse_mode(Input.MOUSE_MODE_VISIBLE)
	#if controlType == 0:
	#	Input.set_mouse_mode(Input.MOUSE_MODE_VISIBLE)
	#else:
	#	Input.set_mouse_mode(Input.MOUSE_MODE_CAPTURED)
	rayCast = get_node("Camera/RayCast")
	rayCastKnife = get_node("Camera/RayCastKnife")
#	GlobalVars.playerOrigin = myOrigin
	character_mover.init(self)

# warning-ignore:unused_argument
func _physics_process(delta):
	#save player coords for later
#	myOrigin = get_global_transform().origin
#	GlobalVars.playerOrigin = myOrigin
	#fullscreen toggle
	if Input.is_action_just_pressed("fullscreen_toggle"):
		OS.window_fullscreen = !OS.window_fullscreen
	if Input.is_action_just_pressed("quit"):
		#get_tree().quit()
		pass
	
	if playerState != "talk" and playerState != "stop" and playerState != "talk":
		raycast_interaction()
		player_movement()
#		attack()
		#zoom_camera()
		
		if GlobalVars.currentScene != "room":
			use_item()
			cycle_items()
			wake_up()
		debug()
		if controlType == 0:
			rotate_player()
			look()
		#reset_view()

func rotate_player():
		#Move camera
	#if Input.is_action_pressed("turn_left"):
	if Input.is_action_pressed("move_left"):
		if GlobalVars.turnSpeed == 1:
			playerBody.rotate_y(+0.03)
			compass.rotate_y(+0.03)
		elif GlobalVars.turnSpeed == 2:
			playerBody.rotate_y(+0.04)
			compass.rotate_y(+0.04)
		elif GlobalVars.turnSpeed == 0:
			playerBody.rotate_y(+0.02)
			compass.rotate_y(+0.02)
	#elif Input.is_action_pressed("turn_right"):
	elif Input.is_action_pressed("move_right"):
		if GlobalVars.turnSpeed == 1:
			playerBody.rotate_y(-0.03)
			compass.rotate_y(-0.03)
		elif GlobalVars.turnSpeed == 2:
			playerBody.rotate_y(-0.04)
			compass.rotate_y(-0.04)
		elif GlobalVars.turnSpeed == 0:
			playerBody.rotate_y(-0.02)
			compass.rotate_y(-0.02)

		
	
	#Unlock/lock mouse
	if Input.is_action_just_pressed("ui_cancel"):
		if Input.get_mouse_mode() == Input.MOUSE_MODE_VISIBLE:
			#Input.set_mouse_mode(Input.MOUSE_MODE_CAPTURED)
			pass
		else:
			#Input.set_mouse_mode(Input.MOUSE_MODE_VISIBLE)
			pass
	


#
func _input(event):
	if playerState != "talk":
#		#Move camera
#		if Input.is_action_pressed("turn_left"):
#			playerBody.rotate_0(+0.1)
#		elif Input.is_action_pressed("turn_right"):
#			playerBody.rotate_y(-0.1)
		if event is InputEventMouseMotion && controlType == 1:
			rotation_degrees.y -= mouse_sens * event.relative.x
			camera.rotation_degrees.x -= mouse_sens * event.relative.y
			camera.rotation_degrees.x = clamp(camera.rotation_degrees.x, -90, 90)

		

#func play_anim(name):
#	if anim.current_animation == name:
#		return
#	anim.play(name)

func raycast_interaction():
		#Raycast Hit
		rayCast.force_raycast_update()
		if(rayCast.is_colliding()) and is_on_floor():
			var collisionBody = rayCast.get_collider()
			if "myType" in collisionBody:
				hudCrosshair.visible = false
				hudCrosshairActive.visible = true
				if Input.is_action_just_pressed("use"):
					collisionBody.activated = true
		else:
			hudCrosshair.visible = true
			hudCrosshairActive.visible = false
			#print(collisionBody)
		
		#Clear textbox if raycast isnt touching anything
		#if(rayCast.is_colliding() == false) and Input.is_action_just_pressed("mouse_l"):
		#	textBox.set_text("")

#item cycle and usage

func cycle_items():
	if Input.is_action_just_pressed("change_item"):
		if itemNum == 1:
			torchModel.visible = false
			torch.visible = false
		elif itemNum == 2:
			knifeModel.visible = false
		elif itemNum == 3:
			bikeModel.visible = false
		itemNum +=1
		#equip torch
		if itemNum == 1:
			if GlobalVars.gotTorch == 1:
				#torchSFX.play()
				#print("equipped torch")
				torchModel.visible = true
				GlobalVars.itemEquipped = "torch"
				torch.visible = true
			else:
				itemNum += 1
		#equip knife
		if itemNum == 2:
			if GlobalVars.gotKnife == 1:
				#knifeSFX.play()
				#print("equipped knife")
				knifeModel.visible = true
				GlobalVars.itemEquipped = "knife"
			else:
				itemNum += 1
		#equip bike
		if itemNum == 3:
			if GlobalVars.gotBike == 1:
				$AudioStreamPlayer.stream_paused = true
				#knifeSFX.play()
				#print("equipped knife")
				bikeModel.visible = true
				GlobalVars.itemEquipped = "bike"
			else:
				itemNum += 1
		#return to empty hands
		if itemNum > 3:
			itemNum = 0
			GlobalVars.itemEquipped = ""
		#print(itemNum)

func use_item():
	if GlobalVars.itemEquipped == "torch":
		torch()
	elif GlobalVars.itemEquipped == "knife":
		knife()
	elif GlobalVars.itemEquipped == "bike":
		bike()

func torch():
	if Input.is_action_just_pressed("effect"):
		torchSFX.play()
		pass
		if torch.visible == true:
			torch.visible = false
		else:
			torch.visible = true	

func knife():
	if Input.is_action_just_pressed("effect"):
		#knifeSFX.play()
		knifeAnim.play("Stab")
		rayCastKnife.force_raycast_update()
		if(rayCastKnife.is_colliding()) and is_on_floor():
			var collisionBody = rayCastKnife.get_collider()
			if "stabbed" in collisionBody:
				stabSFX.play()
				redFlash.play("FlashRed")
				collisionBody.stabbed = true

func bike():
	#play bell sfx
	if Input.is_action_just_pressed("effect"):
		if bikeSFX.is_playing() == false:
			bikeSFX.play()
	pass

func wake_up():
	if Input.is_action_just_pressed("wake_up"):
		GlobalVars.wakeUp = true
		GlobalVars.transitionType = "fade"
		GlobalVars.currentScene = "room"
		SceneChanger.change_scene("res://levels/Room.tscn")
		#bedSFX.play()

func look():
	if Input.is_action_pressed("look_up") && lookLevel < 90:
		camera.rotation_degrees.x += 1
		lookLevel += 1
	elif Input.is_action_pressed("look_down") && lookLevel != -60:
		camera.rotation_degrees.x -= 1
		lookLevel -= 1

func reset_view():
	if effect != 2 && lookLevel != 0:
		camera.rotation_degrees.x -= 1
		lookLevel -= 1

func player_movement():
		#Walking

	
	var move_vec = Vector3()
	if Input.is_action_just_pressed("auto_walk") && !autoWalk && playerState == "move":
		autoWalk = true
	elif Input.is_action_just_pressed("auto_walk") && autoWalk:
		autoWalk = false
	elif playerState == "stop" || playerState == "talk":
		autoWalk = false
	else:			
		if Input.is_action_pressed("move_forwards"):
			autoWalk = false
			move_vec += Vector3.FORWARD
		if Input.is_action_pressed("move_backwards"):
			autoWalk = false
			move_vec += Vector3.BACK
		#if Input.is_action_pressed("ui_left"):
		#	move_vec += Vector3.LEFT
		#if Input.is_action_pressed("ui_right"):
	#	move_vec += Vector3.RIGHT
	if autoWalk:
		move_vec += Vector3.FORWARD
	character_mover.set_move_vec(move_vec)
	if Input.is_action_just_pressed("jump") && GlobalVars.currentScene != "room":
		character_mover.jump()
	#elif Input.is_action_just_released("sprint"):
	#	character_mover.stop()
	   

	   
			
	#Footstep sfx & animation
	if GlobalVars.itemEquipped != "bike":
		if GlobalVars.toggleFootstepSFX == 1:
			if character_mover.pressed_jump == true:
				$AudioStreamPlayer.stream_paused = true
				$AudioStreamPlayer.seek(0)
			elif move_vec.x == 0 && move_vec.z == 0:
				$AudioStreamPlayer.stream_paused = true
				$AudioStreamPlayer.seek(0)
			elif character_mover.jumping == false && is_on_floor():
				$AudioStreamPlayer.stream_paused = false
			elif !is_on_floor():
				$AudioStreamPlayer.stream_paused = true
			#	$AudioStreamPlayer.seek(0)
		else:
			$AudioStreamPlayer.stream_paused = true
			$AudioStreamPlayer.seek(0)

func zoom_camera():
	if Input.is_action_pressed("mouse_r") and camera.fov > zoomLevel:
		camera.fov -= zoomSpeed
	elif Input.is_action_pressed("mouse_r"):
		camera.fov = zoomLevel
	elif camera.fov < zoomDefault:
		camera.fov += zoomSpeed



				
func debug():
	if Input.is_action_just_pressed("debug1"):
		#print("debug1")
		#GlobalVars.gotTorch = 1
		#GlobalVars.gotKnife = 1
		#GlobalVars.gotBike = 1
		pass
		
	if Input.is_action_just_pressed("debug2"):
		print("debug2")
		if HUD.visible:
			#HUD.visible = false
			#compass.visible = false
			pass
		else:
			#HUD.visible = true
			#compass.visible = true
			pass
	if Input.is_action_just_pressed("debug3"):
		#print("debug3")
		if compass.visible:
			#compass.visible = false
			pass
		else:
			#compass.visible = true
			pass
			
	pass
	
	



