extends CanvasLayer


onready var playerMode = get_node("/root/Game/Player")
onready var crosshair = get_node("/root/Game/HUD/Crosshair")

func _process(delta):
	if Input.is_action_just_pressed("pause"):
		if $Options.visible == true:
			get_tree().paused = false
			crosshair.show()
			Input.set_mouse_mode(Input.MOUSE_MODE_CAPTURED)
			playerMode.playerState = "move"
			layer = -10
			$Options.hide()
		else:
			get_tree().paused = true
			crosshair.hide()
			Input.set_mouse_mode(Input.MOUSE_MODE_VISIBLE)
			playerMode.playerState = "stop"
			layer = 99
			$Options.show()
