extends Label


#onready var panelAnim = $AnimationPlayer
onready var textBox = get_node("/root/Game/HUD/TextBox")
onready var animationPlayer = get_node("/root/Game/HUD/TextBox/AnimationPlayer")
onready var playerCam = get_node("/root/Game/Player/Camera")
#onready var nextButton = get_node("/root/Game/HUD/NextButton")
onready var playerBody = get_node("/root/Game/Player")
onready var footstepSFX = get_node("/root/Game/Player/AudioStreamPlayer")
#onready var crosshair = get_node("/root/Game/HUD/Crosshair")

# warning-ignore:unused_argument
func _physics_process(delta):
	if playerBody.playerState == "talk":
		#print("talk state")
		footstepSFX.stream_paused = true
		if Input.is_action_just_pressed("use"):
			#print("use pressed")
			incrementPage()
  
func incrementPage():
	if GlobalVars.page > 0 and GlobalVars.pageRead != GlobalVars.page:
		GlobalVars.pageRead += 1
		GlobalVars.callNextPage = true
	else:
		closeTextBox()

func closeTextBox():
	animationPlayer.play_backwards("Slide")
	#nextButton.hide()
	textBox.set_text("")
	yield(animationPlayer, "animation_finished")
	GlobalVars.page = 0
	GlobalVars.pageRead = 0
	playerCam.current = true
	playerBody.playerState = "move"
	#loadFont.defaultFont()
	#crosshair.visible = true
