extends Spatial

var body_to_move : KinematicBody = null

export var move_accel = 4
export var max_speed = 10
export var move_accel_bike = 1.5#.5
export var max_speed_bike = 10
var drag = 0.0
export var jump_force = 12
export var gravity = 45

var jumping = false
var pressed_jump = false
var move_vec : Vector3
var velocity : Vector3
var snap_vec : Vector3
export var ignore_rotation = false

signal movement_info

var frozen = false

func _ready():
	drag = float(move_accel) / max_speed

func init(_body_to_move: KinematicBody):
	body_to_move = _body_to_move

func jump():
	pressed_jump = true

func set_move_vec(_move_vec: Vector3):
	move_vec = _move_vec.normalized()

func _physics_process(delta):
	if GlobalVars.itemEquipped == "bike":
		drag = float(move_accel_bike) / max_speed_bike
	else:
		drag = float(move_accel) / max_speed
	#print_debug(velocity)
	if frozen:
		return
	var cur_move_vec = move_vec
	if !ignore_rotation:
		cur_move_vec = cur_move_vec.rotated(Vector3.UP, body_to_move.rotation.y)
	velocity += move_accel * cur_move_vec - velocity * Vector3(drag, 0, drag) + gravity * Vector3.DOWN * delta
	#if pressed_jump:
	#	body_to_move.move_and_slide_with_snap(velocity, Vector3.UP, true, 4, 1.22173)
	#else:
	#	body_to_move.move_and_slide(velocity, Vector3.UP, true, 4, 1.22173)
	body_to_move.move_and_slide(velocity, Vector3.UP, true, 4, 1.22173)
	var slides = body_to_move.get_slide_count()
	if (slides):
		slopes(slides)

func slopes (slides : int):
	for i in slides:
		var touched = body_to_move.get_slide_collision(i)
		if body_to_move.is_on_floor() && touched.normal.y < .01 && (velocity.x != 0.0 || velocity.z != 0.0):
			velocity.y = touched.normal.y
	
	var grounded = body_to_move.is_on_floor()
	if grounded:
		jumping = false
		velocity.y = -0.01
	if grounded and pressed_jump:
		jumping = true
		velocity.y = jump_force
		snap_vec = Vector3.ZERO
	else:
		snap_vec = Vector3.DOWN
	pressed_jump = false
	emit_signal("movement_info", velocity, grounded)

func freeze():
	frozen = true

func unfreeze():
	frozen = false

