//CONTROLS
boolean right, left, up, down, Q, E, typing, backspace, enter, shift, escape;
void keyPressed() {
  switch(key) {
  case 'd':
    right = true;
    break;
  case 'a':
    left = true;
    break;
  case 'w':
    up = true;
    break;
  case 's':
    down = true;
    break;
  case 'e':
    E = true;
    break;
  case 'q':
    Q = true;
    break;
  case BACKSPACE:
    backspace = true;
    break;
  case ENTER:
    enter = true;
    break;
  case SHIFT:
    shift = true;
    break;
  case ESC:
    escape = true;
    break;
  case 'D':
    right = true;
    break;
  case 'A':
    left = true;
    break;
  case 'W':
    up = true;
    break;
  case 'S':
    down = true;
    break;
  case 'E':
    E = true;
    break;
  case 'Q':
    Q = true;
    break;
  }

  if (pausemenu) if (key == ESC) key = 0;
  typing = true;
}


void keyReleased() {
  switch(key) {
  case 'd':
    right = false;
    break;
  case 'a':
    left = false;
    break;
  case 'w':
    up = false;
    break;
  case 's':
    down = false;
    break;
  case 'e':
    E = false;
    break;
  case 'q':
    Q = false;
    break;
  case BACKSPACE:
    backspace = false;
    break;
  case ENTER:
    enter = false;
    break;
  case SHIFT:
    shift = false;
    break;
  case ESC:
    escape = false;
    break;
  case 'D':
    right = false;
    break;
  case 'A':
    left = false;
    break;
  case 'W':
    up = false;
    break;
  case 'S':
    down = false;
    break;
  case 'E':
    E = false;
    break;
  case 'Q':
    Q = false;
    break;
  }
  typing = false;
}

boolean m1, m2;
void mousePressed() {
  if (mouseButton == LEFT) m1 = true;
  if (mouseButton == RIGHT) m2 = true;
}

void mouseReleased() {
  if (mouseButton == LEFT) m1 = false;
  if (mouseButton == RIGHT) m2 = false;
}

//HITBOX DOT TO SQAURE
boolean hitbox(int x, int y, int w, int h, int xx, int yy) {
  boolean return_bool;
  if (xx > x && xx < w + x && yy > y && yy < h + y) return_bool = true;
  else return_bool = false;
  return return_bool;
}



//FRAME
void sideBars() {
  fill(0);
  rect(width/2-500, 0, width/2+500, height/2-500);
  rect(width/2-500, height/2+500, width/2+500, height);
  rect(0, 0, width/2-500, height);
  rect(width/2+500, 0, width, height);
}

//FULLSCREEN TO WINDOW MODE
boolean fullscreen;
void windowSize() {
  if (Q)  fullscreen = !fullscreen;
  if (Q)  Q = false;

  if (fullscreen)            surface.setSize(500, 500);
  if (fullscreen)            surface.setLocation(displayWidth/2-250, displayHeight/2-250);
  if (fullscreen == false)   surface.setSize(displayWidth, displayHeight);
}

int time = 0;
void time() {
  time++;
  if (time == 60) time = 0;
}

//SET_VOLUME
float amp = 0.05;

void volume() {
  if (left) amp-=0.01;
  if (right)amp+=0.01;
  amp = constrain(amp, 0.0, 1.0);
  volume.volume(amp);
}



//LOADIMAGE
PImage[] imageList = new PImage[imageListSize+1];
PImage[] backgroundList = new PImage[backgroundListSize+1];
void imageLoading() {
  for (int i = 0; i < imageList.length; i++) imageList[i] = loadImage("img"+ i +".png");
  for (int i = 0; i < backgroundList.length; i++) backgroundList[i] = loadImage("background"+ i +".png");
  imageMode(CENTER);
}


//LOADFONT
void fontLoading() {
  font = createFont("font.ttf", 128);
  textFont(font);
  textSize(100);
  textAlign(CENTER);
}

//LOADSOUND
SoundFile[] soundList = new SoundFile[soundListSize + 1];
SoundFile[] songList = new SoundFile[songListSize + 1];
Sound volume;
void soundLoading() {
  for (int i = 0; i < soundList.length; i++) soundList[i] = new SoundFile(this, "SOUND"+ i +".wav");
  for (int i = 0; i < songList.length; i++) songList[i] = new SoundFile(this, "SONG"+ i +".wav");
  volume = new Sound(this);
  volume.volume(amp);
}


int[][][] array = new int[100][100][arrays];
void load() {
  for (int ii = 0; ii < arrays; ii++) {
    String[] leveldata = loadStrings("leveldata" + ii + ".txt");
    for (int i = 0; i < leveldata.length; i++) {
      String[] data = split(leveldata[i], ',');
      array[int(data[0])] [int(data[1])] [ii] = int(data[2]);
    }
  }
}




int world = 0;
//BACKGROUND
void BACKGROUND() {
  pushMatrix();
  translate(width/2, height/2);
  //translate(-player.x,-player.y);
  image(backgroundList[array[int(player.x)/1000][int(player.y)/1000][world]],0,0);
  popMatrix();
}
