//=============================================================================
// VisuStella MZ - Message Keywords
// VisuMZ_3_MessageKeywords.js
//=============================================================================

var Imported = Imported || {};
Imported.VisuMZ_3_MessageKeywords = true;

var VisuMZ = VisuMZ || {};
VisuMZ.MessageKeywords = VisuMZ.MessageKeywords || {};
VisuMZ.MessageKeywords.version = 1.04;

//=============================================================================
 /*:
 * @target MZ
 * @plugindesc [RPG Maker MZ] [Tier 3] [Version 1.04] [MessageKeywords]
 * @author VisuStella
 * @url http://www.yanfly.moe/wiki/Message_Keywords_VisuStella_MZ
 * @base VisuMZ_1_MessageCore
 * @orderAfter VisuMZ_1_MessageCore
 *
 * @help
 * ============================================================================
 * Introduction
 * ============================================================================
 *
 * This plugin adds Keyword support for the Message Window and any others
 * listed in the Plugin Parameters. By having Keyword support, the player can
 * hover their mouse cursor over the Keyword and a tooltip window will appear,
 * explaining further about the Keyword in question. This can be used in the
 * Message Window to explain lore, in the Help Window to go into detail about
 * more complex mechanics, and more!
 *
 * Features include all (but not limited to) the following:
 * 
 * * Setup Keywords within the Plugin Parameters.
 * * Keywords determine how the Keyword marker will be replaced and what kind
 *   of text will be displayed in the tooltip window.
 * * Use Keywords to explain or remind the player about lore heavy topics.
 * * Keywords can be used to explain indepth mechanics inside Help Window.
 * * Alter the tooltip window's settings to your liking.
 *
 * ============================================================================
 * Requirements
 * ============================================================================
 *
 * This plugin is made for RPG Maker MZ. This will not work in other iterations
 * of RPG Maker.
 *
 * ------ Required Plugin List ------
 *
 * * VisuMZ_1_MessageCore
 *
 * This plugin requires the above listed plugins to be installed inside your
 * game's Plugin Manager list in order to work. You cannot start your game with
 * this plugin enabled without the listed plugins.
 *
 * ------ Tier 3 ------
 *
 * This plugin is a Tier 3 plugin. Place it under other plugins of lower tier
 * value on your Plugin Manager list (ie: 0, 1, 2, 3, 4, 5). This is to ensure
 * that your plugins will have the best compatibility with the rest of the
 * VisuStella MZ library.
 * 
 * ============================================================================
 * Instructions
 * ============================================================================
 * 
 * Here are the instructions on how to use this plugin.
 * 
 * ---
 * 
 * Step 1:
 * 
 * - Open up the Plugin Parameters for this plugin.
 * - Open up the "Keyword List" Parameter list.
 * - Add your own or modify existing Keywords.
 *   - The "Keyword" is the Keyword Marker that will be referenced when using a
 *     Keyword inside of the Message Window or Help Window. Remember this.
 *   - The "Replacement Text" is the text that appears in place of the Keyword
 *     Marker. This can be used to color code or as a shortcut for Keywords.
 *     - Replacement text does not have to be exactly the same as the Keyword.
 *   - "Tooltip Text" is the text that appears inside the tooltip window when
 *     the player's mouse cursor hovers over the Keyword.
 * - Save your changes.
 * 
 * ---
 * 
 * Step 2:
 * 
 * - Create a new "Show Message" event command or modify a database object's
 *   help "Description".
 * - Insert the Keyword Marker in the following format: ((Keyword))
 *   - Replace "Keyword" with the Keyword Marker mentioned in Step 1.
 *   - To use the default examples, you can type in ((Example)) or ((Ojima)).
 * - Save the changes.
 * - Go view them in game.
 * - Hover the mouse cursor over the specific Keywords and a tooltip window
 *   should appear.
 * 
 * ---
 * 
 * Tooltip window text does not support Word Wrap. It is simply disabled from
 * the very start so any Word Wrap text codes will not work with it.
 * 
 * ---
 *
 * ============================================================================
 * Extra Features
 * ============================================================================
 *
 * There are some extra features found if other VisuStella MZ plugins are found
 * present in the Plugin Manager list.
 *
 * ---
 * 
 * VisuMZ_1_ElementStatusCore
 * 
 * VisuMZ_1_ItemsEquipsCore
 *
 * VisuMZ_2_QuestSystem
 * 
 * VisuMZ_3_MessageLog
 * 
 * VisuMZ_3_VisualTextWindows
 *
 * - Custom windows provided by these plugins will have Keyword support as long
 * as their respective window names are listed in the Plugin Parameters.
 *
 * ---
 *
 * ============================================================================
 * Available Text Codes
 * ============================================================================
 *
 * The following are text codes that you may use with this plugin. 
 *
 * === Keyword-Related Text Codes ===
 * 
 * ---
 *
 * --------------------   -----------------------------------------------------
 * Text Code              Effect (Supported Message Windows)
 * --------------------   -----------------------------------------------------
 * 
 * ((Keyword))            Replaces the "Keyword" Marker with the Replacement
 *                        Text found in the Message Keywords Plugin Parameters.
 *                        If the player hovers the mouse cursor over a Keyword,
 *                        a tooltip window will appear explaining about the
 *                        Keyword's lore and/or mechanics. The replacement text
 *                        and tooltip text can be modified inside the Message
 *                        Keywords Plugin Parameters.
 * 
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Keyword List
 * ============================================================================
 *
 * This array governs the Keywords that are used for the game.
 *
 * ---
 *
 * Keyword List
 * 
 *   Keyword Marker:
 *   - This is the marker used to determine the tooltip and any associated text
 *   - To use this inside the Message Window or Help Description, type out the
 *     following:
 * 
 *     ((Keyword))
 * 
 *     Where "Keyword" would be the Keyword Marker used. Case does not matter.
 * 
 *   Replacement Text:
 *   - The text displayed as a replacement for the tooltip.
 *   - You may use text codes.
 * 
 *   Tooltip Text:
 *   - The text displayed for this tooltip.
 *   - You may use text codes.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Tooltip Settings
 * ============================================================================
 *
 * Settings for the Message Keyword Tooltips Window.
 *
 * ---
 *
 * Appearance
 * 
 *   Scale:
 *   - What scale size do you want for the tooltip?
 *   - Use 1.0 for normal size.
 * 
 *   Skin Filename:
 *   - What window skin do you want to use for the tooltip?
 * 
 *   Skin Opacity:
 *   - What opacity setting is used for the tooltip?
 *   - Use a number between 0 and 255.
 *
 * ---
 *
 * Offset
 * 
 *   Offset X:
 *   - Offset the tooltip X position from the mouse?
 *   - Negative: left. Positive: right.
 * 
 *   Offset Y:
 *   - Offset the tooltip Y position from the mouse?
 *   - Negative: up. Positive: down.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Supported Windows
 * ============================================================================
 *
 * Message Keyword support will be provided to these windows.
 * Not every window is a valid candidate, however.
 *
 * ---
 *
 * Supported Windows
 * 
 *   String:
 *   - Type in the constructor name of window you wish to add to the supported
 *     Window list.
 *   - Any windows not on the list will not support Keywords in the sense that
 *     tooltips will not appear. However, Keyword Markers can still be used to
 *     offer a quick shortcut to replacement text outside of tooltip windows.
 *   - Any of the windows listed here will have their refresh functions monkey
 *     patched via JavaScript to support Message Keywords.
 *
 * ---
 *
 * ============================================================================
 * Terms of Use
 * ============================================================================
 *
 * 1. These plugins may be used in free or commercial games provided that they
 * have been acquired through legitimate means at VisuStella.com and/or any
 * other official approved VisuStella sources. Exceptions and special
 * circumstances that may prohibit usage will be listed on VisuStella.com.
 * 
 * 2. All of the listed coders found in the Credits section of this plugin must
 * be given credit in your games or credited as a collective under the name:
 * "VisuStella".
 * 
 * 3. You may edit the source code to suit your needs, so long as you do not
 * claim the source code belongs to you. VisuStella also does not take
 * responsibility for the plugin if any changes have been made to the plugin's
 * code, nor does VisuStella take responsibility for user-provided custom code
 * used for custom control effects including advanced JavaScript notetags
 * and/or plugin parameters that allow custom JavaScript code.
 * 
 * 4. You may NOT redistribute these plugins nor take code from this plugin to
 * use as your own. These plugins and their code are only to be downloaded from
 * VisuStella.com and other official/approved VisuStella sources. A list of
 * official/approved sources can also be found on VisuStella.com.
 *
 * 5. VisuStella is not responsible for problems found in your game due to
 * unintended usage, incompatibility problems with plugins outside of the
 * VisuStella MZ library, plugin versions that aren't up to date, nor
 * responsible for the proper working of compatibility patches made by any
 * third parties. VisuStella is not responsible for errors caused by any
 * user-provided custom code used for custom control effects including advanced
 * JavaScript notetags and/or plugin parameters that allow JavaScript code.
 *
 * 6. If a compatibility patch needs to be made through a third party that is
 * unaffiliated with VisuStella that involves using code from the VisuStella MZ
 * library, contact must be made with a member from VisuStella and have it
 * approved. The patch would be placed on VisuStella.com as a free download
 * to the public. Such patches cannot be sold for monetary gain, including
 * commissions, crowdfunding, and/or donations.
 * 
 * 7. If this VisuStella MZ plugin is a paid product, all project team members
 * must purchase their own individual copies of the paid product if they are to
 * use it. Usage includes working on related game mechanics, managing related
 * code, and/or using related Plugin Commands and features. Redistribution of
 * the plugin and/or its code to other members of the team is NOT allowed
 * unless they own the plugin itself as that conflicts with Article 4.
 * 
 * 8. Any extensions and/or addendums made to this plugin's Terms of Use can be
 * found on VisuStella.com and must be followed.
 *
 * ============================================================================
 * Credits
 * ============================================================================
 * 
 * If you are using this plugin, credit the following people in your game:
 * 
 * Team VisuStella
 * * Irina
 * * Arisu
 * * Olivia
 * * Yanfly
 *
 * ============================================================================
 * Changelog
 * ============================================================================
 * 
 * Version 1.04: March 14, 2024
 * * Bug Fixes!
 * ** Fixed a bug that would cause a crash upon opening up the log window.
 *    Fix made by Irina.
 * 
 * Version 1.03: August 11, 2022
 * * Bug Fixes!
 * ** Fixed a bug that caused games with a sleeping mouse on initialization to
 *    always trigger the tooltip window. Fix made by Arisu.
 * 
 * Version 1.02: April 21, 2022
 * * Compatibility Update!
 * ** Added compatibility update with VisuMZ's Quest Journal System to not
 *    auto-clear the keyword tooltip window when tracking variables are being
 *    updated with the Quest Tracker open. Update made by Arisu.
 * 
 * Version 1.01: February 24, 2022
 * * Feature Update!
 * ** Variables are now parsed before and after the parsing of keywords.
 *    Update made by Arisu.
 * 
 * Version 1.00 Official Release Date: December 8, 2021
 * * Finished Plugin!
 *
 * ============================================================================
 * End of Helpfile
 * ============================================================================
 *
 * @ ==========================================================================
 * @ Plugin Parameters
 * @ ==========================================================================
 *
 * @param BreakHead
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param MessageKeywords
 * @default Plugin Parameters
 *
 * @param ATTENTION
 * @default READ THE HELP FILE
 *
 * @param BreakSettings
 * @text --------------------------
 * @default ----------------------------------
 * 
 * @param Keywords:arraystruct
 * @text Keyword List
 * @parent Keywords
 * @type struct<Keyword>[]
 * @desc This is a list of Keywords used for this plugin.
 * @default ["{\"Keyword:str\":\"Example\",\"Text:str\":\"\\\\c[5]Example\\\\c[0]\",\"Tooltip:json\":\"\\\"This is an example to show how \\\\\\\\c[5]Keywords\\\\\\\\c[0] work.\\\\n\\\\nBy typing \\\\\\\\c[6]((Example))\\\\\\\\c[0] in the \\\\\\\\c[4]Message Window\\\\\\\\c[0],\\\\nit creates an area that the player can hover\\\\nthe \\\\\\\\c[4]mouse\\\\\\\\c[0] over.\\\\n\\\\nOnce hovered, a \\\\\\\\c[4]tooltip\\\\\\\\c[0] will appear displaying\\\\nthis text.\\\"\"}","{\"Keyword:str\":\"Ojima\",\"Text:str\":\"\\\\c[6]Yoji Ojima\\\\c[0]\",\"Tooltip:json\":\"\\\"\\\\\\\\c[6]Yoji Ojima\\\\\\\\c[0] is the creator of many \\\\\\\\c[4]RPG Maker\\\\\\\\c[0] iterations\\\\nincluding \\\\\\\\c[4]RPG Maker MZ\\\\\\\\c[0]. Without him, \\\\\\\\c[4]RPG Maker\\\\\\\\c[0] as we\\\\nknow it would be completely different. \\\\\\\\c[4]RPG Maker MZ\\\\\\\\c[0]'s\\\\nbeautiful and clean core scripts is all thanks to this\\\\nvery talented individual.\\\"\"}"]
 *
 * @param Tooltip:struct
 * @text Tooltip Settings
 * @type struct<Tooltip>
 * @desc Settings for the Message Keyword Tooltips Window.
 * @default {"Appearance":"","Scale:num":"0.6","WindowSkin:str":"Window","WindowOpacity:num":"240","Offset":"","OffsetX:num":"+0","OffsetY:num":"+0"}
 * 
 * @param SupportedWindows:arraystr
 * @text Supported Windows
 * @type string[]
 * @desc Message Keyword support will be provided to these windows.
 * Not every window is a valid candidate, however.
 * @default ["Window_Help","Window_SkillStatus","Window_EquipStatus","Window_Status","Window_ShopStatus","Window_Message","Window_NameBox","Window_StatusData","Window_QuestLog","Window_QuestTracker","Window_MessageLog","Window_VisualText"]
 *
 * @param BreakEnd1
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param End Of
 * @default Plugin Parameters
 *
 * @param BreakEnd2
 * @text --------------------------
 * @default ----------------------------------
 *
 */
/* ----------------------------------------------------------------------------
 * Keyword Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Keyword:
 *
 * @param Keyword:str
 * @text Keyword Marker
 * @desc This is the marker used to determine the tooltip and
 * any associated text.
 * @default Untitled
 *
 * @param Text:str
 * @text Replacement Text
 * @type str
 * @desc The text displayed as a replacement for the tooltip.
 * You may use text codes.
 * @default Untitled
 * 
 * @param Tooltip:json
 * @text Tooltip Text
 * @type note
 * @desc The text displayed for this tooltip.
 * You may use text codes.
 * @default ""
 *
 */
/* ----------------------------------------------------------------------------
 * Tooltip Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Tooltip:
 *
 * @param Appearance
 *
 * @param Scale:num
 * @text Scale
 * @parent Appearance
 * @desc What scale size do you want for the tooltip?
 * Use 1.0 for normal size.
 * @default 0.6
 *
 * @param WindowSkin:str
 * @text Skin Filename
 * @parent Appearance
 * @type file
 * @dir img/system/
 * @desc What window skin do you want to use for the tooltip?
 * @default Window
 *
 * @param WindowOpacity:num
 * @text Skin Opacity
 * @parent Appearance
 * @type number
 * @min 0
 * @max 255
 * @desc What opacity setting is used for the tooltip?
 * Use a number between 0 and 255.
 * @default 240
 *
 * @param Offset
 *
 * @param OffsetX:num
 * @text Offset X
 * @parent Offset
 * @desc Offset the tooltip X position from the mouse?
 * Negative: left. Positive: right.
 * @default +0
 *
 * @param OffsetY:num
 * @text Offset Y
 * @parent Offset
 * @desc Offset the tooltip Y position from the mouse?
 * Negative: up. Positive: down.
 * @default +0
 *
 */
//=============================================================================

const _0xfec0f8=_0x1300;(function(_0x1e4d0e,_0x1284c5){const _0x43ce68=_0x1300,_0x1e56cf=_0x1e4d0e();while(!![]){try{const _0x1f77ef=parseInt(_0x43ce68(0x1d3))/0x1+-parseInt(_0x43ce68(0x1e1))/0x2+-parseInt(_0x43ce68(0x1b1))/0x3*(-parseInt(_0x43ce68(0x1b4))/0x4)+parseInt(_0x43ce68(0x1ef))/0x5+-parseInt(_0x43ce68(0x1dd))/0x6+parseInt(_0x43ce68(0x229))/0x7+-parseInt(_0x43ce68(0x207))/0x8;if(_0x1f77ef===_0x1284c5)break;else _0x1e56cf['push'](_0x1e56cf['shift']());}catch(_0x4e555c){_0x1e56cf['push'](_0x1e56cf['shift']());}}}(_0x43e9,0x1b655));var label=_0xfec0f8(0x1e0),tier=tier||0x0,dependencies=['VisuMZ_1_MessageCore'],pluginData=$plugins[_0xfec0f8(0x1b9)](function(_0x983563){const _0x4bdee9=_0xfec0f8;return _0x983563[_0x4bdee9(0x210)]&&_0x983563['description'][_0x4bdee9(0x1ee)]('['+label+']');})[0x0];VisuMZ[label][_0xfec0f8(0x1dc)]=VisuMZ[label][_0xfec0f8(0x1dc)]||{},VisuMZ[_0xfec0f8(0x204)]=function(_0x3d960d,_0x3ef5ef){const _0xe61739=_0xfec0f8;for(const _0x40202e in _0x3ef5ef){if(_0x40202e[_0xe61739(0x20b)](/(.*):(.*)/i)){const _0x36f7a3=String(RegExp['$1']),_0x3dac51=String(RegExp['$2'])[_0xe61739(0x20c)]()[_0xe61739(0x19c)]();let _0x5a02c8,_0x140d7d,_0x2a55c0;switch(_0x3dac51){case'NUM':_0x5a02c8=_0x3ef5ef[_0x40202e]!==''?Number(_0x3ef5ef[_0x40202e]):0x0;break;case _0xe61739(0x1cf):_0x140d7d=_0x3ef5ef[_0x40202e]!==''?JSON[_0xe61739(0x1c0)](_0x3ef5ef[_0x40202e]):[],_0x5a02c8=_0x140d7d[_0xe61739(0x22c)](_0x3724fc=>Number(_0x3724fc));break;case _0xe61739(0x201):_0x5a02c8=_0x3ef5ef[_0x40202e]!==''?eval(_0x3ef5ef[_0x40202e]):null;break;case _0xe61739(0x19e):_0x140d7d=_0x3ef5ef[_0x40202e]!==''?JSON[_0xe61739(0x1c0)](_0x3ef5ef[_0x40202e]):[],_0x5a02c8=_0x140d7d['map'](_0x147f8f=>eval(_0x147f8f));break;case'JSON':_0x5a02c8=_0x3ef5ef[_0x40202e]!==''?JSON[_0xe61739(0x1c0)](_0x3ef5ef[_0x40202e]):'';break;case _0xe61739(0x1ec):_0x140d7d=_0x3ef5ef[_0x40202e]!==''?JSON[_0xe61739(0x1c0)](_0x3ef5ef[_0x40202e]):[],_0x5a02c8=_0x140d7d['map'](_0xbf8361=>JSON[_0xe61739(0x1c0)](_0xbf8361));break;case'FUNC':_0x5a02c8=_0x3ef5ef[_0x40202e]!==''?new Function(JSON[_0xe61739(0x1c0)](_0x3ef5ef[_0x40202e])):new Function('return\x200');break;case'ARRAYFUNC':_0x140d7d=_0x3ef5ef[_0x40202e]!==''?JSON[_0xe61739(0x1c0)](_0x3ef5ef[_0x40202e]):[],_0x5a02c8=_0x140d7d['map'](_0x2e2860=>new Function(JSON[_0xe61739(0x1c0)](_0x2e2860)));break;case _0xe61739(0x1a0):_0x5a02c8=_0x3ef5ef[_0x40202e]!==''?String(_0x3ef5ef[_0x40202e]):'';break;case _0xe61739(0x231):_0x140d7d=_0x3ef5ef[_0x40202e]!==''?JSON[_0xe61739(0x1c0)](_0x3ef5ef[_0x40202e]):[],_0x5a02c8=_0x140d7d[_0xe61739(0x22c)](_0x11d132=>String(_0x11d132));break;case _0xe61739(0x1b6):_0x2a55c0=_0x3ef5ef[_0x40202e]!==''?JSON['parse'](_0x3ef5ef[_0x40202e]):{},_0x5a02c8=VisuMZ[_0xe61739(0x204)]({},_0x2a55c0);break;case _0xe61739(0x1fe):_0x140d7d=_0x3ef5ef[_0x40202e]!==''?JSON['parse'](_0x3ef5ef[_0x40202e]):[],_0x5a02c8=_0x140d7d['map'](_0x248371=>VisuMZ['ConvertParams']({},JSON[_0xe61739(0x1c0)](_0x248371)));break;default:continue;}_0x3d960d[_0x36f7a3]=_0x5a02c8;}}return _0x3d960d;},(_0x4872a6=>{const _0x3f93a6=_0xfec0f8,_0x64f7d=_0x4872a6['name'];for(const _0x482f1d of dependencies){if(_0x3f93a6(0x20f)!=='VhSWB')this[_0x3f93a6(0x208)]=![],this[_0x3f93a6(0x1df)]();else{if(!Imported[_0x482f1d]){alert('%1\x20is\x20missing\x20a\x20required\x20plugin.\x0aPlease\x20install\x20%2\x20into\x20the\x20Plugin\x20Manager.'[_0x3f93a6(0x226)](_0x64f7d,_0x482f1d)),SceneManager[_0x3f93a6(0x223)]();break;}}}const _0x8523ee=_0x4872a6[_0x3f93a6(0x1cd)];if(_0x8523ee[_0x3f93a6(0x20b)](/\[Version[ ](.*?)\]/i)){if(_0x3f93a6(0x1e9)==='SfRIa'){const _0x3bb182=Number(RegExp['$1']);_0x3bb182!==VisuMZ[label]['version']&&(_0x3f93a6(0x218)==='wYsZe'?this[_0x3f93a6(0x221)](_0x36523b):(alert(_0x3f93a6(0x230)[_0x3f93a6(0x226)](_0x64f7d,_0x3bb182)),SceneManager[_0x3f93a6(0x223)]()));}else{this[_0x3f93a6(0x1b0)]['clear'](),this[_0x3f93a6(0x23f)]();if(this[_0x3f93a6(0x1fc)][_0x3f93a6(0x1b8)]>0x0){this['resizeWindow']();const _0x225f26=this[_0x3f93a6(0x1c5)]();this[_0x3f93a6(0x1da)](this[_0x3f93a6(0x1fc)],_0x225f26['x'],_0x225f26['y'],_0x225f26[_0x3f93a6(0x1d4)]),this[_0x3f93a6(0x1b5)]();}else this[_0x3f93a6(0x1b0)][_0x3f93a6(0x19b)](),this[_0x3f93a6(0x239)]();}}if(_0x8523ee[_0x3f93a6(0x20b)](/\[Tier[ ](\d+)\]/i)){if(_0x3f93a6(0x1ad)!=='lPeHl')this[_0x3f93a6(0x1ca)]?this['onMouseEnter']():this[_0x3f93a6(0x1a9)]();else{const _0x25bcba=Number(RegExp['$1']);_0x25bcba<tier?(alert(_0x3f93a6(0x1c7)[_0x3f93a6(0x226)](_0x64f7d,_0x25bcba,tier)),SceneManager[_0x3f93a6(0x223)]()):tier=Math['max'](_0x25bcba,tier);}}VisuMZ['ConvertParams'](VisuMZ[label][_0x3f93a6(0x1dc)],_0x4872a6[_0x3f93a6(0x1d0)]);})(pluginData),VisuMZ[_0xfec0f8(0x1e0)][_0xfec0f8(0x1a3)]=Scene_Boot[_0xfec0f8(0x1a6)][_0xfec0f8(0x22a)],Scene_Boot['prototype'][_0xfec0f8(0x22a)]=function(){const _0x177a5d=_0xfec0f8;VisuMZ[_0x177a5d(0x1e0)][_0x177a5d(0x1a3)][_0x177a5d(0x224)](this),this[_0x177a5d(0x1a1)]();},Scene_Boot[_0xfec0f8(0x1a6)][_0xfec0f8(0x1a1)]=function(){const _0x3a1849=_0xfec0f8;VisuMZ[_0x3a1849(0x1e0)][_0x3a1849(0x1af)](),VisuMZ[_0x3a1849(0x1e0)][_0x3a1849(0x1b7)]();},VisuMZ[_0xfec0f8(0x1e0)][_0xfec0f8(0x21b)]={},VisuMZ[_0xfec0f8(0x1e0)][_0xfec0f8(0x1af)]=function(){const _0xc6b8f8=_0xfec0f8;for(const _0xd8d168 of VisuMZ['MessageKeywords'][_0xc6b8f8(0x1dc)][_0xc6b8f8(0x21b)]){if(!_0xd8d168)continue;if(!_0xd8d168[_0xc6b8f8(0x1ae)])continue;if(_0xd8d168['Keyword'][_0xc6b8f8(0x19c)]()<=0x0)continue;if(_0xd8d168[_0xc6b8f8(0x1ae)][_0xc6b8f8(0x20c)]()[_0xc6b8f8(0x19c)]()==='UNTITLED')continue;_0xd8d168['Keyword']=_0xd8d168['Keyword'][_0xc6b8f8(0x20c)]()['trim'](),VisuMZ[_0xc6b8f8(0x1e0)][_0xc6b8f8(0x21b)][_0xd8d168[_0xc6b8f8(0x1ae)]]=_0xd8d168;}},VisuMZ[_0xfec0f8(0x1e0)][_0xfec0f8(0x1a8)]='\x0a\x20\x20\x20\x20this.clearMessageKeywordSprites();\x0a\x20\x20\x20\x20VisuMZ.MessageKeywords.%1.call(this);\x0a',VisuMZ['MessageKeywords'][_0xfec0f8(0x1b7)]=function(){const _0x57323e=_0xfec0f8,_0x10d589=Window_MessageKeywordTooltip[_0x57323e(0x237)];for(const _0x95d80c of _0x10d589){if(window[_0x95d80c]&&window[_0x95d80c][_0x57323e(0x1a6)][_0x57323e(0x1df)]){if(_0x57323e(0x1db)===_0x57323e(0x1d7))this['initialize'](...arguments);else{const _0x4b2aea=_0x57323e(0x1a4)[_0x57323e(0x226)](_0x95d80c);VisuMZ[_0x57323e(0x1e0)][_0x4b2aea]=window[_0x95d80c][_0x57323e(0x1a6)][_0x57323e(0x1df)];const _0x23ba34=VisuMZ[_0x57323e(0x1e0)][_0x57323e(0x1a8)][_0x57323e(0x226)](_0x4b2aea);window[_0x95d80c][_0x57323e(0x1a6)][_0x57323e(0x1df)]=new Function(_0x23ba34);}}}},VisuMZ[_0xfec0f8(0x1e0)][_0xfec0f8(0x22b)]=Scene_Base['prototype'][_0xfec0f8(0x1b3)],Scene_Base[_0xfec0f8(0x1a6)]['createWindowLayer']=function(){const _0x23baa8=_0xfec0f8;VisuMZ['MessageKeywords'][_0x23baa8(0x22b)][_0x23baa8(0x224)](this),this[_0x23baa8(0x21d)]();},Scene_Base['prototype'][_0xfec0f8(0x21d)]=function(){const _0x5a48ce=_0xfec0f8;this['_messageKeywordTooltipWindow']=new Window_MessageKeywordTooltip(),this[_0x5a48ce(0x20a)](this[_0x5a48ce(0x1fa)]);};function Sprite_MessageKeywordTooltip(){const _0x3b9aea=_0xfec0f8;this[_0x3b9aea(0x209)](...arguments);}Sprite_MessageKeywordTooltip[_0xfec0f8(0x1a6)]=Object[_0xfec0f8(0x222)](Sprite_Clickable[_0xfec0f8(0x1a6)]),Sprite_MessageKeywordTooltip['prototype']['constructor']=Sprite_MessageKeywordTooltip,Sprite_MessageKeywordTooltip[_0xfec0f8(0x1a6)][_0xfec0f8(0x209)]=function(_0x59dfcd,_0x4748c3){const _0x334d4b=_0xfec0f8;this[_0x334d4b(0x20d)]=_0x59dfcd,Sprite_Clickable[_0x334d4b(0x1a6)]['initialize'][_0x334d4b(0x224)](this),this[_0x334d4b(0x20e)](0x0,0x0,_0x4748c3['width'],_0x4748c3[_0x334d4b(0x233)]),this['x']=_0x4748c3['x'],this['y']=_0x4748c3['y'];let _0x253dc9=![];_0x253dc9&&(this['bitmap']=new Bitmap(_0x4748c3[_0x334d4b(0x1d4)],_0x4748c3[_0x334d4b(0x233)]),this['bitmap'][_0x334d4b(0x1e7)](0x0,0x0,_0x4748c3[_0x334d4b(0x1d4)],_0x4748c3[_0x334d4b(0x233)],_0x334d4b(0x1fd)),this[_0x334d4b(0x1f1)]=0x40);},Sprite_MessageKeywordTooltip[_0xfec0f8(0x1a6)]['setParentWindow']=function(_0x5339c3){const _0xd24fdb=_0xfec0f8;this[_0xd24fdb(0x1e4)]=_0x5339c3;},Sprite_MessageKeywordTooltip[_0xfec0f8(0x1a6)][_0xfec0f8(0x1f7)]=function(){const _0x4b3fe3=_0xfec0f8;if(!this[_0x4b3fe3(0x1e4)])return![];if(!this['_parentWindow'][_0x4b3fe3(0x228)]())return![];if(!this[_0x4b3fe3(0x1e4)][_0x4b3fe3(0x23c)])return![];if(this[_0x4b3fe3(0x1e4)]['contentsOpacity']<=0x0)return![];return!![];},Sprite_MessageKeywordTooltip['prototype'][_0xfec0f8(0x234)]=function(){const _0x1286bd=_0xfec0f8;return SceneManager[_0x1286bd(0x206)][_0x1286bd(0x1fa)];},Sprite_MessageKeywordTooltip['prototype'][_0xfec0f8(0x1d6)]=function(){const _0x299694=_0xfec0f8;Sprite_Clickable['prototype'][_0x299694(0x1d6)][_0x299694(0x224)](this);const _0x184f4c=this['targetWindow']();_0x184f4c&&this['isParentWindowValid']()&&_0x184f4c[_0x299694(0x22e)](this[_0x299694(0x20d)]);},Sprite_MessageKeywordTooltip['prototype'][_0xfec0f8(0x1a9)]=function(){const _0x590fa7=_0xfec0f8;Sprite_Clickable[_0x590fa7(0x1a6)][_0x590fa7(0x1a9)][_0x590fa7(0x224)](this);const _0xeec169=this[_0x590fa7(0x234)]();_0xeec169&&_0xeec169[_0x590fa7(0x23b)]===this['_referenceString']&&_0xeec169[_0x590fa7(0x22e)](null);},Sprite_MessageKeywordTooltip[_0xfec0f8(0x1a6)][_0xfec0f8(0x1f5)]=function(){const _0x4c07c1=_0xfec0f8,_0x4c1894=this[_0x4c07c1(0x1ca)];this[_0x4c07c1(0x1ca)]=this[_0x4c07c1(0x220)](),this[_0x4c07c1(0x1ca)]!==_0x4c1894&&(this[_0x4c07c1(0x1ca)]?this['onMouseEnter']():_0x4c07c1(0x1b2)===_0x4c07c1(0x1b2)?this[_0x4c07c1(0x1a9)]():this['onMouseEnter']());},Sprite_MessageKeywordTooltip[_0xfec0f8(0x1a6)][_0xfec0f8(0x220)]=function(){const _0x55a99e=_0xfec0f8;if(TouchInput['x']===0x0&&TouchInput['y']===0x0)return![];const _0x1cfa0e=new Point(TouchInput['x'],TouchInput['y']),_0x5a4b76=this[_0x55a99e(0x1be)][_0x55a99e(0x1f3)](_0x1cfa0e);return this[_0x55a99e(0x1ce)](_0x5a4b76['x'],_0x5a4b76['y']);},VisuMZ[_0xfec0f8(0x1e0)][_0xfec0f8(0x213)]=Window_Base[_0xfec0f8(0x1a6)]['initialize'],Window_Base[_0xfec0f8(0x1a6)][_0xfec0f8(0x209)]=function(_0x3c0f73){const _0x512dff=_0xfec0f8;VisuMZ[_0x512dff(0x1e0)][_0x512dff(0x213)][_0x512dff(0x224)](this,_0x3c0f73),this[_0x512dff(0x1aa)]();},Window_Base['prototype']['clearMessageKeywordSprites']=function(){const _0x5abd09=_0xfec0f8;!this['_messageKeywordContainer']&&(this['_messageKeywordContainer']=new Sprite(),this[_0x5abd09(0x211)][_0x5abd09(0x20a)](this[_0x5abd09(0x227)]));while(this[_0x5abd09(0x227)]['children']['length']>0x0){const _0x2b9552=this['_messageKeywordContainer'][_0x5abd09(0x1bb)][0x0];this[_0x5abd09(0x227)]['removeChild'](_0x2b9552);}if(this[_0x5abd09(0x1cc)]()){if(_0x5abd09(0x1d5)!==_0x5abd09(0x19f)){const _0x53847a=SceneManager[_0x5abd09(0x206)][_0x5abd09(0x1fa)];_0x53847a&&_0x53847a[_0x5abd09(0x22e)](null);}else _0x44ee73[_0x5abd09(0x1e0)][_0x5abd09(0x22b)][_0x5abd09(0x224)](this),this[_0x5abd09(0x21d)]();}},Window_Base['prototype'][_0xfec0f8(0x1cc)]=function(){const _0x45ba61=_0xfec0f8,_0x2cad86=[];return _0x2cad86[_0x45ba61(0x1d9)](_0x45ba61(0x1bd),_0x45ba61(0x238)),!_0x2cad86[_0x45ba61(0x1ee)](this['constructor']['name']);},VisuMZ[_0xfec0f8(0x1e0)]['Window_Base_convertEscapeCharacters']=Window_Base[_0xfec0f8(0x1a6)]['convertEscapeCharacters'],Window_Base[_0xfec0f8(0x1a6)][_0xfec0f8(0x21f)]=function(_0x438230){const _0x270e1b=_0xfec0f8;return _0x438230=this[_0x270e1b(0x203)](_0x438230),_0x438230=VisuMZ['MessageKeywords'][_0x270e1b(0x1e2)]['call'](this,_0x438230),_0x438230;},Window_Base[_0xfec0f8(0x1a6)][_0xfec0f8(0x203)]=function(_0x6e89f2){const _0x75358d=_0xfec0f8;return _0x6e89f2=this[_0x75358d(0x1d1)](_0x6e89f2),_0x6e89f2=_0x6e89f2[_0x75358d(0x21e)](/\(\((.*?)\)\)/gi,(_0x22e03b,_0x3a67f0)=>{const _0x14a1e8=_0x75358d,_0x32b68e=String(_0x3a67f0)['toUpperCase']()['trim']();if(VisuMZ['MessageKeywords'][_0x14a1e8(0x21b)][_0x32b68e]){if(_0x14a1e8(0x23d)===_0x14a1e8(0x23d)){const _0x2aea7c=VisuMZ['MessageKeywords'][_0x14a1e8(0x21b)][_0x32b68e],_0x148de9=_0x2aea7c[_0x14a1e8(0x1fb)];if(this[_0x14a1e8(0x1a2)]()){if(_0x14a1e8(0x23e)!==_0x14a1e8(0x23e))_0x163ffe['setKeyword'](null);else return'\x1bMSGKEYWORD<%1>%2\x1bMSGKEYWORDEND[0]'[_0x14a1e8(0x226)](_0x32b68e,_0x148de9);}else return _0x148de9;}else _0x1a6edd(_0x14a1e8(0x1c7)[_0x14a1e8(0x226)](_0x52b646,_0x164325,_0x17a8d5)),_0xee7d74['exit']();}else{if(_0x14a1e8(0x19d)===_0x14a1e8(0x1eb)){this[_0x14a1e8(0x20d)]=_0xebdbfc,_0x329184[_0x14a1e8(0x1a6)]['initialize'][_0x14a1e8(0x224)](this),this['setFrame'](0x0,0x0,_0x2bc2f0[_0x14a1e8(0x1d4)],_0x7abe9e[_0x14a1e8(0x233)]),this['x']=_0x43817['x'],this['y']=_0x2edf76['y'];let _0x51d06f=![];_0x51d06f&&(this[_0x14a1e8(0x23a)]=new _0x3d3fdb(_0xc897d4['width'],_0x332fee[_0x14a1e8(0x233)]),this[_0x14a1e8(0x23a)][_0x14a1e8(0x1e7)](0x0,0x0,_0x40afeb[_0x14a1e8(0x1d4)],_0x386969[_0x14a1e8(0x233)],_0x14a1e8(0x1fd)),this[_0x14a1e8(0x1f1)]=0x40);}else return'';}}),_0x6e89f2;},VisuMZ[_0xfec0f8(0x1e0)][_0xfec0f8(0x235)]=Window_Base[_0xfec0f8(0x1a6)][_0xfec0f8(0x1c2)],Window_Base[_0xfec0f8(0x1a6)][_0xfec0f8(0x1c2)]=function(_0x359dc7,_0x519db6){const _0x44c236=_0xfec0f8;switch(_0x359dc7){case'MSGKEYWORD':if(_0x519db6['drawing']){if(_0x44c236(0x1e8)===_0x44c236(0x1e8))this[_0x44c236(0x232)](_0x519db6);else{this[_0x44c236(0x1fc)]='';if(!this[_0x44c236(0x23b)])return;this['setupKeywordText'](),this[_0x44c236(0x1fc)]=this[_0x44c236(0x1fc)][_0x44c236(0x19c)]();}}else this['obtainEscapeString'](_0x519db6);break;case _0x44c236(0x240):_0x519db6[_0x44c236(0x1c9)]&&this[_0x44c236(0x22d)]&&this[_0x44c236(0x221)](_0x519db6);this['obtainEscapeParam'](_0x519db6);break;default:return VisuMZ['MessageKeywords'][_0x44c236(0x235)][_0x44c236(0x224)](this,_0x359dc7,_0x519db6);break;}},Window_Base[_0xfec0f8(0x1a6)][_0xfec0f8(0x232)]=function(_0x5a8c57){const _0xb1c45=_0xfec0f8,_0x59b7f2=this['obtainEscapeString'](_0x5a8c57);this[_0xb1c45(0x1ba)]=_0x59b7f2[_0xb1c45(0x20c)]()[_0xb1c45(0x19c)](),this[_0xb1c45(0x22d)]=!![],this[_0xb1c45(0x1d2)]=_0x5a8c57['x'],this[_0xb1c45(0x1f2)]=_0x5a8c57['y'];},Window_Base[_0xfec0f8(0x1a6)][_0xfec0f8(0x221)]=function(_0x25fd9c){const _0x3fb0d9=_0xfec0f8;this[_0x3fb0d9(0x22d)]=![],this['_createKeywordEndX']=_0x25fd9c['x'],this['_createKeywordEndY']=_0x25fd9c['y'],this[_0x3fb0d9(0x1c4)]();},VisuMZ[_0xfec0f8(0x1e0)][_0xfec0f8(0x1c8)]=Window_Base[_0xfec0f8(0x1a6)]['processNewLine'],Window_Base[_0xfec0f8(0x1a6)][_0xfec0f8(0x212)]=function(_0x1a31d9){const _0x2fd244=_0xfec0f8;_0x1a31d9[_0x2fd244(0x1c9)]&&this[_0x2fd244(0x22d)]&&('eIBMd'===_0x2fd244(0x1ab)?_0x2d596f[_0x2fd244(0x22e)](null):(this[_0x2fd244(0x1c6)]=_0x1a31d9['x'],this['_createKeywordEndY']=_0x1a31d9['y'],this[_0x2fd244(0x1c4)]())),VisuMZ[_0x2fd244(0x1e0)]['Window_Base_processNewLine']['call'](this,_0x1a31d9),_0x1a31d9[_0x2fd244(0x1c9)]&&this[_0x2fd244(0x22d)]&&('TqbSf'===_0x2fd244(0x21c)?(this[_0x2fd244(0x1d2)]=_0x1a31d9['x'],this['_createKeywordStartY']=_0x1a31d9['y']):(this[_0x2fd244(0x1aa)](),_0x34e1b6[_0x2fd244(0x1e0)][_0x2fd244(0x1f0)][_0x2fd244(0x224)](this,_0x313bba)));},Window_Base[_0xfec0f8(0x1a6)][_0xfec0f8(0x1a2)]=function(){const _0x1648e5=_0xfec0f8;return Window_MessageKeywordTooltip[_0x1648e5(0x237)][_0x1648e5(0x1ee)](this['constructor']['name']);},Window_Base[_0xfec0f8(0x1a6)][_0xfec0f8(0x1c4)]=function(){const _0xb1f3c5=_0xfec0f8;if(!this[_0xb1f3c5(0x1a2)]())return;const _0x93d28b=this['_createKeywordString'];let _0x339e20=this[_0xb1f3c5(0x1d2)],_0x223029=this[_0xb1f3c5(0x1f2)]+0x2,_0x3b8221=this[_0xb1f3c5(0x1c6)]-_0x339e20,_0x57bdb7=this[_0xb1f3c5(0x200)]-_0x223029+(this[_0xb1f3c5(0x1b0)][_0xb1f3c5(0x1c1)]+0xa)-0x4;const _0x100f23=new Rectangle(_0x339e20,_0x223029,_0x3b8221,_0x57bdb7),_0x1acff3=new Sprite_MessageKeywordTooltip(_0x93d28b,_0x100f23);_0x1acff3[_0xb1f3c5(0x1e5)](this),this['_messageKeywordContainer'][_0xb1f3c5(0x20a)](_0x1acff3);},VisuMZ[_0xfec0f8(0x1e0)]['Window_Message_newPage']=Window_Message[_0xfec0f8(0x1a6)]['newPage'],Window_Message[_0xfec0f8(0x1a6)][_0xfec0f8(0x1ea)]=function(_0x457b25){const _0x17c783=_0xfec0f8;this[_0x17c783(0x1aa)](),VisuMZ[_0x17c783(0x1e0)][_0x17c783(0x1f0)][_0x17c783(0x224)](this,_0x457b25);},VisuMZ[_0xfec0f8(0x1e0)][_0xfec0f8(0x1bf)]=Window_Message['prototype'][_0xfec0f8(0x215)],Window_Message[_0xfec0f8(0x1a6)][_0xfec0f8(0x215)]=function(){const _0x115d09=_0xfec0f8;this[_0x115d09(0x1aa)](),VisuMZ[_0x115d09(0x1e0)]['Window_Message_terminateMessage']['call'](this);};function _0x1300(_0x109e07,_0x5039cb){const _0x43e958=_0x43e9();return _0x1300=function(_0x130082,_0x47ee38){_0x130082=_0x130082-0x19a;let _0x1ed837=_0x43e958[_0x130082];return _0x1ed837;},_0x1300(_0x109e07,_0x5039cb);}function Window_MessageKeywordTooltip(){const _0x2488ad=_0xfec0f8;this[_0x2488ad(0x209)](...arguments);}Window_MessageKeywordTooltip[_0xfec0f8(0x1a6)]=Object[_0xfec0f8(0x222)](Window_Base[_0xfec0f8(0x1a6)]),Window_MessageKeywordTooltip['prototype'][_0xfec0f8(0x1a7)]=Window_MessageKeywordTooltip,Window_MessageKeywordTooltip[_0xfec0f8(0x1f4)]=VisuMZ[_0xfec0f8(0x1e0)][_0xfec0f8(0x1dc)][_0xfec0f8(0x19a)][_0xfec0f8(0x1ed)],Window_MessageKeywordTooltip['WINDOW_SKIN_FILENAME']=VisuMZ[_0xfec0f8(0x1e0)]['Settings'][_0xfec0f8(0x19a)]['WindowSkin'],Window_MessageKeywordTooltip[_0xfec0f8(0x21a)]=VisuMZ[_0xfec0f8(0x1e0)][_0xfec0f8(0x1dc)][_0xfec0f8(0x19a)]['WindowOpacity'],Window_MessageKeywordTooltip['MOUSE_OFFSET_X']=VisuMZ[_0xfec0f8(0x1e0)]['Settings'][_0xfec0f8(0x19a)][_0xfec0f8(0x1f8)],Window_MessageKeywordTooltip[_0xfec0f8(0x1a5)]=VisuMZ[_0xfec0f8(0x1e0)][_0xfec0f8(0x1dc)][_0xfec0f8(0x19a)][_0xfec0f8(0x236)],Window_MessageKeywordTooltip[_0xfec0f8(0x237)]=VisuMZ[_0xfec0f8(0x1e0)][_0xfec0f8(0x1dc)]['SupportedWindows'],Window_MessageKeywordTooltip[_0xfec0f8(0x1a6)][_0xfec0f8(0x209)]=function(){const _0x1d6711=_0xfec0f8,_0x336867=new Rectangle(0x0,0x0,Graphics[_0x1d6711(0x1d4)],Graphics[_0x1d6711(0x233)]);Window_Base[_0x1d6711(0x1a6)]['initialize'][_0x1d6711(0x224)](this,_0x336867),this[_0x1d6711(0x219)]['x']=this[_0x1d6711(0x219)]['y']=Window_MessageKeywordTooltip[_0x1d6711(0x1f4)],this[_0x1d6711(0x239)](),this[_0x1d6711(0x23b)]='';},Window_MessageKeywordTooltip[_0xfec0f8(0x1a6)][_0xfec0f8(0x205)]=function(){this['windowskin']=ImageManager['loadSystem'](Window_MessageKeywordTooltip['WINDOW_SKIN_FILENAME']);},Window_MessageKeywordTooltip[_0xfec0f8(0x1a6)][_0xfec0f8(0x1c3)]=function(){const _0x28a8d7=_0xfec0f8;this[_0x28a8d7(0x22f)]=Window_MessageKeywordTooltip[_0x28a8d7(0x21a)];},Window_MessageKeywordTooltip[_0xfec0f8(0x1a6)][_0xfec0f8(0x22e)]=function(_0x131d43){const _0x8a58e4=_0xfec0f8;if(this[_0x8a58e4(0x23b)]===_0x131d43)return;if(_0x131d43!==null&&!VisuMZ[_0x8a58e4(0x1e0)][_0x8a58e4(0x21b)][_0x131d43])return;this[_0x8a58e4(0x23b)]=_0x131d43||'';if(this['_keyword'][_0x8a58e4(0x19c)]()[_0x8a58e4(0x1b8)]>0x0){if(_0x8a58e4(0x1ac)==='FMpWT')this[_0x8a58e4(0x1df)]();else{_0x5a6b12[_0x8a58e4(0x1a6)][_0x8a58e4(0x1d6)]['call'](this);const _0x582dae=this[_0x8a58e4(0x234)]();_0x582dae&&this[_0x8a58e4(0x1f7)]()&&_0x582dae['setKeyword'](this[_0x8a58e4(0x20d)]);}}else{if(this[_0x8a58e4(0x1b0)])this[_0x8a58e4(0x1b0)][_0x8a58e4(0x19b)]();this[_0x8a58e4(0x239)]();}},Window_MessageKeywordTooltip[_0xfec0f8(0x1a6)][_0xfec0f8(0x1df)]=function(){const _0x5b416f=_0xfec0f8;this[_0x5b416f(0x1b0)]['clear'](),this['setupText']();if(this['_text'][_0x5b416f(0x1b8)]>0x0){this['resizeWindow']();const _0x59fb7d=this[_0x5b416f(0x1c5)]();this[_0x5b416f(0x1da)](this[_0x5b416f(0x1fc)],_0x59fb7d['x'],_0x59fb7d['y'],_0x59fb7d[_0x5b416f(0x1d4)]),this['show']();}else this[_0x5b416f(0x1b0)]['clear'](),this[_0x5b416f(0x239)]();},Window_MessageKeywordTooltip[_0xfec0f8(0x1a6)][_0xfec0f8(0x1bc)]=function(){const _0x2d069d=_0xfec0f8;return this[_0x2d069d(0x1e6)];},Window_MessageKeywordTooltip[_0xfec0f8(0x1a6)][_0xfec0f8(0x203)]=function(_0x168774){return _0x168774;},Window_MessageKeywordTooltip[_0xfec0f8(0x1a6)][_0xfec0f8(0x1a2)]=function(){return![];},Window_MessageKeywordTooltip[_0xfec0f8(0x1a6)][_0xfec0f8(0x23f)]=function(){const _0x235f58=_0xfec0f8;this['_text']='';if(!this[_0x235f58(0x23b)])return;this['setupKeywordText'](),this[_0x235f58(0x1fc)]=this['_text'][_0x235f58(0x19c)]();},Window_MessageKeywordTooltip['prototype']['setupKeywordText']=function(){const _0x23251c=_0xfec0f8,_0x560338=VisuMZ[_0x23251c(0x1e0)][_0x23251c(0x21b)][this[_0x23251c(0x23b)]];this['_text']=_0x560338[_0x23251c(0x19a)];},Window_MessageKeywordTooltip['prototype'][_0xfec0f8(0x1f6)]=function(){const _0x47a530=_0xfec0f8,_0x2e4016=this[_0x47a530(0x225)](this[_0x47a530(0x1fc)]);this[_0x47a530(0x1d4)]=_0x2e4016[_0x47a530(0x1d4)]+(this['itemPadding']()+this[_0x47a530(0x216)])*0x2,this[_0x47a530(0x233)]=_0x2e4016['height']+this[_0x47a530(0x216)]*0x2,this['createContents'](),this[_0x47a530(0x1ff)]();},Window_MessageKeywordTooltip[_0xfec0f8(0x1a6)][_0xfec0f8(0x217)]=function(){const _0x10430b=_0xfec0f8;Window_Base[_0x10430b(0x1a6)][_0x10430b(0x217)][_0x10430b(0x224)](this);if(this['_requestRefresh']){if(_0x10430b(0x1d8)!==_0x10430b(0x1d8)){let _0x2edb6a=0xff;if(_0xbc9f53['x']<=0x0)_0x2edb6a=0x0;if(_0xd62c65['x']>=_0x24858a[_0x10430b(0x1d4)])_0x2edb6a=0x0;if(_0x35a86a['y']<=0x0)_0x2edb6a=0x0;if(_0x4c6d92['y']>=_0xe44661[_0x10430b(0x233)])_0x2edb6a=0x0;this['opacity']=_0x2edb6a;}else this['_requestRefresh']=![],this[_0x10430b(0x1df)]();}this[_0x10430b(0x214)](),this['updateOpacity']();},Window_MessageKeywordTooltip[_0xfec0f8(0x1a6)][_0xfec0f8(0x1cb)]=function(){const _0xa6b4f4=_0xfec0f8;this[_0xa6b4f4(0x208)]=!![];},Window_MessageKeywordTooltip[_0xfec0f8(0x1a6)]['updatePosition']=function(){const _0x1dac11=_0xfec0f8;if(!this[_0x1dac11(0x23c)])return;this['x']=TouchInput['x']+Window_MessageKeywordTooltip['MOUSE_OFFSET_X'],this['y']=TouchInput['y']+Window_MessageKeywordTooltip[_0x1dac11(0x1a5)],this[_0x1dac11(0x1e3)]();},Window_MessageKeywordTooltip[_0xfec0f8(0x1a6)][_0xfec0f8(0x1e3)]=function(){const _0x5bfc85=_0xfec0f8,_0x3379a9=this[_0x5bfc85(0x1d4)]*(Window_MessageKeywordTooltip[_0x5bfc85(0x1f4)]||0.01),_0x34adff=this['height']*(Window_MessageKeywordTooltip[_0x5bfc85(0x1f4)]||0.01);this['x']=Math[_0x5bfc85(0x1de)](this['x'][_0x5bfc85(0x1f9)](0x0,Graphics['width']-_0x3379a9)),this['y']=Math['round'](this['y'][_0x5bfc85(0x1f9)](0x0,Graphics[_0x5bfc85(0x233)]-_0x34adff));},Window_MessageKeywordTooltip[_0xfec0f8(0x1a6)][_0xfec0f8(0x202)]=function(){const _0x2e9d07=_0xfec0f8;let _0x390bb9=0xff;if(TouchInput['x']<=0x0)_0x390bb9=0x0;if(TouchInput['x']>=Graphics['width'])_0x390bb9=0x0;if(TouchInput['y']<=0x0)_0x390bb9=0x0;if(TouchInput['y']>=Graphics[_0x2e9d07(0x233)])_0x390bb9=0x0;this['opacity']=_0x390bb9;};function _0x43e9(){const _0x1a6d3a=['RegisterKeywords','contents','3fpEDtv','FgFsT','createWindowLayer','544396tpPnyr','show','STRUCT','CreateRefreshPatches','length','filter','_createKeywordString','children','isWordWrapEnabled','Window_QuestLog','worldTransform','Window_Message_terminateMessage','parse','fontSize','processEscapeCharacter','updateBackOpacity','addMessageKeyword','baseTextRect','_createKeywordEndX','%1\x20is\x20incorrectly\x20placed\x20on\x20the\x20plugin\x20list.\x0aIt\x20is\x20a\x20Tier\x20%2\x20plugin\x20placed\x20over\x20other\x20Tier\x20%3\x20plugins.\x0aPlease\x20reorder\x20the\x20plugin\x20list\x20from\x20smallest\x20to\x20largest\x20tier\x20numbers.','Window_Base_processNewLine','drawing','_hoverState','requestRefresh','allowKeyWordRefresh','description','hitTest','ARRAYNUM','parameters','convertVariableEscapeCharacters','_createKeywordStartX','9740MpRstZ','width','ExefK','onMouseEnter','xdYtC','SReoC','push','drawTextEx','PdoXs','Settings','157764KfHTin','round','refresh','MessageKeywords','400106eqFaja','Window_Base_convertEscapeCharacters','clampPosition','_parentWindow','setParentWindow','_wordWrap','fillRect','htaVb','SfRIa','newPage','orpnS','ARRAYJSON','Scale','includes','891780tUJxwv','Window_Message_newPage','opacity','_createKeywordStartY','applyInverse','WINDOW_SCALE','processTouch','resizeWindow','isParentWindowValid','OffsetX','clamp','_messageKeywordTooltipWindow','Text','_text','magenta','ARRAYSTRUCT','resetFontSettings','_createKeywordEndY','EVAL','updateOpacity','convertMessageKeywords','ConvertParams','loadWindowskin','_scene','664664LVasPn','_requestRefresh','initialize','addChild','match','toUpperCase','_referenceString','setFrame','VhSWB','status','_clientArea','processNewLine','Window_Base_initialize','updatePosition','terminateMessage','padding','update','sHhGw','scale','WINDOW_SKIN_OPACITY','Keywords','TqbSf','createMessageKeywordTooltipWindow','replace','convertEscapeCharacters','isBeingTouched','endKeywordMapping','create','exit','call','textSizeEx','format','_messageKeywordContainer','isOpen','682136vOWMKA','onDatabaseLoaded','Scene_Base_createWindowLayer','map','_createKeywordMode','setKeyword','backOpacity','%1\x27s\x20version\x20does\x20not\x20match\x20plugin\x27s.\x20Please\x20update\x20it\x20in\x20the\x20Plugin\x20Manager.','ARRAYSTR','startKeywordMapping','height','targetWindow','Window_Base_processEscapeCharacter','OffsetY','SUPPORTED_WINDOWS','Window_QuestTracker','hide','bitmap','_keyword','visible','YEzIR','qLaBP','setupText','MSGKEYWORDEND','Tooltip','clear','trim','NRNsg','ARRAYEVAL','ErLNb','STR','process_VisuMZ_MessageKeywords','isSupportMessageKeywords','Scene_Boot_onDatabaseLoaded','%1_refresh','MOUSE_OFFSET_Y','prototype','constructor','funcPatchCodeFmt','onMouseExit','clearMessageKeywordSprites','MGVLm','FMpWT','lPeHl','Keyword'];_0x43e9=function(){return _0x1a6d3a;};return _0x43e9();}