//=============================================================================
// VisuStella MZ - Extended Message Functionality
// VisuMZ_2_ExtMessageFunc.js
//=============================================================================

var Imported = Imported || {};
Imported.VisuMZ_2_ExtMessageFunc = true;

var VisuMZ = VisuMZ || {};
VisuMZ.ExtMessageFunc = VisuMZ.ExtMessageFunc || {};
VisuMZ.ExtMessageFunc.version = 1.06;

//=============================================================================
 /*:
 * @target MZ
 * @plugindesc [RPG Maker MZ] [Tier 2] [Version 1.06] [ExtMessageFunc]
 * @author VisuStella
 * @url http://www.yanfly.moe/wiki/Extended_Message_Functionality_VisuStella_MZ
 * @base VisuMZ_1_MessageCore
 * @orderAfter VisuMZ_1_MessageCore
 *
 * @help
 * ============================================================================
 * Introduction
 * ============================================================================
 *
 * The Extended Message Function plugin adds onto RPG Maker MZ's Message Window
 * and adds in various features you would normally see found in modern RPG's.
 * Things like automatically moving the text forward after a set amount of time
 * or fast forward are available. Saving and loading during a message is also
 * possible as well as going to the Options menu or returning back to the title
 * screen. These options are only available to the Message Window on the map
 * scene and do not work in battle.
 *
 * Features include all (but not limited to) the following:
 * 
 * * The Button Console appears on the Message Window let the player activate
 *   various commands via touch/click.
 * * Extended Fast Forward Mode is an expanded feature upon the Message Core's
 *   Fast Forward function to fast forward all events and not just messages.
 *   This can be optionally disabled.
 * * A Message Cursor will appear where the text has ended for those who want
 *   that kind of aesthetic in their game.
 * * Auto-Forward will automatically move messages onward after a certain
 *   amount of time has passed. Time required will be determined based on the
 *   length of the message in question.
 * * Saving and Loading can be done from the Message Window akin to how many
 *   visual novels work. Requires the Save Core, but you're already using that,
 *   right? Right?
 * * Also be able to jump straight into the Options scene from the Message
 *   Window to change any settings on the fly. Requires the Options Core, but
 *   you're using that, too, correct?
 * * And for those who want to jump back to the title screen, they can do so
 *   by selecting a Game End option, too.
 *
 * ============================================================================
 * Requirements
 * ============================================================================
 *
 * This plugin is made for RPG Maker MZ. This will not work in other iterations
 * of RPG Maker.
 *
 * ------ Required Plugin List ------
 *
 * * VisuMZ_1_MessageCore
 *
 * This plugin requires the above listed plugins to be installed inside your
 * game's Plugin Manager list in order to work. You cannot start your game with
 * this plugin enabled without the listed plugins.
 *
 * ------ Tier 2 ------
 *
 * This plugin is a Tier 2 plugin. Place it under other plugins of lower tier
 * value on your Plugin Manager list (ie: 0, 1, 2, 3, 4, 5). This is to ensure
 * that your plugins will have the best compatibility with the rest of the
 * VisuStella MZ library.
 *
 * ============================================================================
 * Extra Features
 * ============================================================================
 *
 * There are some extra features found if other VisuStella MZ plugins are found
 * present in the Plugin Manager list.
 *
 * ---
 *
 * VisuMZ_1_OptionsCore
 *
 * The Options Core is a required plugin in order to make use of the "Options"
 * (aka "Config") button found in the Button Console.
 *
 * ---
 *
 * VisuMZ_1_SaveCore
 *
 * The Options Core is a required plugin in order to make use of the "Save" and
 * "Load" buttons found in the Button Console.
 *
 * ---
 * 
 * VisuMZ_3_MessageLog
 * 
 * The Message Log plugin enables the "Log" button found in the Button Console
 * to let the player go and review the text that has been displayed in the map
 * scene. This does not include the text found in battle to avoid conflicting
 * logged messages across different situations.
 * 
 * ---
 * 
 * VisuMZ_4_MessageVisibility
 * 
 * The Message Visibility plugin enables the "Hide" button found in the
 * Button Console to make the Message Window visible or invisible.
 * 
 * ---
 *
 * ============================================================================
 * Available Text Codes
 * ============================================================================
 *
 * The following are text codes that you may use with this plugin. 
 *
 * === Button Console-Related Text Codes ===
 * 
 * ---
 *
 * --------------------   -----------------------------------------------------
 * Text Code              Effect (Message Window Only)
 * --------------------   -----------------------------------------------------
 * 
 * <Hide Buttons>         Hides the Button Console from this current Message
 *                        Window's text assuming that nothing else is hiding
 *                        the Button Console from view.
 * 
 * ---
 *
 * ============================================================================
 * Plugin Commands
 * ============================================================================
 *
 * The following are Plugin Commands that come with this plugin. They can be
 * accessed through the Plugin Command event command.
 *
 * ---
 * 
 * === Fast Forward Plugin Commands ===
 * 
 * ---
 *
 * Fast Forward: Allow/Disallow
 * - Change whether or not Fast Forward is allowed/disallowed.
 * - Must be enabled by the Plugin Parameters.
 *
 *   Allow?:
 *   - Allow or disallow the Extended Fast Forward feature?
 *   - Must be enabled by the Plugin Parameters.
 *
 * ---
 * 
 * === Message Button Console Plugin Commands ===
 * 
 * ---
 *
 * Message Button Console: Show/Hide
 * - Determine if the Message Button Console is visible or hidden.
 * - Only appears on the map. 
 * - Does not appear in battle.
 *
 *   Visible?:
 *   - Show or hide the Message Button Console feature?
 *   - Only appears on the map.
 *   - Does not appear in battle.
 *
 * ---
 * 
 * === Message Cursor Plugin Commands ===
 * 
 * ---
 *
 * Message Cursor: Change Settings
 * - Change the Message Cursor settings used.
 *
 *   Change Settings:
 *   - Change the Message Cursor settings.
 *   - Settings are the same as the ones found in the Plugin Parameters.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Auto-Forward Settings
 * ============================================================================
 *
 * Auto-Forward settings used for this game. Auto-Forward is a feature that
 * once enabled, the game will automatically move the "Show Text" event
 * commands forward after a certain amount of time. The amount of time will be
 * determined by how many characters are displayed on the screen. There is a
 * lower boundary, where if the wait time does not meet the amount, the timer
 * will be set to the minimum wait value instead.
 *
 * ---
 *
 * Settings
 * 
 *   Wait per Character:
 *   - How many frames should the game wait per character?
 *   - Average: 60 frames per second.
 * 
 *   Minimum Wait:
 *   - What is the minimum amount of frames to wait?
 *   - Average: 60 frames per second.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Fast Forward (Extended) Settings
 * ============================================================================
 *
 * Extended Fast Forward settings used for this game. If enabled, this will
 * replace the Message Core's Fast Forward functionality. The Extended Fast
 * Forward feature will not only fast forward through messages but any running
 * events that are not found in a parallel event.
 * 
 * It can also be activated the Message Core's Fast Forward shortcut key.
 *
 * ---
 *
 * Settings
 * 
 *   Enable?:
 *   - Enable or disable the Extended Fast Forward feature?
 * 
 *   Speed:
 *   - What is the speed at which Extended Fast Forward works at?
 *   - Higher numbers are faster.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Message Button Console Settings
 * ============================================================================
 *
 * Message Button Console settings used for this game.
 * 
 * It will only appear in the Message Window on the map scene. It will NOT
 * appear in battle. The reason it won't appear in battle is because many of
 * the functions there will clash with how the battle scene behaves.
 * 
 * The Button Console will add extra padding to the Message Window and appear
 * at either the top of bottom of the Message Window (your choice). A row of
 * buttons will appear each with a different functionality.
 * 
 * These Plugin Parameters also allow you to customize the appearance of how
 * the buttons look in-game. Adjust them accordingly.
 *
 * ---
 *
 * General
 * 
 *   Show by Default?:
 *   - Show or hide the Message Button Console by default?
 * 
 *   Position:
 *   - Where do you wish to display the Message Button Console?
 *     - Top of Message Window
 *     - Bottom of Message Window
 *
 * ---
 *
 * Appearance
 * 
 *   Window Skin:
 *   - What is the window skin used for the buttons?
 *   - Ignore if using Background Images.
 * 
 *   Font Name:
 *   - What font do you wish to use for the Message Button Console?
 * 
 *     Font Size:
 *     - What font size do you wish to use for the Message Button Console?
 * 
 *   Text Colors:
 * 
 *     Normal Color:
 *     - Use #rrggbb for custom colors or regular numbers for text colors from
 *       the Window Skin.
 * 
 *     Toggled Color:
 *     - Use #rrggbb for custom colors or regular numbers for text colors from
 *       the Window Skin.
 * 
 *     Disabled Color:
 *     - Use #rrggbb for custom colors or regular numbers for text colors from
 *       the Window Skin.
 * 
 *   Visuals:
 * 
 *     Width:
 *     - What is the width of each button?
 * 
 *     Height:
 *     - What is the height of each button?
 * 
 *     Buffer:
 *     - What is the buffer between each button?
 * 
 *   Background Images:
 * 
 *     Disabled Image:
 *     Enabled Image:
 *     Toggled Image:
 *     - Filename of the background image when the button is disabled,
 *       enabled, or toggled.
 *     - This will hide the window skin for this button.
 * 
 *     Offset X:
 *     - Offsets the X position of this image.
 *     - Negative: left; Positive: right
 * 
 *     Offset Y:
 *     - Offsets the Y position of this image.
 *     - Negative: up; Positive: down
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Button Settings
 * ============================================================================
 *
 * Settings for which buttons appear and how they appear. These settings will
 * determine which buttons appear (provided that their required plugins are
 * available), what shortcut keys are applied to them, and what kind of text
 * will be displayed to represent them.
 * 
 * In case you are wondering where the Fast Forward shortcut key is, that
 * setting is found in the Message Core.
 *
 * ---
 *
 * General
 * 
 *   List:
 *   - Which buttons appear and in what order?
 *   - Some commands require certain plugins installed.
 *
 * ---
 *
 * Shortcut Keys
 * 
 *   Auto-Forward Key:
 *   - This is the key used for auto-forwarding messages.
 * 
 *   Save Key:
 *   - This is the key used for quick saving.
 *   - Requires VisuMZ_1_SaveCore!
 * 
 *   Load Key:
 *   - This is the key used for quick load.
 *   - Requires VisuMZ_1_SaveCore!
 * 
 *   Options Key:
 *   - This is the key used for opening options.
 *   - Requires VisuMZ_1_OptionsCore!
 * 
 *   Game End Key:
 *   - This is the key used for ending the game.
 *
 * ---
 *
 * Vocabulary
 * 
 *   Auto-Forward:
 *   - How is this option's text displayed in-game?
 * 
 *   Fast Forward:
 *   - How is this option's text displayed in-game?
 * 
 *   Save Game:
 *   - How is this option's text displayed in-game?
 *   - Requires VisuMZ_1_SaveCore!
 * 
 *   Load Game:
 *   - How is this option's text displayed in-game?
 *   - Requires VisuMZ_1_SaveCore!
 * 
 *   Options:
 *   - How is this option's text displayed in-game?
 *   - Requires VisuMZ_1_OptionsCore!
 * 
 *   Game End:
 *   - How is this option's text displayed in-game?
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Message Cursor Settings
 * ============================================================================
 *
 * Message Cursor settings used for this game. The cursor, if enabled, will
 * appear where the text is currently displayed at and adds a new type of
 * aesthetic to the game.
 *
 * ---
 *
 * General
 * 
 *   Enable?:
 *   - Enable or disable the message cursor?
 * 
 *   Graphic Type:
 *   - What is the cursor's graphic type?
 *     - Icon - From img/system/IconSet.png
 *     - Image - An animated image from img/system/
 *
 * ---
 *
 * Icon
 * 
 *   Icon Index:
 *   - This is icon used for the Message Cursor.
 * 
 *   Flip Speed Multiplier:
 *   - What is the flip speed multiplier for the Message Cursor?
 *   - Use 0 for no flipping.
 *
 * ---
 *
 * Image
 * 
 *   Filename:
 *   - Filename of the image found inside the img/system/ folder.
 * 
 *   Image Rows:
 *   - How many rows are there for the image?
 * 
 *   Image Columns:
 *   - How many columns are there for the image?
 * 
 *   Frame Delay:
 *   - How many frames delayed are there per animated cell?
 *
 * ---
 *
 * Appearance
 * 
 *   Anchor X:
 *   Anchor Y:
 *   - Determine the Message Cursor's X/Y position.
 *   - Use a number between 0 and 1 for best results.
 * 
 *   Offset X:
 *   Offset Y:
 *   - Offset the Message Cursor's X/Y position by how many pixels?
 *
 * ---
 *
 * ============================================================================
 * Terms of Use
 * ============================================================================
 *
 * 1. These plugins may be used in free or commercial games provided that they
 * have been acquired through legitimate means at VisuStella.com and/or any
 * other official approved VisuStella sources. Exceptions and special
 * circumstances that may prohibit usage will be listed on VisuStella.com.
 * 
 * 2. All of the listed coders found in the Credits section of this plugin must
 * be given credit in your games or credited as a collective under the name:
 * "VisuStella".
 * 
 * 3. You may edit the source code to suit your needs, so long as you do not
 * claim the source code belongs to you. VisuStella also does not take
 * responsibility for the plugin if any changes have been made to the plugin's
 * code, nor does VisuStella take responsibility for user-provided custom code
 * used for custom control effects including advanced JavaScript notetags
 * and/or plugin parameters that allow custom JavaScript code.
 * 
 * 4. You may NOT redistribute these plugins nor take code from this plugin to
 * use as your own. These plugins and their code are only to be downloaded from
 * VisuStella.com and other official/approved VisuStella sources. A list of
 * official/approved sources can also be found on VisuStella.com.
 *
 * 5. VisuStella is not responsible for problems found in your game due to
 * unintended usage, incompatibility problems with plugins outside of the
 * VisuStella MZ library, plugin versions that aren't up to date, nor
 * responsible for the proper working of compatibility patches made by any
 * third parties. VisuStella is not responsible for errors caused by any
 * user-provided custom code used for custom control effects including advanced
 * JavaScript notetags and/or plugin parameters that allow JavaScript code.
 *
 * 6. If a compatibility patch needs to be made through a third party that is
 * unaffiliated with VisuStella that involves using code from the VisuStella MZ
 * library, contact must be made with a member from VisuStella and have it
 * approved. The patch would be placed on VisuStella.com as a free download
 * to the public. Such patches cannot be sold for monetary gain, including
 * commissions, crowdfunding, and/or donations.
 * 
 * 7. If this VisuStella MZ plugin is a paid product, all project team members
 * must purchase their own individual copies of the paid product if they are to
 * use it. Usage includes working on related game mechanics, managing related
 * code, and/or using related Plugin Commands and features. Redistribution of
 * the plugin and/or its code to other members of the team is NOT allowed
 * unless they own the plugin itself as that conflicts with Article 4.
 * 
 * 8. Any extensions and/or addendums made to this plugin's Terms of Use can be
 * found on VisuStella.com and must be followed.
 *
 * ============================================================================
 * Credits
 * ============================================================================
 * 
 * If you are using this plugin, credit the following people in your game:
 * 
 * Team VisuStella
 * * Irina
 * * Arisu
 * * Olivia
 * * Yanfly
 *
 * ============================================================================
 * Changelog
 * ============================================================================
 * 
 * Version 1.06: November 18, 2021
 * * Compatibility Update
 * ** Added compatibility functionality for future plugins.
 * 
 * Version 1.05: November 4, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Parameters added by Irina and sponsored by Archeia:
 * *** Plugin Parameters > Message Button Console > Background Images
 * **** Adds a background image to this button instead of using a window skin.
 * **** This will disable the window skin.
 * **** Various images can be used for "Disabled", "Enabled", and "Toggled".
 * **** Offset X and Y positions.
 * 
 * Version 1.04: October 14, 2021
 * * Feature Update!
 * ** Added an alert requirement for those who are using very old versions of
 *    the Message Core that cannot sustain the requirements of this plugin.
 *    Added by Irina.
 * 
 * Version 1.03: September 3, 2021
 * * Bug Fixes!
 * ** Pause sprite, for the Message Window, will no longer show multiple copies
 *    if the message cursor sprite is disabled. Fix made by Irina.
 * 
 * Version 1.02: August 6, 2021
 * * Documentation Update!
 * ** Plugin URL now updated to most recent one.
 * 
 * Version 1.01: July 30, 2021
 * * Feature Update!
 * ** Added graphic pre-loading for save/load menu preparation. Added by Irina.
 * 
 * Version 1.00 Official Release Date: August 2, 2021
 * * Finished Plugin!
 *
 * ============================================================================
 * End of Helpfile
 * ============================================================================
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ExtFastFwdDisallow
 * @text Fast Forward: Allow/Disallow
 * @desc Change whether or not Fast Forward is allowed/disallowed.
 * Must be enabled by the Plugin Parameters.
 *
 * @arg Allow:eval
 * @text Allow?
 * @parent General
 * @type boolean
 * @on Allow
 * @off Disallow
 * @desc Allow or disallow the Extended Fast Forward feature?
 * Must be enabled by the Plugin Parameters.
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command MsgButtonConsole
 * @text Message Button Console: Show/Hide
 * @desc Determine if the Message Button Console is visible or hidden.
 * Only appears on the map. Does not appear in battle.
 *
 * @arg Visible:eval
 * @text Visible?
 * @parent General
 * @type boolean
 * @on Visible
 * @off Hidden
 * @desc Show or hide the Message Button Console feature?
 * Only appears on the map. Does not appear in battle.
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command MessageCursorSettings
 * @text Message Cursor: Change Settings
 * @desc Change the Message Cursor settings used.
 *
 * @arg MsgCursor:struct
 * @text Change Settings
 * @type struct<MsgCursor>
 * @desc Change the Message Cursor settings.
 * @default {"General":"","Enable:eval":"true","GraphicType:str":"icon","Icon":"","IconIndex:str":"188","FlipMultiplier:str":"0.125","Image":"","Filename:str":"","Rows:num":"1","Cols:num":"1","FrameDelay:num":"4","Appearance":"","AnchorX:num":"0.5","AnchorY:num":"1","OffsetX:num":"+0","OffsetY:num":"-4"}
 *
 * @ --------------------------------------------------------------------------
 *
 * @ ==========================================================================
 * @ Plugin Parameters
 * @ ==========================================================================
 *
 * @param BreakHead
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param ExtMessageFunc
 * @default Plugin Parameters
 *
 * @param ATTENTION
 * @default READ THE HELP FILE
 *
 * @param BreakSettings
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param Auto:struct
 * @text Auto-Forward Settings
 * @type struct<Auto>
 * @desc Auto-Forward settings used for this game.
 * @default {"WaitPerChar:num":"6","MinimumWait:num":"300"}
 *
 * @param FastFwd:struct
 * @text Fast Forward (Extended)
 * @type struct<FastFwd>
 * @desc Extended Fast Forward settings used for this game.
 * @default {"Enable:eval":"true","Speed:num":"8"}
 *
 * @param MsgButtonConsole:struct
 * @text Message Button Console
 * @type struct<MsgButtonConsole>
 * @desc Message Button Console settings used for this game.
 * @default {"General":"","ShowDefault:eval":"true","Position:str":"bottom","Appearance":"","WindowSkin:str":"Window","FontFace:str":"Arial","FontSize:num":"18","TextColors":"","NormalColor:str":"0","ToggledColor:str":"24","DisabledColor:str":"7","Visuals":"","ButtonWidth:num":"86","ButtonHeight:num":"36","ButtonBuffer:num":"6"}
 *
 * @param Buttons:struct
 * @text Button Settings
 * @parent MsgButtonConsole:struct
 * @type struct<Buttons>
 * @desc Settings for which buttons appear and how they appear.
 * @default {"General":"","List:arraystr":"[\"auto\",\"fastFwd\",\"log\",\"hide\",\"save\",\"load\",\"options\",\"gameEnd\"]","AutoKey:str":"none","Shortcuts":"","SaveKey:str":"none","LoadKey:str":"none","OptionsKey:str":"none","GameEndKey:str":"none","Vocab":"","Auto:str":"AUTO","FastFwd:str":"FAST","Save:str":"SAVE","Load:str":"LOAD","Options:str":"CONFIG","GameEnd:str":"TITLE"}
 *
 * @param MsgCursor:struct
 * @text Message Cursor Settings
 * @type struct<MsgCursor>
 * @desc Message Cursor settings used for this game.
 * @default {"General":"","Enable:eval":"true","GraphicType:str":"icon","Icon":"","IconIndex:str":"188","FlipMultiplier:str":"0.125","Image":"","Filename:str":"","Rows:num":"1","Cols:num":"1","FrameDelay:num":"4","Appearance":"","AnchorX:num":"0.5","AnchorY:num":"1","OffsetX:num":"+0","OffsetY:num":"-4"}
 *
 * @param BreakEnd1
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param End Of
 * @default Plugin Parameters
 *
 * @param BreakEnd2
 * @text --------------------------
 * @default ----------------------------------
 *
 */
/* ----------------------------------------------------------------------------
 * Auto-Forward Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Auto:
 *
 * @param WaitPerChar:num
 * @text Wait per Character
 * @parent General
 * @type number
 * @min 1
 * @desc How many frames should the game wait per character?
 * Average: 60 frames per second.
 * @default 6
 *
 * @param MinimumWait:num
 * @text Minimum Wait
 * @parent General
 * @type number
 * @min 1
 * @desc What is the minimum amount of frames to wait?
 * Average: 60 frames per second.
 * @default 300
 *
 */
/* ----------------------------------------------------------------------------
 * Extended Fast Forward Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~FastFwd:
 *
 * @param Enable:eval
 * @text Enable?
 * @parent General
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Enable or disable the Extended Fast Forward feature?
 * @default true
 *
 * @param Speed:num
 * @text Speed
 * @parent General
 * @type number
 * @min 2
 * @desc What is the speed at which Extended Fast Forward works at?
 * Higher numbers are faster.
 * @default 8
 *
 */
/* ----------------------------------------------------------------------------
 * Message Button Console Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~MsgButtonConsole:
 *
 * @param General
 *
 * @param ShowDefault:eval
 * @text Show by Default?
 * @parent General
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show or hide the Message Button Console by default?
 * @default true
 *
 * @param Position:str
 * @text Position
 * @parent General
 * @type select
 * @option Top of Message Window
 * @value top
 * @option Bottom of Message Window
 * @value bottom
 * @desc Where do you wish to display the Message Button Console?
 * @default bottom
 *
 * @param Appearance
 *
 * @param WindowSkin:str
 * @text Window Skin
 * @parent Appearance
 * @type file
 * @dir img/system/
 * @require 1
 * @desc What is the window skin used for the buttons?
 * Ignore if using Background Images.
 * @default Window
 *
 * @param FontFace:str
 * @text Font Name
 * @parent Appearance
 * @desc What font do you wish to use for the Message Button Console?
 * @default Arial
 *
 * @param FontSize:num
 * @text Font Size
 * @parent FontFace:str
 * @type number
 * @min 1
 * @desc What font size do you wish to use for the Message Button Console?
 * @default 18
 * 
 * @param TextColors
 * @text Text Colors
 * @parent Appearance
 *
 * @param NormalColor:str
 * @text Normal Color
 * @parent TextColors
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 0
 *
 * @param ToggledColor:str
 * @text Toggled Color
 * @parent TextColors
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 24
 *
 * @param DisabledColor:str
 * @text Disabled Color
 * @parent TextColors
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 7
 *
 * @param Visuals
 * @text Button Visuals
 * @parent Appearance
 *
 * @param ButtonWidth:num
 * @text Width
 * @parent Visuals
 * @type number
 * @min 1
 * @desc What is the width of each button?
 * @default 86
 *
 * @param ButtonHeight:num
 * @text Height
 * @parent Visuals
 * @type number
 * @min 1
 * @desc What is the height of each button?
 * @default 36
 *
 * @param ButtonBuffer:num
 * @text Buffer
 * @parent Visuals
 * @type number
 * @min 1
 * @desc What is the buffer between each button?
 * @default 6
 *
 * @param Images
 * @text Background Images
 * @parent Appearance
 *
 * @param ImgDisabled:str
 * @text Disabled Image
 * @parent Images
 * @type file
 * @dir img/system/
 * @require 1
 * @desc Filename of the background image when the button is disabled.
 * @default 
 *
 * @param ImgDisabledOffsetX:num
 * @text Offset X
 * @parent ImgDisabled:str
 * @desc Offsets the X position of this image.
 * Negative: left; Positive: right
 * @default +0
 *
 * @param ImgDisabledOffsetY:num
 * @text Offset Y
 * @parent ImgDisabled:str
 * @desc Offsets the Y position of this image.
 * Negative: up; Positive: down
 * @default +0
 *
 * @param ImgEnabled:str
 * @text Enabled Image
 * @parent Images
 * @type file
 * @dir img/system/
 * @require 1
 * @desc Filename of the background image when the button is enabled.
 * @default 
 *
 * @param ImgEnabledOffsetX:num
 * @text Offset X
 * @parent ImgEnabled:str
 * @desc Offsets the X position of this image.
 * Negative: left; Positive: right
 * @default +0
 *
 * @param ImgEnabledOffsetY:num
 * @text Offset Y
 * @parent ImgEnabled:str
 * @desc Offsets the Y position of this image.
 * Negative: up; Positive: down
 * @default +0
 *
 * @param ImgToggled:str
 * @text Toggled Image
 * @parent Images
 * @type file
 * @dir img/system/
 * @require 1
 * @desc Filename of the background image when the button is toggled.
 * @default 
 *
 * @param ImgToggledOffsetX:num
 * @text Offset X
 * @parent ImgToggled:str
 * @desc Offsets the X position of this image.
 * Negative: left; Positive: right
 * @default +0
 *
 * @param ImgToggledOffsetY:num
 * @text Offset Y
 * @parent ImgToggled:str
 * @desc Offsets the Y position of this image.
 * Negative: up; Positive: down
 * @default +0
 *
 */
/* ----------------------------------------------------------------------------
 * Buttons Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Buttons:
 *
 * @param General
 *
 * @param List:arraystr
 * @text List
 * @parent General
 * @type combo[]
 * @option auto
 * @option log
 * @option fastFwd
 * @option gameEnd
 * @option hide
 * @option load
 * @option options
 * @option save
 * @desc Which buttons appear and in what order?
 * Some commands require certain plugins installed.
 * @default ["auto","fastFwd","log","hide","save","load","options","gameEnd"]
 * 
 * @param Shortcuts
 * @text Shortcut Keys
 *
 * @param AutoKey:str
 * @text Auto-Forward Key
 * @parent General
 * @type combo
 * @option none
 * @option tab
 * @option shift
 * @option control
 * @option pageup
 * @option pagedown
 * @desc This is the key used for auto-forwarding messages.
 * @default none
 * 
 * @param SaveKey:str
 * @text Save Key
 * @parent Shortcuts
 * @type combo
 * @option none
 * @option tab
 * @option shift
 * @option control
 * @option pageup
 * @option pagedown
 * @desc This is the key used for quick saving.
 * Requires VisuMZ_1_SaveCore!
 * @default none
 * 
 * @param LoadKey:str
 * @text Load Key
 * @parent Shortcuts
 * @type combo
 * @option none
 * @option tab
 * @option shift
 * @option control
 * @option pageup
 * @option pagedown
 * @desc This is the key used for quick load.
 * Requires VisuMZ_1_SaveCore!
 * @default none
 * 
 * @param OptionsKey:str
 * @text Options Key
 * @parent Shortcuts
 * @type combo
 * @option none
 * @option tab
 * @option shift
 * @option control
 * @option pageup
 * @option pagedown
 * @desc This is the key used for opening options.
 * Requires VisuMZ_1_OptionsCore!
 * @default none
 * 
 * @param GameEndKey:str
 * @text Game End Key
 * @parent Shortcuts
 * @type combo
 * @option none
 * @option tab
 * @option shift
 * @option control
 * @option pageup
 * @option pagedown
 * @desc This is the key used for ending the game.
 * @default none
 *
 * @param Vocab
 * @text Vocabulary
 *
 * @param Auto:str
 * @text Auto-Forward
 * @parent Vocab
 * @desc How is this option's text displayed in-game?
 * @default AUTO
 *
 * @param FastFwd:str
 * @text Fast Forward
 * @parent Vocab
 * @desc How is this option's text displayed in-game?
 * @default FAST
 *
 * @param Save:str
 * @text Save Game
 * @parent Vocab
 * @desc How is this option's text displayed in-game?
 * Requires VisuMZ_1_SaveCore!
 * @default SAVE
 *
 * @param Load:str
 * @text Load Game
 * @parent Vocab
 * @desc How is this option's text displayed in-game?
 * Requires VisuMZ_1_SaveCore!
 * @default LOAD
 *
 * @param Options:str
 * @text Options
 * @parent Vocab
 * @desc How is this option's text displayed in-game?
 * Requires VisuMZ_1_OptionsCore!
 * @default CONFIG
 *
 * @param GameEnd:str
 * @text Game End
 * @parent Vocab
 * @desc How is this option's text displayed in-game?
 * @default TITLE
 *
 */
/* ----------------------------------------------------------------------------
 * Message Cursor Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~MsgCursor:
 *
 * @param General
 *
 * @param Enable:eval
 * @text Enable?
 * @parent General
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Enable or disable the message cursor?
 * @default true
 *
 * @param GraphicType:str
 * @text Graphic Type
 * @parent General
 * @type select
 * @option Icon - From img/system/IconSet.png
 * @value icon
 * @option Image - An animated image from img/system/
 * @value image
 * @desc What is the cursor's graphic type?
 * @default icon
 * 
 * @param Icon
 *
 * @param IconIndex:str
 * @text Icon Index
 * @parent Icon
 * @desc This is icon used for the Message Cursor.
 * @default 188
 *
 * @param FlipMultiplier:str
 * @text Flip Speed Multiplier
 * @parent Icon
 * @desc What is the flip speed multiplier for the Message Cursor?
 * Use 0 for no flipping.
 * @default 1
 * 
 * @param Image
 *
 * @param Filename:str
 * @text Filename
 * @parent Image
 * @type file
 * @dir img/system/
 * @require 1
 * @desc Filename of the image found inside the img/system/ folder.
 * @default 
 *
 * @param Rows:num
 * @text Image Rows
 * @parent Image
 * @type number
 * @min 1
 * @desc How many rows are there for the image?
 * @default 1
 *
 * @param Cols:num
 * @text Image Columns
 * @parent Image
 * @type number
 * @min 1
 * @desc How many columns are there for the image?
 * @default 1
 *
 * @param FrameDelay:num
 * @text Frame Delay
 * @parent Image
 * @type number
 * @min 1
 * @desc How many frames delayed are there per animated cell?
 * @default 4
 * 
 * @param Appearance
 *
 * @param AnchorX:num
 * @text Anchor X
 * @parent Appearance
 * @desc Determine the Message Cursor's X position.
 * Use a number between 0 and 1 for best results.
 * @default 0.5
 *
 * @param AnchorY:num
 * @text Anchor Y
 * @parent Appearance
 * @desc Determine the Message Cursor's Y position.
 * Use a number between 0 and 1 for best results.
 * @default 1
 *
 * @param OffsetX:num
 * @text Offset X
 * @parent Appearance
 * @desc Offset the Message Cursor's X position by how many pixels?
 * @default +0
 *
 * @param OffsetY:num
 * @text Offset Y
 * @parent Appearance
 * @desc Offset the Message Cursor's Y position by how many pixels?
 * @default -8
 *
 */
//=============================================================================

const _0x5cbe56=_0x3313;function _0xa2b5(){const _0x19034b=['updateFade','AUTO_FORWARD_DELAY_PER_CHAR','alignButtonConsoleButtons','fQrMS','skip','sxnUX','opacity','windowskin','padding','push','DEFAULT_SHOW','MessageCore','_choiceListWindow','updateImageMessageCursorPauseSignSprites','Speed','isSceneBattle','Rows','loadPartyGraphics','requestAnimation','hbNVS','%1\x27s\x20version\x20does\x20not\x20match\x20plugin\x27s.\x20Please\x20update\x20it\x20in\x20the\x20Plugin\x20Manager.','bottom','loadSvActor','ARRAYNUM','CGfgD','_disallowFastForward','_cache_customMessageCursorFrameCount','isTouchScrollEnabled','faceName','Wfyut','updateConsoleVisibility','mvjhK','TDXES','tOKKX','processButtonShortcut','createCustomMessageCursorPauseSignSprites','isMainMenuMessageLogEnabled','playOkSound','updateExtMsgFuncResetTimers','88SSVeWK','cos','loadSystemImages','GameEnd','hQEab','WindowLayer_update','buffer','SHORTCUT_KEY','Position','_pauseSignSprite','IjSoI','opzlE','auto','KaFgh','toggleMessageWindowVisibility','OgsBf','ZJpzo','VNjLK','fsvbK','updateIconMessageCursorPauseSignSprites','Game_Temp_requestAnimation','Window_Message_addedHeight','Window_Message_newPage','_lastExtMsgFuncIndex','MinimumWait','moveCustomMessageCursorPauseSign','_updatePauseSign','AnchorY','match','Buttons','getColor','_extFastForwardLooping','clamp','EXT_FAST_FORWARD_ENABLED','Save','max','nwcWI','updateColor','isEventRunning','isPressed','prototype','Window_Message_initMembers','getMessageCursorSettings','addedHeight','ExtFastFwdDisallow','isRTL','loadSystem','FONT_SIZE','Scene_Battle_update','initMessageButtonConsole','ButtonBuffer','escape','description','updateBackOpacity','ARRAYJSON','return\x200','isCustomMessageCursorEnabled','_buttonConsoleSprites','_autoForwardCount','_type','map','registerCommand','ZWpAJ','wePFb','isFurnitureSystemMode','1020PCoRPy','VisuMZ_4_MessageVisibility','show','30464290miJgvE','setExtendedFastForwardMode','ImgEnabled','_cachedIndex','cnkbj','isAnySavefileExists','addAutoForwardDelay','AnchorX','constructor','_numberInputWindow','mZCsT','height','updateDimensions','Scene_Map_updateMainMultiply','ImgToggled','IconSet','_heldDownFastFwd','log','toggleAutoForward','_createPauseSignSprites','TEXT_COLOR_NORMAL','Game_System_initialize','WZhKr','initMessageCursorSettings','isCancelled','_extendedFastForwardMode','round','anchor','Window_Message_updateDimensions','members','1192962EfwhdW','createContents','onTouchScrollStart','USE_BACK_IMAGE_SPRITES','parameters','weYFX','iconWidth','VisuMZ_3_MessageLog','isSceneUsingExFastForward','setMessageCursorSettings','fastfwd','addChild','ShowDefault','backlog','_eventItemWindow','_messageAutoForwardMode','trim','drawText','raajq','syMPp','Cols','_refreshPauseSign','exit','BUTTON_ORDER','WZXGG','qOlnZ','OffsetY','resetFontSettings','status','refresh','updatePauseSignHeightextMsgFunction','qQFSe','NOdnf','Options','MsgButtonConsole','isSaveEnabled','initMembers','update','ConvertParams','loadCharacter','The\x20latest\x20version\x20is\x20required\x20to\x20use\x0a','TEXT_COLOR_DISABLED','AUTO_FORWARD_MIN_DELAY','msgButtonConsole','rdtdn','SRiTs','_index','ifsdB','isAnySubWindowActive','the\x20VisuMZ_2_ExtMessageFunc\x20plugin.','top','Enable','makeDeepCopy','name','isExtendedFastForwardDisallowed','ButtonWidth','isMessageButtonConsoleVisible','includes','HayOR','ExtMessageFunc','Auto','DisabledColor','CZCme','initExtendedFastForward','_childInterpreter','OffsetX','length','Visible','vIhet','loadWindowskin','drawMessageFace','_messageButtonConsoleVisible','version','RycRV','hide','_parentWindow','BUTTON_HEIGHT','zFgHN','image','meetExtMsgFuncResetRequirements','flushTextState','fontSize','General','HjUUY','toUpperCase','isMessageAutoForwardMode','FastFwd','createButtonConsole','4960290zOrLHZ','_messageWindow','alpha','VrEzk','Window_Message_startPause','updateEffekseer','updateBackImageSpriteVisibility','Window_Base_flushTextState','BXNni','Filename','setFrame','_hideButtonConsole','isExtendedFastForwardMode','backOpacity','ImgDisabled','Window_Message_update','cZQwF','BUTTON_WIDTH','zSbNz','format','tHuSI','Game_Interpreter_command101','updateCustomMessageCursorPauseSignSprites','textColorID','updateExtendedFastForwardCancel','isClosing','replace','2847XJJJoe','JSON','EXT_FAST_FORWARD_LOOPS','frameCount','innerHeight','center','floor','setMessageAutoForwardMode','itemPadding','zDlAQ','%1\x20is\x20missing\x20a\x20required\x20plugin.\x0aPlease\x20install\x20%2\x20into\x20the\x20Plugin\x20Manager.','uvJRg','xmjuI','%1OffsetY','updateExtendedFastForwardMode','scale','loadFace','Gonqg','characterName','refreshCustomMessageCursorPauseSign','BUTTON_BUFFER','showButtonConsole','sYwbD','FQsDG','_msgCursorSettings','save','ThmFn','isOpen','_buttonConsoleButtons','faceIndex','Settings','Scene_Boot_loadSystemImages','%1\x20is\x20incorrectly\x20placed\x20on\x20the\x20plugin\x20list.\x0aIt\x20is\x20a\x20Tier\x20%2\x20plugin\x20placed\x20over\x20other\x20Tier\x20%3\x20plugins.\x0aPlease\x20reorder\x20the\x20plugin\x20list\x20from\x20smallest\x20to\x20largest\x20tier\x20numbers.','WindowSkin','GameEndKey','addButtonConsoleObject','742419ZJdNPY','checkBackImageSprites','setMessageButtonConsoleVisible','VOCAB','fZLwf','contents','onSavefileOk','VisuMZ_1_MessageCore\x20is\x20out\x20of\x20date.\x0a','MsgCursor','_contentsSprite','toLowerCase','textColor','openness','refreshButtonConsole','playCancel','List','JYKyQ','load','_pauseSignAnimationCount','newPage','Window_Message_isTriggered','STR','setExtendedFastForwardDisallowed','gameend','width','updateMain','options','create','Rfeee','SceneManager_push','isSceneMap','Window_Message','VisuMZ_2_FurnitureSystem','TEXT_COLOR_TOGGLED','DqnDU','bitmap','krPoN','text','6euyqEo','Window_Message_startWait','FlipMultiplier','FastForwardKey','RUUUQ','TILob','ToggledColor','FrameDelay','WaitPerChar','METEB','loadSystemImagesForExtMessageFunc','252878OfHXlS','YGPDz','startWait','10811241RHqBCP','mOXCC','autoForwardTriggered','playBuzzerSound','call','SKIN','MessageCursorSettings','anyActiveMessageInputWindows','battlerName','POSITION','parse','_scene','ODkke','daTFi','visible','ajLOI','command101','ARRAYEVAL','updateMainMultiply','createBackImageSprites','isTriggered','isActivatedExtendedFastForwardMode','prepareHideButtonConsoleTextCode','#%1','initialize','innerWidth','filter','FUamv','active','ARRAYSTR'];_0xa2b5=function(){return _0x19034b;};return _0xa2b5();}function _0x3313(_0x32a6bd,_0x326b0c){const _0xa2b563=_0xa2b5();return _0x3313=function(_0x3313bc,_0x643e50){_0x3313bc=_0x3313bc-0x83;let _0x4fe452=_0xa2b563[_0x3313bc];return _0x4fe452;},_0x3313(_0x32a6bd,_0x326b0c);}(function(_0x1b918d,_0x3ea635){const _0x27640e=_0x3313,_0x3104be=_0x1b918d();while(!![]){try{const _0x55d0df=-parseInt(_0x27640e(0x1a4))/0x1*(parseInt(_0x27640e(0x1af))/0x2)+parseInt(_0x27640e(0x15a))/0x3*(parseInt(_0x27640e(0xc6))/0x4)+parseInt(_0x27640e(0x13f))/0x5+-parseInt(_0x27640e(0xe7))/0x6+-parseInt(_0x27640e(0x1b2))/0x7+parseInt(_0x27640e(0x85))/0x8*(-parseInt(_0x27640e(0x17e))/0x9)+parseInt(_0x27640e(0xc9))/0xa;if(_0x55d0df===_0x3ea635)break;else _0x3104be['push'](_0x3104be['shift']());}catch(_0x9577c7){_0x3104be['push'](_0x3104be['shift']());}}}(_0xa2b5,0xd4af5));var label=_0x5cbe56(0x122),tier=tier||0x0,dependencies=['VisuMZ_1_MessageCore'],pluginData=$plugins[_0x5cbe56(0x1cc)](function(_0x5da4f5){const _0x2467f6=_0x5cbe56;return _0x5da4f5[_0x2467f6(0x103)]&&_0x5da4f5[_0x2467f6(0xb9)][_0x2467f6(0x120)]('['+label+']');})[0x0];VisuMZ[label][_0x5cbe56(0x178)]=VisuMZ[label][_0x5cbe56(0x178)]||{},VisuMZ[_0x5cbe56(0x10d)]=function(_0xa39d1e,_0x41fce1){const _0x1b8895=_0x5cbe56;for(const _0x6b94ac in _0x41fce1){if(_0x6b94ac[_0x1b8895(0xa1)](/(.*):(.*)/i)){const _0xe5bffc=String(RegExp['$1']),_0x1929e2=String(RegExp['$2'])['toUpperCase']()['trim']();let _0x5a79c1,_0x383854,_0x2ddbe2;switch(_0x1929e2){case'NUM':_0x5a79c1=_0x41fce1[_0x6b94ac]!==''?Number(_0x41fce1[_0x6b94ac]):0x0;break;case _0x1b8895(0x1e7):_0x383854=_0x41fce1[_0x6b94ac]!==''?JSON[_0x1b8895(0x1bc)](_0x41fce1[_0x6b94ac]):[],_0x5a79c1=_0x383854[_0x1b8895(0xc1)](_0x37b1e3=>Number(_0x37b1e3));break;case'EVAL':_0x5a79c1=_0x41fce1[_0x6b94ac]!==''?eval(_0x41fce1[_0x6b94ac]):null;break;case _0x1b8895(0x1c3):_0x383854=_0x41fce1[_0x6b94ac]!==''?JSON[_0x1b8895(0x1bc)](_0x41fce1[_0x6b94ac]):[],_0x5a79c1=_0x383854['map'](_0x38f7ce=>eval(_0x38f7ce));break;case _0x1b8895(0x15b):_0x5a79c1=_0x41fce1[_0x6b94ac]!==''?JSON[_0x1b8895(0x1bc)](_0x41fce1[_0x6b94ac]):'';break;case _0x1b8895(0xbb):_0x383854=_0x41fce1[_0x6b94ac]!==''?JSON['parse'](_0x41fce1[_0x6b94ac]):[],_0x5a79c1=_0x383854[_0x1b8895(0xc1)](_0x452305=>JSON[_0x1b8895(0x1bc)](_0x452305));break;case'FUNC':_0x5a79c1=_0x41fce1[_0x6b94ac]!==''?new Function(JSON[_0x1b8895(0x1bc)](_0x41fce1[_0x6b94ac])):new Function(_0x1b8895(0xbc));break;case'ARRAYFUNC':_0x383854=_0x41fce1[_0x6b94ac]!==''?JSON[_0x1b8895(0x1bc)](_0x41fce1[_0x6b94ac]):[],_0x5a79c1=_0x383854[_0x1b8895(0xc1)](_0x4ff511=>new Function(JSON[_0x1b8895(0x1bc)](_0x4ff511)));break;case _0x1b8895(0x193):_0x5a79c1=_0x41fce1[_0x6b94ac]!==''?String(_0x41fce1[_0x6b94ac]):'';break;case _0x1b8895(0x1cf):_0x383854=_0x41fce1[_0x6b94ac]!==''?JSON['parse'](_0x41fce1[_0x6b94ac]):[],_0x5a79c1=_0x383854['map'](_0xffa797=>String(_0xffa797));break;case'STRUCT':_0x2ddbe2=_0x41fce1[_0x6b94ac]!==''?JSON[_0x1b8895(0x1bc)](_0x41fce1[_0x6b94ac]):{},_0x5a79c1=VisuMZ[_0x1b8895(0x10d)]({},_0x2ddbe2);break;case'ARRAYSTRUCT':_0x383854=_0x41fce1[_0x6b94ac]!==''?JSON[_0x1b8895(0x1bc)](_0x41fce1[_0x6b94ac]):[],_0x5a79c1=_0x383854[_0x1b8895(0xc1)](_0x21f653=>VisuMZ['ConvertParams']({},JSON[_0x1b8895(0x1bc)](_0x21f653)));break;default:continue;}_0xa39d1e[_0xe5bffc]=_0x5a79c1;}}return _0xa39d1e;},(_0x28602b=>{const _0x16d699=_0x5cbe56,_0x39a685=_0x28602b[_0x16d699(0x11c)];for(const _0x661107 of dependencies){if(_0x16d699(0x1ef)!==_0x16d699(0x174)){if(!Imported[_0x661107]){alert(_0x16d699(0x164)[_0x16d699(0x152)](_0x39a685,_0x661107)),SceneManager['exit']();break;}}else _0x3be7ed['isMainMenuMessageLogEnabled']()&&_0x2be823['isSceneMap']()?(this[_0x16d699(0x83)](),_0x32b04a[_0x16d699(0x1d9)](_0x29a92f)):this[_0x16d699(0x1b5)]();}const _0x23435f=_0x28602b['description'];if(_0x23435f[_0x16d699(0xa1)](/\[Version[ ](.*?)\]/i)){const _0x26c0f0=Number(RegExp['$1']);_0x26c0f0!==VisuMZ[label]['version']&&(alert(_0x16d699(0x1e4)[_0x16d699(0x152)](_0x39a685,_0x26c0f0)),SceneManager[_0x16d699(0xfd)]());}if(_0x23435f[_0x16d699(0xa1)](/\[Tier[ ](\d+)\]/i)){const _0x284852=Number(RegExp['$1']);if(_0x284852<tier)_0x16d699(0xa9)!==_0x16d699(0x1a2)?(alert(_0x16d699(0x17a)[_0x16d699(0x152)](_0x39a685,_0x284852,tier)),SceneManager[_0x16d699(0xfd)]()):_0x14d6e8[_0x16d699(0x16a)](_0x11febc[_0x16d699(0x1ec)]());else{if('METEB'===_0x16d699(0x1ad))tier=Math[_0x16d699(0xa8)](_0x284852,tier);else return _0x3deba3[_0x16d699(0x110)];}}VisuMZ['ConvertParams'](VisuMZ[label][_0x16d699(0x178)],_0x28602b[_0x16d699(0xeb)]);})(pluginData),PluginManager[_0x5cbe56(0xc2)](pluginData['name'],_0x5cbe56(0xb1),_0xf86ed3=>{const _0x48ab1c=_0x5cbe56;VisuMZ['ConvertParams'](_0xf86ed3,_0xf86ed3);const _0x8c627c=!_0xf86ed3['Allow'];$gameSystem[_0x48ab1c(0x194)](_0x8c627c);}),PluginManager[_0x5cbe56(0xc2)](pluginData[_0x5cbe56(0x11c)],_0x5cbe56(0x109),_0x569688=>{const _0x322859=_0x5cbe56;VisuMZ['ConvertParams'](_0x569688,_0x569688);const _0x42035b=_0x569688[_0x322859(0x12a)];$gameSystem['setMessageButtonConsoleVisible'](_0x42035b);}),PluginManager[_0x5cbe56(0xc2)](pluginData[_0x5cbe56(0x11c)],_0x5cbe56(0x1b8),_0x241d6b=>{const _0xb61577=_0x5cbe56;VisuMZ['ConvertParams'](_0x241d6b,_0x241d6b);const _0x2f998e=_0x241d6b['MsgCursor'];$gameSystem[_0xb61577(0xf0)](_0x2f998e);const _0x2e0544=SceneManager['_scene']['_messageWindow'];_0x2e0544&&(_0x2e0544[_0xb61577(0xdc)](),_0x2e0544[_0xb61577(0xfc)]());}),TextManager[_0x5cbe56(0x112)]=function(_0x1b7fca){const _0x28dc69=_0x5cbe56;if(Window_ButtonConsole[_0x28dc69(0x181)][_0x1b7fca])return _0x28dc69(0x142)!==_0x28dc69(0x142)?_0x1b8307[_0x28dc69(0x181)][_0x4f34aa]:Window_ButtonConsole[_0x28dc69(0x181)][_0x1b7fca];return _0x1b7fca[_0x28dc69(0x13b)]()['trim']();},ColorManager[_0x5cbe56(0xa3)]=function(_0x25184e){const _0x31e7d9=_0x5cbe56;_0x25184e=String(_0x25184e);if(_0x25184e[_0x31e7d9(0xa1)](/#(.*)/i)){if('BXNni'===_0x31e7d9(0x147))return'#%1'['format'](String(RegExp['$1']));else this[_0x31e7d9(0x1b5)]();}else return _0x31e7d9(0x114)!==_0x31e7d9(0x121)?this['textColor'](Number(_0x25184e)):!![];},SceneManager[_0x5cbe56(0x1df)]=function(){const _0x2fd5a1=_0x5cbe56;return this[_0x2fd5a1(0x1bd)]&&this['_scene'][_0x2fd5a1(0xd1)]===Scene_Battle;},SceneManager['isSceneMap']=function(){const _0x5f04de=_0x5cbe56;return this[_0x5f04de(0x1bd)]&&this[_0x5f04de(0x1bd)]['constructor']===Scene_Map;},VisuMZ['ExtMessageFunc'][_0x5cbe56(0x19b)]=SceneManager[_0x5cbe56(0x1d9)],SceneManager['push']=function(_0xf96abd){const _0x102c5f=_0x5cbe56;VisuMZ[_0x102c5f(0x122)][_0x102c5f(0x19b)][_0x102c5f(0x1b6)](this,_0xf96abd);if([Scene_SaveButtonConsole,Scene_Save,Scene_Load][_0x102c5f(0x120)](_0xf96abd)){if(_0x102c5f(0x166)===_0x102c5f(0x166))this[_0x102c5f(0x1e1)]();else return this['autoForwardTriggered']();}},SceneManager['loadPartyGraphics']=function(){const _0xdb4f58=_0x5cbe56;for(const _0xfc38b4 of $gameParty[_0xdb4f58(0xe6)]()){if(_0xdb4f58(0x106)!==_0xdb4f58(0x12b)){if(_0xfc38b4[_0xdb4f58(0x1ec)]()){if('LroDC'===_0xdb4f58(0x92))return this[_0xdb4f58(0xdb)](),![];else ImageManager[_0xdb4f58(0x16a)](_0xfc38b4[_0xdb4f58(0x1ec)]());}_0xfc38b4[_0xdb4f58(0x16c)]()&&ImageManager[_0xdb4f58(0x10e)](_0xfc38b4[_0xdb4f58(0x16c)]()),_0xfc38b4[_0xdb4f58(0x1ba)]()&&ImageManager[_0xdb4f58(0x1e6)](_0xfc38b4['battlerName']());}else return _0x1f0cd2[_0xdb4f58(0x19f)];}},Game_Temp[_0x5cbe56(0xad)][_0x5cbe56(0x13c)]=function(){const _0x27442d=_0x5cbe56;return this[_0x27442d(0xf6)];},Game_Temp['prototype'][_0x5cbe56(0x161)]=function(_0x4346b9){const _0x16e1e1=_0x5cbe56;this[_0x16e1e1(0xf6)]=_0x4346b9,$gameMessage[_0x16e1e1(0x18b)]();},Game_Temp[_0x5cbe56(0xad)][_0x5cbe56(0x14b)]=function(){const _0x5b1c31=_0x5cbe56;return this[_0x5b1c31(0xe2)];},Game_Temp[_0x5cbe56(0xad)]['setExtendedFastForwardMode']=function(_0x56acee){const _0x5f5d88=_0x5cbe56;this[_0x5f5d88(0xe2)]=_0x56acee,$gameMessage['refreshButtonConsole']();},VisuMZ[_0x5cbe56(0x122)][_0x5cbe56(0x99)]=Game_Temp[_0x5cbe56(0xad)][_0x5cbe56(0x1e2)],Game_Temp[_0x5cbe56(0xad)][_0x5cbe56(0x1e2)]=function(_0xb7c33a,_0x1d6a72,_0x5e1472){const _0x390a0c=_0x5cbe56;if(this[_0x390a0c(0xef)]())return;VisuMZ['ExtMessageFunc'][_0x390a0c(0x99)]['call'](this,_0xb7c33a,_0x1d6a72,_0x5e1472);},Game_Temp['prototype'][_0x5cbe56(0xef)]=function(){const _0x4cda2c=_0x5cbe56,_0x53eaba=SceneManager['_scene'];return _0x53eaba&&_0x53eaba['isExtendedFastForwardMode']&&_0x53eaba[_0x4cda2c(0x14b)]();},VisuMZ['ExtMessageFunc']['Game_System_initialize']=Game_System[_0x5cbe56(0xad)][_0x5cbe56(0x1ca)],Game_System['prototype'][_0x5cbe56(0x1ca)]=function(){const _0x134bc8=_0x5cbe56;VisuMZ[_0x134bc8(0x122)][_0x134bc8(0xde)]['call'](this),this[_0x134bc8(0xb6)](),this[_0x134bc8(0x126)](),this['initMessageCursorSettings']();},Game_System['prototype'][_0x5cbe56(0xb6)]=function(){const _0x41179c=_0x5cbe56;this[_0x41179c(0x12e)]=Window_ButtonConsole[_0x41179c(0x1da)];},Game_System[_0x5cbe56(0xad)][_0x5cbe56(0x11f)]=function(){const _0x14fcfb=_0x5cbe56;return this[_0x14fcfb(0x12e)]===undefined&&(_0x14fcfb(0xc4)!==_0x14fcfb(0xc4)?_0xedfee5['y']=_0x11934f:this[_0x14fcfb(0xb6)]()),this[_0x14fcfb(0x12e)];},Game_System[_0x5cbe56(0xad)][_0x5cbe56(0x180)]=function(_0x300b94){const _0x2cc1f7=_0x5cbe56;this[_0x2cc1f7(0x12e)]===undefined&&this[_0x2cc1f7(0xb6)](),this[_0x2cc1f7(0x12e)]=_0x300b94;},Game_System['prototype'][_0x5cbe56(0x126)]=function(){const _0x269e47=_0x5cbe56;this[_0x269e47(0x1e9)]=![];},Game_System[_0x5cbe56(0xad)][_0x5cbe56(0x11d)]=function(){const _0x444e66=_0x5cbe56;return this['_disallowFastForward']===undefined&&this[_0x444e66(0x126)](),this[_0x444e66(0x1e9)];},Game_System[_0x5cbe56(0xad)]['setExtendedFastForwardDisallowed']=function(_0x514bd7){const _0x3f3db6=_0x5cbe56;if(this[_0x3f3db6(0x1e9)]===undefined){if(_0x3f3db6(0x1ed)===_0x3f3db6(0x1ed))this['initExtendedFastForward']();else return _0x3f3db6(0x1c9)[_0x3f3db6(0x152)](_0x102363(_0x342262['$1']));}this[_0x3f3db6(0x1e9)]=_0x514bd7;},Game_System[_0x5cbe56(0xad)][_0x5cbe56(0xe0)]=function(){const _0x34efe6=_0x5cbe56;this[_0x34efe6(0x172)]=JsonEx[_0x34efe6(0x11b)](VisuMZ[_0x34efe6(0x122)][_0x34efe6(0x178)][_0x34efe6(0x186)]);},Game_System[_0x5cbe56(0xad)]['getMessageCursorSettings']=function(){const _0x303385=_0x5cbe56;return this[_0x303385(0x172)]===undefined&&this['initMessageCursorSettings'](),this[_0x303385(0x172)];},Game_System[_0x5cbe56(0xad)][_0x5cbe56(0xf0)]=function(_0x4c4bf6){const _0x55e43e=_0x5cbe56;this['_msgCursorSettings']===undefined&&this[_0x55e43e(0xe0)](),this['_msgCursorSettings']=JsonEx[_0x55e43e(0x11b)](_0x4c4bf6);},Game_Message[_0x5cbe56(0xad)][_0x5cbe56(0x18b)]=function(){const _0x398788=_0x5cbe56,_0x1e04e0=SceneManager[_0x398788(0x1bd)];if(!_0x1e04e0)return;const _0x5365eb=_0x1e04e0[_0x398788(0x140)];if(!_0x5365eb)return;_0x5365eb['refreshButtonConsole']();},VisuMZ[_0x5cbe56(0x122)][_0x5cbe56(0x179)]=Scene_Boot[_0x5cbe56(0xad)][_0x5cbe56(0x87)],Scene_Boot[_0x5cbe56(0xad)]['loadSystemImages']=function(){const _0x5109e3=_0x5cbe56;VisuMZ[_0x5109e3(0x122)][_0x5109e3(0x179)][_0x5109e3(0x1b6)](this),this[_0x5109e3(0x1ae)]();},Scene_Boot[_0x5cbe56(0xad)]['loadSystemImagesForExtMessageFunc']=function(){const _0x3df0bd=_0x5cbe56,_0x7c3c2d=VisuMZ[_0x3df0bd(0x122)][_0x3df0bd(0x178)][_0x3df0bd(0x109)],_0x1a83c5=[_0x3df0bd(0x14d),_0x3df0bd(0xcb),'ImgToggled'];for(const _0x350dea of _0x1a83c5){if('hbNVS'===_0x3df0bd(0x1e3))_0x7c3c2d[_0x350dea]=_0x7c3c2d[_0x350dea]??'',_0x7c3c2d[_0x350dea]!==''&&ImageManager[_0x3df0bd(0xb3)](_0x7c3c2d[_0x350dea]);else{if(_0xb2702b[_0x3df0bd(0x1bd)][_0x3df0bd(0x14b)]())return;_0x596c3d[_0x3df0bd(0x122)][_0x3df0bd(0x1a5)][_0x3df0bd(0x1b6)](this,_0x507c92);}}},Scene_Message[_0x5cbe56(0xa6)]=VisuMZ['ExtMessageFunc']['Settings'][_0x5cbe56(0x13d)][_0x5cbe56(0x11a)],Scene_Message['EXT_FAST_FORWARD_LOOPS']=VisuMZ[_0x5cbe56(0x122)][_0x5cbe56(0x178)][_0x5cbe56(0x13d)][_0x5cbe56(0x1de)],Scene_Message[_0x5cbe56(0xad)][_0x5cbe56(0x14b)]=function(){const _0x230064=_0x5cbe56;if(!Scene_Message[_0x230064(0xa6)])return![];if($gameSystem[_0x230064(0x11d)]())return![];if(this[_0x230064(0x1b9)]())return![];return this[_0x230064(0x1c7)]();},Scene_Message['prototype'][_0x5cbe56(0x1c7)]=function(){const _0x24d3a8=_0x5cbe56;if(Imported[_0x24d3a8(0x19e)]&&$gameMap[_0x24d3a8(0xc5)]()){if(_0x24d3a8(0x1a9)==='gQFst'){const _0x5f3bce=_0x2bfb1c[_0x24d3a8(0xaf)]();this[_0x24d3a8(0x8e)]=new _0x3f2790(),this['addChild'](this[_0x24d3a8(0x8e)]),this['_pauseSignSprite']['anchor']['x']=_0x5f3bce[_0x24d3a8(0xd0)],this[_0x24d3a8(0x8e)][_0x24d3a8(0xe4)]['y']=_0x5f3bce[_0x24d3a8(0xa0)],this[_0x24d3a8(0x190)]=0x0;}else return![];}if(!this[_0x24d3a8(0x1b9)]()){if(Input['isPressed'](VisuMZ[_0x24d3a8(0x1db)][_0x24d3a8(0x178)]['General'][_0x24d3a8(0x1a7)]))return _0x24d3a8(0x19a)!==_0x24d3a8(0x19a)?this[_0x24d3a8(0x189)](_0x20282e(_0xbb4f7b)):!![];}return $gameTemp[_0x24d3a8(0x14b)]();},Scene_Message[_0x5cbe56(0xad)][_0x5cbe56(0x1b9)]=function(){const _0x3203d9=_0x5cbe56;if(this[_0x3203d9(0x1dc)]&&this['_choiceListWindow'][_0x3203d9(0x1ce)])return!![];if(this[_0x3203d9(0xd2)]&&this[_0x3203d9(0xd2)]['active'])return!![];if(this[_0x3203d9(0xf5)]&&this['_eventItemWindow'][_0x3203d9(0x1ce)])return!![];return![];},Scene_Message[_0x5cbe56(0xad)][_0x5cbe56(0x157)]=function(){const _0x185f2d=_0x5cbe56;if(Input['isTriggered']('escape')||TouchInput[_0x185f2d(0xe1)]()){if(_0x185f2d(0x1cd)===_0x185f2d(0x170)){if(!_0x3b41ed[_0x185f2d(0x19c)]())return;for(const _0x3d3269 of this[_0x185f2d(0x176)]){!this[_0x185f2d(0x14a)]&&_0x1f3d4b[_0x185f2d(0x11f)]()?_0x3d3269[_0x185f2d(0xc8)]():_0x3d3269['hide']();}this[_0x185f2d(0x1d2)]();}else return $gameTemp[_0x185f2d(0xca)](![]),!![];}else return![];},VisuMZ[_0x5cbe56(0x122)][_0x5cbe56(0xd6)]=Scene_Map[_0x5cbe56(0xad)][_0x5cbe56(0x1c4)],Scene_Map[_0x5cbe56(0xad)]['updateMainMultiply']=function(){const _0x4594c5=_0x5cbe56;this[_0x4594c5(0x14b)]()?this[_0x4594c5(0x168)]():'slvyE'!=='slvyE'?_0x15050c[_0x4594c5(0x93)]():VisuMZ['ExtMessageFunc']['Scene_Map_updateMainMultiply'][_0x4594c5(0x1b6)](this);},Scene_Map[_0x5cbe56(0xad)][_0x5cbe56(0x14b)]=function(){const _0x4bb8b2=_0x5cbe56;return Scene_Message[_0x4bb8b2(0xad)]['isExtendedFastForwardMode'][_0x4bb8b2(0x1b6)](this)&&$gameMap[_0x4bb8b2(0xab)]();},Scene_Map[_0x5cbe56(0xad)][_0x5cbe56(0x168)]=function(){const _0x20b772=_0x5cbe56;let _0x4096d6=Scene_Message[_0x20b772(0x15c)];while(_0x4096d6--&&$gameMap[_0x20b772(0xab)]()&&!this['anyActiveMessageInputWindows']()){if('rFLMO'!=='Xehbq'){this[_0x20b772(0x1d0)](),this['updateColorFilter'](),this[_0x20b772(0x197)](),SceneManager[_0x20b772(0x144)]();if(this[_0x20b772(0x157)]())break;}else{if(this[_0x20b772(0xef)]())return;_0x3583fe['ExtMessageFunc'][_0x20b772(0x99)][_0x20b772(0x1b6)](this,_0x421876,_0x361dfe,_0x87f191);}}};function Scene_SaveButtonConsole(){const _0x111d48=_0x5cbe56;this[_0x111d48(0x1ca)](...arguments);}Scene_SaveButtonConsole[_0x5cbe56(0xad)]=Object['create'](Scene_Save[_0x5cbe56(0xad)]),Scene_SaveButtonConsole[_0x5cbe56(0xad)][_0x5cbe56(0xd1)]=Scene_SaveButtonConsole,Scene_SaveButtonConsole[_0x5cbe56(0xad)]['onSavefileOk']=function(){const _0x595567=_0x5cbe56;this[_0x595567(0xcc)]=0x0;let _0xd47e66=$gameMap['_interpreter'];for(;;){if(_0xd47e66[_0x595567(0x127)])_0xd47e66=_0xd47e66[_0x595567(0x127)];else{this[_0x595567(0xcc)]=_0xd47e66[_0x595567(0x115)],_0xd47e66[_0x595567(0x115)]=_0xd47e66['_lastExtMsgFuncIndex'];break;}}Scene_Save['prototype'][_0x595567(0x184)][_0x595567(0x1b6)](this),_0xd47e66[_0x595567(0x115)]=this[_0x595567(0xcc)];},VisuMZ[_0x5cbe56(0x122)][_0x5cbe56(0x154)]=Game_Interpreter[_0x5cbe56(0xad)]['command101'],Game_Interpreter['prototype'][_0x5cbe56(0x1c2)]=function(_0x580342){const _0x2e84f7=_0x5cbe56;return this[_0x2e84f7(0x9c)]=this[_0x2e84f7(0x115)],VisuMZ[_0x2e84f7(0x122)][_0x2e84f7(0x154)][_0x2e84f7(0x1b6)](this,_0x580342);},VisuMZ[_0x5cbe56(0x122)][_0x5cbe56(0xb5)]=Scene_Battle[_0x5cbe56(0xad)][_0x5cbe56(0x10c)],Scene_Battle[_0x5cbe56(0xad)][_0x5cbe56(0x10c)]=function(){const _0x2478bc=_0x5cbe56;VisuMZ[_0x2478bc(0x122)][_0x2478bc(0xb5)][_0x2478bc(0x1b6)](this);if(this[_0x2478bc(0x14b)]())this['updateExtendedFastForwardMode']();},Scene_Battle[_0x5cbe56(0xad)][_0x5cbe56(0x14b)]=function(){const _0x6b20fb=_0x5cbe56;return![],Scene_Message[_0x6b20fb(0xad)][_0x6b20fb(0x14b)][_0x6b20fb(0x1b6)](this)&&$gameTroop[_0x6b20fb(0xab)]()&&!this['_extFastForwardLooping'];},Scene_Battle[_0x5cbe56(0xad)][_0x5cbe56(0x168)]=function(){const _0x22fe62=_0x5cbe56;this[_0x22fe62(0xa4)]=!![];let _0x11dcaa=Scene_Message[_0x22fe62(0x15c)];while(_0x11dcaa--&&$gameTroop[_0x22fe62(0xab)]()&&!this[_0x22fe62(0x1b9)]()){this[_0x22fe62(0x10c)](),SceneManager[_0x22fe62(0x144)]();if(this[_0x22fe62(0x157)]())break;}this[_0x22fe62(0xa4)]=![];},VisuMZ[_0x5cbe56(0x122)][_0x5cbe56(0x8a)]=WindowLayer[_0x5cbe56(0xad)][_0x5cbe56(0x10c)],WindowLayer['prototype'][_0x5cbe56(0x10c)]=function(){const _0x5dfe40=_0x5cbe56;if(SceneManager['_scene'][_0x5dfe40(0xa4)])return;VisuMZ[_0x5dfe40(0x122)]['WindowLayer_update'][_0x5dfe40(0x1b6)](this);},VisuMZ[_0x5cbe56(0x122)]['Window_Base_flushTextState']=Window_Base['prototype'][_0x5cbe56(0x137)],Window_Base['prototype']['flushTextState']=function(_0x4fb33f){const _0x1e10dc=_0x5cbe56;this[_0x1e10dc(0xd1)][_0x1e10dc(0x11c)]==='Window_Message'&&this[_0x1e10dc(0xcf)](_0x4fb33f),VisuMZ[_0x1e10dc(0x122)]['Window_Base_flushTextState'][_0x1e10dc(0x1b6)](this,_0x4fb33f),this[_0x1e10dc(0xd1)][_0x1e10dc(0x11c)]==='Window_Message'&&('vdSBo'==='vdSBo'?this[_0x1e10dc(0x9e)](_0x4fb33f):this[_0x1e10dc(0x9e)](_0x2e27d6));},VisuMZ[_0x5cbe56(0x122)][_0x5cbe56(0x14e)]=Window_Message[_0x5cbe56(0xad)][_0x5cbe56(0x10c)],Window_Message['prototype'][_0x5cbe56(0x10c)]=function(){const _0xc2bedb=_0x5cbe56;VisuMZ['ExtMessageFunc'][_0xc2bedb(0x14e)][_0xc2bedb(0x1b6)](this),this[_0xc2bedb(0x84)]();},Window_Message[_0x5cbe56(0xad)][_0x5cbe56(0x84)]=function(){const _0x55d77c=_0x5cbe56;if(!this['meetExtMsgFuncResetRequirements']())return;$gameTemp[_0x55d77c(0x13c)]()&&$gameTemp[_0x55d77c(0x161)](![]);if($gameTemp[_0x55d77c(0x14b)]()){if(_0x55d77c(0x130)===_0x55d77c(0x13a)){if(_0x37a690[_0x55d77c(0x1bd)][_0x55d77c(0xa4)])return;_0x5853a1[_0x55d77c(0x122)][_0x55d77c(0x8a)][_0x55d77c(0x1b6)](this);}else $gameTemp[_0x55d77c(0xca)](![]);}},Window_Message[_0x5cbe56(0xad)][_0x5cbe56(0x136)]=function(){const _0x4051dd=_0x5cbe56;if(SceneManager[_0x4051dd(0x19c)]()&&$gameMap&&!$gameMap['isEventRunning']()){if('opzlE'!==_0x4051dd(0x90))this['playBuzzerSound']();else return!![];}else{if(SceneManager[_0x4051dd(0x1df)]()&&!$gameMap[_0x4051dd(0xab)]())return _0x4051dd(0x97)!=='DhtEJ'?!![]:!![];}return![];},VisuMZ[_0x5cbe56(0x122)][_0x5cbe56(0x192)]=Window_Message[_0x5cbe56(0xad)][_0x5cbe56(0x1c6)],Window_Message[_0x5cbe56(0xad)][_0x5cbe56(0x1c6)]=function(){const _0x4452eb=_0x5cbe56;if(SceneManager[_0x4452eb(0x1bd)][_0x4452eb(0x14b)]())return!![];else{if(Input[_0x4452eb(0x1c6)](Window_ButtonConsole['SHORTCUT_KEY'][_0x4452eb(0x91)])){if('ssRNk'==='VtFHv'){if(!this[_0x4452eb(0x136)]())return;_0x240239[_0x4452eb(0x13c)]()&&_0x195c47[_0x4452eb(0x161)](![]),_0x32cfd9[_0x4452eb(0x14b)]()&&_0x3687fa[_0x4452eb(0xca)](![]);}else return this[_0x4452eb(0xdb)](),![];}else{if(Input[_0x4452eb(0x1c6)](Window_ButtonConsole['SHORTCUT_KEY']['save']))return this['processButtonShortcut'](_0x4452eb(0x173)),![];else{if(Input[_0x4452eb(0x1c6)](Window_ButtonConsole[_0x4452eb(0x8c)]['load']))return _0x4452eb(0x153)===_0x4452eb(0x153)?(this['processButtonShortcut'](_0x4452eb(0x18f)),![]):(![],_0x48415a[_0x4452eb(0xad)]['isExtendedFastForwardMode']['call'](this)&&_0x22ba6b[_0x4452eb(0xab)]()&&!this[_0x4452eb(0xa4)]);else{if(Input[_0x4452eb(0x1c6)](Window_ButtonConsole[_0x4452eb(0x8c)]['options']))return this[_0x4452eb(0x1f2)](_0x4452eb(0x198)),![];else{if(Input['isTriggered'](Window_ButtonConsole[_0x4452eb(0x8c)][_0x4452eb(0x195)]))return this[_0x4452eb(0x1f2)](_0x4452eb(0x195)),![];else{if(this['pause']&&$gameTemp[_0x4452eb(0x13c)]()){if('HrhVQ'===_0x4452eb(0x94))this[_0x4452eb(0x12e)]=_0x4f4731[_0x4452eb(0x1da)];else return this[_0x4452eb(0x1b4)]();}else return VisuMZ[_0x4452eb(0x122)][_0x4452eb(0x192)]['call'](this);}}}}}}},Window_Message['prototype'][_0x5cbe56(0x12d)]=function(){const _0x313fdf=_0x5cbe56,_0x49c94c=$gameMessage[_0x313fdf(0x1ec)](),_0x5a6ca0=$gameMessage[_0x313fdf(0x177)](),_0x2a77ba=$gameMessage[_0x313fdf(0xb2)]();let _0x5ac257=ImageManager['faceWidth'],_0x342df1=this[_0x313fdf(0x15e)],_0x370fed=_0x2a77ba?this[_0x313fdf(0x1cb)]-_0x5ac257-0x4:0x4,_0x10d40c=0x0;_0x342df1-=this['addedHeight'](),this['drawFace'](_0x49c94c,_0x5a6ca0,_0x370fed,_0x10d40c,_0x5ac257,_0x342df1);},Window_Message[_0x5cbe56(0x1d1)]=VisuMZ[_0x5cbe56(0x122)][_0x5cbe56(0x178)][_0x5cbe56(0x123)][_0x5cbe56(0x1ac)],Window_Message[_0x5cbe56(0x111)]=VisuMZ['ExtMessageFunc'][_0x5cbe56(0x178)][_0x5cbe56(0x123)][_0x5cbe56(0x9d)],Window_Message[_0x5cbe56(0xad)]['addAutoForwardDelay']=function(_0x4f8298){const _0x50c6e4=_0x5cbe56;this['_autoForwardCount']=this[_0x50c6e4(0xbf)]||0x0,this[_0x50c6e4(0xbf)]=Math[_0x50c6e4(0xa8)](this[_0x50c6e4(0xbf)],0x0);const _0x12942c=(_0x4f8298[_0x50c6e4(0x8b)]||'')['length'];this[_0x50c6e4(0xbf)]+=_0x12942c*Window_Message[_0x50c6e4(0x1d1)];},VisuMZ[_0x5cbe56(0x122)]['Window_Message_newPage']=Window_Message['prototype'][_0x5cbe56(0x191)],Window_Message[_0x5cbe56(0xad)][_0x5cbe56(0x191)]=function(_0xc37f8c){const _0x5dafd5=_0x5cbe56;this[_0x5dafd5(0x1c8)](_0xc37f8c),VisuMZ[_0x5dafd5(0x122)][_0x5dafd5(0x9b)]['call'](this,_0xc37f8c),this[_0x5dafd5(0xbf)]=0x0;},Window_Message[_0x5cbe56(0xad)][_0x5cbe56(0xdb)]=function(){const _0x328302=_0x5cbe56;if(this[_0x328302(0x14a)])return;if(!$gameSystem[_0x328302(0x11f)]())return;let _0x3ecc62=!$gameTemp[_0x328302(0x13c)]();$gameTemp[_0x328302(0x161)](_0x3ecc62),_0x3ecc62?_0x328302(0xdf)===_0x328302(0x113)?(this[_0x328302(0xd9)]=_0x5b5ec2[_0x328302(0xac)](_0x53565a[_0x328302(0x1db)]['Settings'][_0x328302(0x139)][_0x328302(0x1a7)]),this[_0x328302(0x104)]()):this['playOkSound']():SoundManager['playCancel']();},Window_Message[_0x5cbe56(0xad)][_0x5cbe56(0x1b4)]=function(){const _0x1ec079=_0x5cbe56;this[_0x1ec079(0xbf)]=this[_0x1ec079(0xbf)]||0x0;if(VisuMZ['ExtMessageFunc'][_0x1ec079(0x192)][_0x1ec079(0x1b6)](this)){if('weYFX'===_0x1ec079(0xec))return SoundManager[_0x1ec079(0x18c)](),$gameTemp[_0x1ec079(0x161)](![]),!![];else{const _0x4ccc15=_0x4e2b4c(_0x10b028['$1']);_0x4ccc15!==_0x586c8b[_0x1e130f][_0x1ec079(0x12f)]&&(_0x29d252(_0x1ec079(0x1e4)['format'](_0x18d7ab,_0x4ccc15)),_0x2cf873[_0x1ec079(0xfd)]());}}else return this[_0x1ec079(0xbf)]--<=0x0;},VisuMZ[_0x5cbe56(0x122)]['Window_Message_startPause']=Window_Message['prototype']['startPause'],Window_Message[_0x5cbe56(0xad)]['startPause']=function(){const _0x2bbac0=_0x5cbe56;VisuMZ[_0x2bbac0(0x122)][_0x2bbac0(0x143)][_0x2bbac0(0x1b6)](this),this['_autoForwardCount']=this[_0x2bbac0(0xbf)]||0x0,this[_0x2bbac0(0xbf)]=Math[_0x2bbac0(0xa8)](this['_autoForwardCount'],Window_Message['AUTO_FORWARD_MIN_DELAY']);},VisuMZ[_0x5cbe56(0x122)][_0x5cbe56(0xae)]=Window_Message['prototype'][_0x5cbe56(0x10b)],Window_Message[_0x5cbe56(0xad)]['initMembers']=function(){const _0xb8ee16=_0x5cbe56;VisuMZ[_0xb8ee16(0x122)][_0xb8ee16(0xae)][_0xb8ee16(0x1b6)](this),this[_0xb8ee16(0x13e)]();},Window_Message[_0x5cbe56(0xad)]['prepareHideButtonConsoleTextCode']=function(_0x14b6b2){const _0x2cc86a=_0x5cbe56;let _0x508283=_0x14b6b2[_0x2cc86a(0x1a3)];this['_hideButtonConsole']=![],_0x508283=_0x508283[_0x2cc86a(0x159)](/<HIDE (?:BUTTON CONSOLE|CONSOLE|BUTTONS)>/gi,()=>{const _0x124327=_0x2cc86a;return _0x124327(0xcd)==='lqMtH'?_0x21f49b[_0x124327(0x19f)]:(this[_0x124327(0x14a)]=!![],'');}),_0x14b6b2['text']=_0x508283;};if(!Window_Message['prototype'][_0x5cbe56(0xb0)]){let text='';text+=_0x5cbe56(0x185),text+=_0x5cbe56(0x10f),text+=_0x5cbe56(0x118),alert(text),SceneManager[_0x5cbe56(0xfd)]();}VisuMZ[_0x5cbe56(0x122)][_0x5cbe56(0x9a)]=Window_Message['prototype'][_0x5cbe56(0xb0)],Window_Message[_0x5cbe56(0xad)][_0x5cbe56(0xb0)]=function(){const _0x40382b=_0x5cbe56;let _0x486db2=VisuMZ[_0x40382b(0x122)]['Window_Message_addedHeight']['call'](this);if(this[_0x40382b(0x14a)])return _0x486db2;return SceneManager['isSceneMap']()&&$gameSystem[_0x40382b(0x11f)]()&&([_0x40382b(0x119),_0x40382b(0x1e5)]['includes'](Window_ButtonConsole['POSITION'][_0x40382b(0x188)]()['trim']())&&(_0x486db2+=Window_ButtonConsole[_0x40382b(0x133)])),_0x486db2;},VisuMZ[_0x5cbe56(0x122)][_0x5cbe56(0xe5)]=Window_Message[_0x5cbe56(0xad)][_0x5cbe56(0xd5)],Window_Message[_0x5cbe56(0xad)][_0x5cbe56(0xd5)]=function(){const _0x88cafd=_0x5cbe56;VisuMZ['ExtMessageFunc']['Window_Message_updateDimensions']['call'](this),this[_0x88cafd(0x16f)](),this[_0x88cafd(0x18b)]();},Window_Message[_0x5cbe56(0xad)][_0x5cbe56(0x16f)]=function(){const _0x42be60=_0x5cbe56;if(!SceneManager[_0x42be60(0x19c)]())return;for(const _0x4956bd of this[_0x42be60(0x176)]){if('zFgHN'===_0x42be60(0x134)){if(!this[_0x42be60(0x14a)]&&$gameSystem[_0x42be60(0x11f)]()){if('QhDyj'!=='QhDyj')return _0x232cc5[_0x42be60(0x1c6)](_0x42be60(0xb8))||_0x4c8ab6[_0x42be60(0xe1)]()?(_0x8eb680[_0x42be60(0xca)](![]),!![]):![];else _0x4956bd['show']();}else _0x4956bd['hide']();}else return _0xe2dd01[_0x42be60(0xad)][_0x42be60(0x14b)][_0x42be60(0x1b6)](this)&&_0x4fc575[_0x42be60(0xab)]();}this[_0x42be60(0x1d2)]();},Window_Message[_0x5cbe56(0xad)][_0x5cbe56(0x18b)]=function(){const _0x2fa36a=_0x5cbe56;for(const _0x2bd93d of this[_0x2fa36a(0x176)]){if(_0x2fa36a(0x1a0)!==_0x2fa36a(0x1a0))return this[_0x2fa36a(0xe2)];else _0x2bd93d[_0x2fa36a(0x104)]();}},Window_Message[_0x5cbe56(0xad)][_0x5cbe56(0x13e)]=function(){const _0xddca1=_0x5cbe56;this[_0xddca1(0x176)]=[];for(const _0xa5f036 of Window_ButtonConsole[_0xddca1(0xfe)]){this[_0xddca1(0x17d)](_0xa5f036);}this[_0xddca1(0x1d2)]();},Window_Message[_0x5cbe56(0xad)][_0x5cbe56(0x17d)]=function(_0x37fe81){const _0x2d1f4e=_0x5cbe56;_0x37fe81=_0x37fe81[_0x2d1f4e(0x188)]()[_0x2d1f4e(0xf7)]();switch(_0x37fe81){case _0x2d1f4e(0x1d4):if(!Scene_Message[_0x2d1f4e(0xa6)])return;break;case'options':if(!Imported['VisuMZ_1_OptionsCore'])return;break;case _0x2d1f4e(0x173):case _0x2d1f4e(0x18f):if(!Imported['VisuMZ_1_SaveCore'])return;break;case _0x2d1f4e(0x131):if(!Imported[_0x2d1f4e(0xc7)])return;break;case _0x2d1f4e(0xf4):case _0x2d1f4e(0xda):if(!Imported[_0x2d1f4e(0xee)])return;break;}const _0x987c65=new Window_ButtonConsole(_0x37fe81,this);this['_buttonConsoleButtons'][_0x2d1f4e(0x1d9)](_0x987c65),this['addChild'](_0x987c65);},Window_Message[_0x5cbe56(0xad)][_0x5cbe56(0x1d2)]=function(){const _0x22521d=_0x5cbe56,_0x1de85d=Window_ButtonConsole[_0x22521d(0x1bb)][_0x22521d(0x188)]()[_0x22521d(0xf7)](),_0x3dd476=this['_buttonConsoleButtons'];this[_0x22521d(0x187)]['x']=this[_0x22521d(0x187)]['y']=0x0;if([_0x22521d(0x119),'bottom'][_0x22521d(0x120)](_0x1de85d)){let _0x15ebd2=_0x3dd476['length']*Window_ButtonConsole[_0x22521d(0x150)];_0x15ebd2+=(_0x3dd476[_0x22521d(0x129)]-0x1)*Window_ButtonConsole[_0x22521d(0x16e)];let _0x369757=Math[_0x22521d(0x160)]((this[_0x22521d(0x196)]-_0x15ebd2)/0x2),_0x467185=_0x369757;for(const _0x30a91b of _0x3dd476){_0x30a91b['x']=_0x467185,_0x467185+=Window_ButtonConsole[_0x22521d(0x150)]+Window_ButtonConsole[_0x22521d(0x16e)];}}if(_0x1de85d===_0x22521d(0x119)){let _0x52974d=Window_ButtonConsole[_0x22521d(0x16e)];for(const _0x1ca4ce of _0x3dd476){_0x1ca4ce['y']=_0x52974d;}_0x52974d=Window_ButtonConsole[_0x22521d(0x133)],this[_0x22521d(0x187)]['y']=_0x52974d;};if(_0x1de85d===_0x22521d(0x1e5)){let _0x20de9f=this['height']-Window_ButtonConsole[_0x22521d(0x133)];_0x20de9f-=Window_ButtonConsole[_0x22521d(0x16e)];for(const _0x564e2e of _0x3dd476){if(_0x22521d(0x1d3)!=='fQrMS'){if(_0x5b0d9e[_0x22521d(0x19c)]()&&_0x27b491&&!_0x444b34[_0x22521d(0xab)]())return!![];else{if(_0x24e94b[_0x22521d(0x1df)]()&&!_0x11857a[_0x22521d(0xab)]())return!![];}return![];}else _0x564e2e['y']=_0x20de9f;}}},Window_Message[_0x5cbe56(0xad)][_0x5cbe56(0x1f2)]=function(_0x2fc5a7){const _0x17143d=_0x5cbe56;if(this['_hideButtonConsole'])return;if(!$gameSystem['isMessageButtonConsoleVisible']())return;_0x2fc5a7=_0x2fc5a7['toLowerCase']()['trim']();switch(_0x2fc5a7){case _0x17143d(0x173):if($gameSystem[_0x17143d(0x10a)]()&&SceneManager['isSceneMap']()){if(_0x17143d(0x1be)!==_0x17143d(0x1b3))this['playOkSound'](),SceneManager[_0x17143d(0x1d9)](Scene_SaveButtonConsole);else return this[_0x17143d(0x9c)]=this[_0x17143d(0x115)],_0x8def4d[_0x17143d(0x122)][_0x17143d(0x154)]['call'](this,_0x575272);}else this[_0x17143d(0x1b5)]();break;case _0x17143d(0x18f):if(DataManager[_0x17143d(0xce)]()&&SceneManager['isSceneMap']())this[_0x17143d(0x83)](),SceneManager[_0x17143d(0x1d9)](Scene_Load);else{if(_0x17143d(0x151)!==_0x17143d(0x151)){const _0x18a1b5=new _0x1e0614(0x0,0x0,_0x307798['BUTTON_WIDTH'],_0x4db69e[_0x17143d(0x133)]);this[_0x17143d(0x132)]=_0x3917bc,_0xaf800e[_0x17143d(0xad)][_0x17143d(0x1ca)][_0x17143d(0x1b6)](this,_0x18a1b5),this[_0x17143d(0x1c5)](),this[_0x17143d(0xc0)]=_0x3162c7[_0x17143d(0x188)]()[_0x17143d(0xf7)](),this[_0x17143d(0x104)](),this['hide']();}else this[_0x17143d(0x1b5)]();}break;case'options':if(SceneManager[_0x17143d(0x19c)]())this[_0x17143d(0x83)](),SceneManager[_0x17143d(0x1d9)](Scene_Options);else{if('epXoG'!=='ZsPgc')this[_0x17143d(0x1b5)]();else{let _0x79736d='';_0x79736d+=_0x17143d(0x185),_0x79736d+='The\x20latest\x20version\x20is\x20required\x20to\x20use\x0a',_0x79736d+='the\x20VisuMZ_2_ExtMessageFunc\x20plugin.',_0x38e97c(_0x79736d),_0x2a2844['exit']();}}break;case'gameend':if(SceneManager['isSceneMap']())this['playOkSound'](),SceneManager[_0x17143d(0x1d9)](Scene_GameEnd);else{if(_0x17143d(0x18e)!=='zwGJe')this['playBuzzerSound']();else{if(_0x1eca1b[_0x17143d(0xac)](_0x15dfd4[_0x17143d(0x1db)][_0x17143d(0x178)][_0x17143d(0x139)][_0x17143d(0x1a7)]))return!![];}}break;}},VisuMZ[_0x5cbe56(0x122)]['Window_Message_startWait']=Window_Message['prototype'][_0x5cbe56(0x1b1)],Window_Message[_0x5cbe56(0xad)][_0x5cbe56(0x1b1)]=function(_0x9cfb73){const _0x4dae7e=_0x5cbe56;if(SceneManager[_0x4dae7e(0x1bd)][_0x4dae7e(0x14b)]()){if('EPZxq'===_0x4dae7e(0x16b))return 0x0;else return;}VisuMZ[_0x4dae7e(0x122)][_0x4dae7e(0x1a5)][_0x4dae7e(0x1b6)](this,_0x9cfb73);},Window_Message[_0x5cbe56(0xad)][_0x5cbe56(0xbd)]=function(){const _0x348af3=_0x5cbe56,_0x1b0946=$gameSystem[_0x348af3(0xaf)]();return _0x1b0946['Enable'];},Window_Message[_0x5cbe56(0xad)][_0x5cbe56(0xdc)]=function(){const _0x1d8959=_0x5cbe56;this[_0x1d8959(0xbd)]()?'IjSoI'===_0x1d8959(0x8f)?this['createCustomMessageCursorPauseSignSprites']():_0x5961e4[_0x1d8959(0x161)](![]):'sNcJj'!==_0x1d8959(0x182)?Window_Base['prototype'][_0x1d8959(0xdc)][_0x1d8959(0x1b6)](this):_0x1a6444[_0x1d8959(0xb3)](_0x1def76[_0x4b27be]);},Window_Message[_0x5cbe56(0xad)][_0x5cbe56(0x1f3)]=function(){const _0x21651e=_0x5cbe56,_0x37ead3=$gameSystem[_0x21651e(0xaf)]();this[_0x21651e(0x8e)]=new Sprite(),this[_0x21651e(0xf2)](this[_0x21651e(0x8e)]),this['_pauseSignSprite'][_0x21651e(0xe4)]['x']=_0x37ead3[_0x21651e(0xd0)],this[_0x21651e(0x8e)][_0x21651e(0xe4)]['y']=_0x37ead3[_0x21651e(0xa0)],this[_0x21651e(0x190)]=0x0;},Window_Message['prototype'][_0x5cbe56(0xfc)]=function(){const _0x21bd2c=_0x5cbe56;this[_0x21bd2c(0xbd)]()?this['refreshCustomMessageCursorPauseSign']():(Window_Base[_0x21bd2c(0xad)][_0x21bd2c(0xfc)][_0x21bd2c(0x1b6)](this),this[_0x21bd2c(0x105)]());},Window_Message[_0x5cbe56(0xad)][_0x5cbe56(0x16d)]=function(){const _0x3e5296=_0x5cbe56,_0x390966=this[_0x3e5296(0x8e)];if(!_0x390966)return;const _0x91281d=$gameSystem[_0x3e5296(0xaf)](),_0x2fe7a3=_0x91281d['GraphicType'][_0x3e5296(0x188)]()[_0x3e5296(0xf7)]();_0x2fe7a3===_0x3e5296(0x135)?_0x390966['bitmap']=ImageManager['loadSystem'](_0x91281d[_0x3e5296(0x148)]):_0x390966['bitmap']=ImageManager[_0x3e5296(0xb3)](_0x3e5296(0xd8));},Window_Message[_0x5cbe56(0xad)][_0x5cbe56(0x105)]=function(){const _0x140319=_0x5cbe56,_0x34650c=this[_0x140319(0x8e)];if(!_0x34650c)return;if(!$gameSystem[_0x140319(0x11f)]())return;_0x34650c['y']-=Window_ButtonConsole['BUTTON_HEIGHT'];},Window_Message[_0x5cbe56(0xad)][_0x5cbe56(0x9f)]=function(){const _0x510585=_0x5cbe56;this[_0x510585(0xbd)]()?_0x510585(0x1f0)!==_0x510585(0x89)?this[_0x510585(0x155)]():this[_0x510585(0x1d7)]=_0x3f6326[_0x510585(0xb3)](_0x4ab71a['SKIN']):Window_Base[_0x510585(0xad)][_0x510585(0x9f)][_0x510585(0x1b6)](this);},Window_Message['prototype'][_0x5cbe56(0x155)]=function(){const _0x1ea980=_0x5cbe56;if(this[_0x1ea980(0x1ea)]===Graphics[_0x1ea980(0x15d)])return;this[_0x1ea980(0x1ea)]=Graphics[_0x1ea980(0x15d)];const _0xf7ed24=this[_0x1ea980(0x8e)];if(!_0xf7ed24)return;const _0x5b56ca=_0xf7ed24['bitmap'];if(_0x5b56ca['width']<=0x0)return;const _0x424b34=$gameSystem[_0x1ea980(0xaf)](),_0x2eb10c=_0x424b34['GraphicType'][_0x1ea980(0x188)]()[_0x1ea980(0xf7)](),_0x120ce8=this[_0x1ea980(0x117)]()||this[_0x1ea980(0x158)]();_0xf7ed24[_0x1ea980(0x141)]=_0x120ce8?0x0:0x1;if(_0xf7ed24['alpha']<=0x0)return;const _0x4e86f0=_0x424b34['Rows']*_0x424b34['Cols'];this['_pauseSignAnimationCount']++;while(this['_pauseSignAnimationCount']>=_0x4e86f0*_0x424b34['FrameDelay']){this[_0x1ea980(0x190)]-=_0x4e86f0*_0x424b34[_0x1ea980(0x1ab)];}_0x2eb10c===_0x1ea980(0x135)?this[_0x1ea980(0x1dd)]():_0x1ea980(0x100)===_0x1ea980(0x100)?this[_0x1ea980(0x98)]():this[_0x1ea980(0x1e1)]();},Window_Message[_0x5cbe56(0xad)]['updateImageMessageCursorPauseSignSprites']=function(){const _0x2fb940=_0x5cbe56,_0x5641b6=this[_0x2fb940(0x8e)],_0x1e0e7a=_0x5641b6[_0x2fb940(0x1a1)],_0x2b8e3a=$gameSystem['getMessageCursorSettings'](),_0x299a99=Math[_0x2fb940(0x160)](this[_0x2fb940(0x190)]/_0x2b8e3a[_0x2fb940(0x1ab)]),_0x2da8f3=Math[_0x2fb940(0x160)](_0x1e0e7a['width']/_0x2b8e3a['Cols']),_0x9a5752=Math[_0x2fb940(0x160)](_0x1e0e7a[_0x2fb940(0xd4)]/_0x2b8e3a[_0x2fb940(0x1e0)]),_0x1951a4=_0x299a99%_0x2b8e3a['Cols']*_0x2da8f3,_0x42cfec=Math[_0x2fb940(0x160)](_0x299a99/_0x2b8e3a[_0x2fb940(0xfb)])*_0x9a5752;_0x5641b6[_0x2fb940(0x149)](_0x1951a4,_0x42cfec,_0x2da8f3,_0x9a5752),_0x5641b6[_0x2fb940(0x1c0)]=this[_0x2fb940(0x175)]();},Window_Message[_0x5cbe56(0xad)]['updateIconMessageCursorPauseSignSprites']=function(){const _0x96d475=_0x5cbe56,_0x2e6d32=this[_0x96d475(0x8e)],_0x53b922=$gameSystem[_0x96d475(0xaf)](),_0x142669=_0x53b922['IconIndex'],_0x2d7b67=ImageManager[_0x96d475(0xed)],_0x528731=ImageManager['iconHeight'],_0x18ad96=_0x142669%0x10*_0x2d7b67,_0x2b1da9=Math[_0x96d475(0x160)](_0x142669/0x10)*_0x528731;_0x2e6d32[_0x96d475(0x149)](_0x18ad96,_0x2b1da9,_0x2d7b67,_0x528731),_0x2e6d32['visible']=this['isOpen']();if(_0x53b922['FlipMultiplier']===0x0)return;_0x2e6d32[_0x96d475(0x169)]['x']=Math[_0x96d475(0x86)](Graphics[_0x96d475(0x15d)]*_0x53b922[_0x96d475(0x1a6)]);},Window_Message[_0x5cbe56(0xad)][_0x5cbe56(0x9e)]=function(_0x5e5fd3){const _0x538889=_0x5cbe56;if(!_0x5e5fd3)return;if(!_0x5e5fd3['drawing'])return;if(!this[_0x538889(0xbd)]())return;const _0x4c7835=this['_pauseSignSprite'];if(!_0x4c7835)return;const _0x2815d0=$gameSystem[_0x538889(0xaf)]();_0x4c7835['x']=_0x5e5fd3['x']+this[_0x538889(0x1d8)]+_0x2815d0[_0x538889(0x128)]+_0x4c7835[_0x538889(0x196)]/0x2,_0x4c7835['x']+=this[_0x538889(0x187)]['x'],_0x4c7835['y']=_0x5e5fd3['y']+this[_0x538889(0x1d8)]+_0x5e5fd3[_0x538889(0xd4)]+_0x2815d0[_0x538889(0x101)],_0x4c7835['y']+=this[_0x538889(0x187)]['y'],_0x4c7835['x']=Math[_0x538889(0xe3)](_0x4c7835['x'][_0x538889(0xa5)](this[_0x538889(0x1d8)],this['width'])),_0x4c7835['y']=Math[_0x538889(0xe3)](_0x4c7835['y'][_0x538889(0xa5)](this[_0x538889(0x1d8)],this[_0x538889(0xd4)]-this[_0x538889(0x1d8)]));};function Window_ButtonConsole(){const _0x14622e=_0x5cbe56;this[_0x14622e(0x1ca)](...arguments);}Window_ButtonConsole['prototype']=Object[_0x5cbe56(0x199)](Window_Scrollable[_0x5cbe56(0xad)]),Window_ButtonConsole[_0x5cbe56(0xad)][_0x5cbe56(0xd1)]=Window_ButtonConsole,Window_ButtonConsole[_0x5cbe56(0x1da)]=VisuMZ[_0x5cbe56(0x122)][_0x5cbe56(0x178)]['MsgButtonConsole'][_0x5cbe56(0xf3)],Window_ButtonConsole[_0x5cbe56(0x1bb)]=VisuMZ[_0x5cbe56(0x122)][_0x5cbe56(0x178)][_0x5cbe56(0x109)][_0x5cbe56(0x8d)],Window_ButtonConsole['SKIN']=VisuMZ[_0x5cbe56(0x122)]['Settings'][_0x5cbe56(0x109)][_0x5cbe56(0x17b)],Window_ButtonConsole['FONT_FACE']=VisuMZ[_0x5cbe56(0x122)][_0x5cbe56(0x178)][_0x5cbe56(0x109)]['FontFace'],Window_ButtonConsole[_0x5cbe56(0xb4)]=VisuMZ[_0x5cbe56(0x122)][_0x5cbe56(0x178)][_0x5cbe56(0x109)]['FontSize'],Window_ButtonConsole[_0x5cbe56(0xdd)]=VisuMZ['ExtMessageFunc'][_0x5cbe56(0x178)]['MsgButtonConsole']['NormalColor'],Window_ButtonConsole[_0x5cbe56(0x19f)]=VisuMZ[_0x5cbe56(0x122)][_0x5cbe56(0x178)][_0x5cbe56(0x109)][_0x5cbe56(0x1aa)],Window_ButtonConsole[_0x5cbe56(0x110)]=VisuMZ[_0x5cbe56(0x122)][_0x5cbe56(0x178)][_0x5cbe56(0x109)][_0x5cbe56(0x124)],Window_ButtonConsole[_0x5cbe56(0x150)]=VisuMZ['ExtMessageFunc'][_0x5cbe56(0x178)][_0x5cbe56(0x109)][_0x5cbe56(0x11e)],Window_ButtonConsole['BUTTON_HEIGHT']=VisuMZ[_0x5cbe56(0x122)][_0x5cbe56(0x178)][_0x5cbe56(0x109)]['ButtonHeight'],Window_ButtonConsole[_0x5cbe56(0x16e)]=VisuMZ['ExtMessageFunc'][_0x5cbe56(0x178)][_0x5cbe56(0x109)][_0x5cbe56(0xb7)],Window_ButtonConsole[_0x5cbe56(0xfe)]=VisuMZ[_0x5cbe56(0x122)][_0x5cbe56(0x178)][_0x5cbe56(0xa2)][_0x5cbe56(0x18d)],Window_ButtonConsole['VOCAB']={'auto':VisuMZ[_0x5cbe56(0x122)][_0x5cbe56(0x178)]['Buttons'][_0x5cbe56(0x123)],'fastfwd':VisuMZ['ExtMessageFunc'][_0x5cbe56(0x178)][_0x5cbe56(0xa2)][_0x5cbe56(0x13d)],'save':VisuMZ['ExtMessageFunc']['Settings'][_0x5cbe56(0xa2)][_0x5cbe56(0xa7)],'load':VisuMZ[_0x5cbe56(0x122)][_0x5cbe56(0x178)]['Buttons']['Load'],'options':VisuMZ[_0x5cbe56(0x122)][_0x5cbe56(0x178)][_0x5cbe56(0xa2)][_0x5cbe56(0x108)],'gameend':VisuMZ[_0x5cbe56(0x122)][_0x5cbe56(0x178)][_0x5cbe56(0xa2)][_0x5cbe56(0x88)]},Window_ButtonConsole[_0x5cbe56(0x8c)]={'auto':VisuMZ[_0x5cbe56(0x122)][_0x5cbe56(0x178)][_0x5cbe56(0xa2)]['AutoKey'],'save':VisuMZ['ExtMessageFunc'][_0x5cbe56(0x178)][_0x5cbe56(0xa2)]['SaveKey'],'load':VisuMZ[_0x5cbe56(0x122)][_0x5cbe56(0x178)][_0x5cbe56(0xa2)]['LoadKey'],'options':VisuMZ[_0x5cbe56(0x122)][_0x5cbe56(0x178)][_0x5cbe56(0xa2)]['OptionsKey'],'gameend':VisuMZ['ExtMessageFunc'][_0x5cbe56(0x178)][_0x5cbe56(0xa2)][_0x5cbe56(0x17c)]},Window_ButtonConsole[_0x5cbe56(0xad)]['initialize']=function(_0x5ca6e7,_0x439f60){const _0x2b8dd2=_0x5cbe56,_0x44de8b=new Rectangle(0x0,0x0,Window_ButtonConsole[_0x2b8dd2(0x150)],Window_ButtonConsole[_0x2b8dd2(0x133)]);this[_0x2b8dd2(0x132)]=_0x439f60,Window_Scrollable[_0x2b8dd2(0xad)][_0x2b8dd2(0x1ca)]['call'](this,_0x44de8b),this['createBackImageSprites'](),this['_type']=_0x5ca6e7['toLowerCase']()[_0x2b8dd2(0xf7)](),this[_0x2b8dd2(0x104)](),this[_0x2b8dd2(0x131)]();},Window_ButtonConsole[_0x5cbe56(0xad)][_0x5cbe56(0x162)]=function(){return 0x0;},Window_ButtonConsole['prototype'][_0x5cbe56(0x12c)]=function(){const _0xf747c9=_0x5cbe56;this['windowskin']=ImageManager[_0xf747c9(0xb3)](Window_ButtonConsole[_0xf747c9(0x1b7)]);},Window_ButtonConsole['prototype']['updatePadding']=function(){const _0x24689c=_0x5cbe56;this[_0x24689c(0x1d8)]=0x0;},Window_ButtonConsole[_0x5cbe56(0xad)][_0x5cbe56(0xba)]=function(){const _0x15952f=_0x5cbe56;this[_0x15952f(0x14c)]=0xff;},Window_ButtonConsole[_0x5cbe56(0xad)][_0x5cbe56(0x1c5)]=function(){const _0x38832b=_0x5cbe56;Window_ButtonConsole[_0x38832b(0xea)]===undefined&&this[_0x38832b(0x17f)]();if(!Window_ButtonConsole[_0x38832b(0xea)])return;this[_0x38832b(0x1d6)]=0x0;const _0xff5e02=VisuMZ[_0x38832b(0x122)]['Settings'][_0x38832b(0x109)],_0x424f04=[_0x38832b(0x14d),_0x38832b(0xcb),_0x38832b(0xd7)];this[_0x38832b(0xbe)]={};for(const _0x15287e of _0x424f04){if(_0x38832b(0x1b0)===_0x38832b(0x107))this[_0x38832b(0x172)]===_0x22e6e7&&this['initMessageCursorSettings'](),this['_msgCursorSettings']=_0x24ecde[_0x38832b(0x11b)](_0x2432d6);else{if(_0xff5e02[_0x15287e]!==''){const _0x3f12b7=ImageManager['loadSystem'](_0xff5e02[_0x15287e]);this[_0x38832b(0xbe)][_0x15287e]=new Sprite(_0x3f12b7);const _0x26021b=this[_0x38832b(0xbe)][_0x15287e];this['addChildToBack'](_0x26021b),_0x26021b['x']=_0xff5e02['%1OffsetX'[_0x38832b(0x152)](_0x15287e)]||0x0,_0x26021b['y']=_0xff5e02[_0x38832b(0x167)[_0x38832b(0x152)](_0x15287e)]||0x0;}}}this[_0x38832b(0x145)]();},Window_ButtonConsole[_0x5cbe56(0xad)][_0x5cbe56(0x17f)]=function(){const _0x52bd00=_0x5cbe56;Window_ButtonConsole[_0x52bd00(0xea)]=![];const _0x4d234e=VisuMZ[_0x52bd00(0x122)]['Settings'][_0x52bd00(0x109)],_0x3aded4=['ImgDisabled',_0x52bd00(0xcb),'ImgToggled'];for(const _0x5dfa3c of _0x3aded4){if(_0x52bd00(0xfa)===_0x52bd00(0x125))this['initExtendedFastForward']();else{if(_0x4d234e[_0x5dfa3c]!==''){Window_ButtonConsole[_0x52bd00(0xea)]=!![];break;}}}},Window_ButtonConsole[_0x5cbe56(0xad)]['resetFontSettings']=function(){const _0x64089b=_0x5cbe56;Window_Scrollable[_0x64089b(0xad)][_0x64089b(0x102)][_0x64089b(0x1b6)](this),this[_0x64089b(0x183)]['fontFace']=Window_ButtonConsole['FONT_FACE'],this[_0x64089b(0x183)][_0x64089b(0x138)]=Window_ButtonConsole['FONT_SIZE'];},Window_ButtonConsole['prototype'][_0x5cbe56(0x104)]=function(){const _0x33f764=_0x5cbe56;this[_0x33f764(0xe8)](),this[_0x33f764(0x102)]();const _0x108c28=TextManager[_0x33f764(0x112)](this[_0x33f764(0xc0)]),_0x2b8f1c=this['textColorID']();this['changeTextColor'](ColorManager[_0x33f764(0xa3)](_0x2b8f1c)),this[_0x33f764(0xf8)](_0x108c28,0x0,0x0,this[_0x33f764(0x1cb)],_0x33f764(0x15f));},Window_ButtonConsole[_0x5cbe56(0xad)][_0x5cbe56(0x156)]=function(){const _0x38af65=_0x5cbe56;switch(this[_0x38af65(0xc0)]){case'auto':if($gameTemp['isMessageAutoForwardMode']()){if(_0x38af65(0x171)!=='VNuSw')return Window_ButtonConsole[_0x38af65(0x19f)];else _0x1252e2[_0x38af65(0x122)][_0x38af65(0x143)][_0x38af65(0x1b6)](this),this[_0x38af65(0xbf)]=this['_autoForwardCount']||0x0,this[_0x38af65(0xbf)]=_0x5e3db6[_0x38af65(0xa8)](this[_0x38af65(0xbf)],_0x4fbab0[_0x38af65(0x111)]);}break;case _0x38af65(0xf1):if($gameSystem[_0x38af65(0x11d)]()){if(_0x38af65(0x1c1)!==_0x38af65(0x95))return Window_ButtonConsole[_0x38af65(0x110)];else _0x3d10d2['loadCharacter'](_0xe2e60c[_0x38af65(0x16c)]());}else{if(SceneManager[_0x38af65(0x1bd)][_0x38af65(0x1c7)]())return Window_ButtonConsole[_0x38af65(0x19f)];}break;case _0x38af65(0x173):if(!$gameSystem[_0x38af65(0x10a)]()||!SceneManager[_0x38af65(0x19c)]())return Window_ButtonConsole['TEXT_COLOR_DISABLED'];break;case'load':if(!DataManager[_0x38af65(0xce)]()||!SceneManager[_0x38af65(0x19c)]())return Window_ButtonConsole[_0x38af65(0x110)];break;case _0x38af65(0x198):case'gameend':if(!SceneManager[_0x38af65(0x19c)]()){if(_0x38af65(0x1bf)==='daTFi')return Window_ButtonConsole[_0x38af65(0x110)];else this[_0x38af65(0x83)](),_0x1562bb[_0x38af65(0x1d9)](_0x1aa87e);}break;case'backlog':case _0x38af65(0xda):if(!$gameSystem[_0x38af65(0x1f4)]()||!SceneManager['isSceneMap']())return Window_ButtonConsole[_0x38af65(0x110)];break;}return Window_ButtonConsole[_0x38af65(0xdd)];},Window_ButtonConsole['prototype'][_0x5cbe56(0x1eb)]=function(){return!![];},Window_ButtonConsole['prototype'][_0x5cbe56(0xe9)]=function(){const _0x403a46=_0x5cbe56;if(this[_0x403a46(0x18a)]<0xff)return;switch(this[_0x403a46(0xc0)]){case'auto':let _0x4a3507=!$gameTemp[_0x403a46(0x13c)]();$gameTemp[_0x403a46(0x161)](_0x4a3507);if(_0x4a3507)this['playOkSound']();else{if(_0x403a46(0x96)!=='VNjLK'){if(this[_0x403a46(0x14a)])return;if(!_0x49a5ba[_0x403a46(0x11f)]())return;let _0x549eea=!_0x9cdfeb[_0x403a46(0x13c)]();_0x35e360[_0x403a46(0x161)](_0x549eea),_0x549eea?this[_0x403a46(0x83)]():_0x4a6b86[_0x403a46(0x18c)]();}else SoundManager['playCancel']();}break;case _0x403a46(0xf1):if(!$gameSystem['isExtendedFastForwardDisallowed']()){if(_0x403a46(0x1a8)==='qveEW')this['playBuzzerSound']();else{let _0x16ca22=!$gameTemp[_0x403a46(0x14b)]();$gameTemp[_0x403a46(0xca)](_0x16ca22);if(_0x16ca22)this[_0x403a46(0x83)]();else{if(_0x403a46(0x163)===_0x403a46(0x163))SoundManager[_0x403a46(0x18c)]();else{if(_0x1a9d0f[_0x403a46(0x19e)]&&_0x32e6da[_0x403a46(0xc5)]())return![];if(!this[_0x403a46(0x1b9)]()){if(_0x42c3b0[_0x403a46(0xac)](_0x44010a[_0x403a46(0x1db)][_0x403a46(0x178)][_0x403a46(0x139)][_0x403a46(0x1a7)]))return!![];}return _0x56c1dc['isExtendedFastForwardMode']();}}this['refresh']();}}else this[_0x403a46(0x1b5)]();break;case'save':$gameSystem[_0x403a46(0x10a)]()&&SceneManager[_0x403a46(0x19c)]()?_0x403a46(0x1d5)!=='NwFZp'?(this[_0x403a46(0x83)](),SceneManager[_0x403a46(0x1d9)](Scene_SaveButtonConsole)):(_0x43fb91['prototype'][_0x403a46(0x10c)][_0x403a46(0x1b6)](this),this[_0x403a46(0x1ee)](),this[_0x403a46(0xaa)](),this['updateBackImageSpriteVisibility']()):this[_0x403a46(0x1b5)]();break;case'load':DataManager['isAnySavefileExists']()&&SceneManager[_0x403a46(0x19c)]()?(this['playOkSound'](),SceneManager['push'](Scene_Load)):_0x403a46(0x116)==='ifsdB'?this[_0x403a46(0x1b5)]():(this[_0x403a46(0x83)](),_0x1a15b4[_0x403a46(0x1d9)](_0x3c75db));break;case _0x403a46(0x198):if(SceneManager[_0x403a46(0x19c)]()){if(_0x403a46(0xd3)==='RXyKG')return _0x1786ed[_0x403a46(0x110)];else this[_0x403a46(0x83)](),SceneManager[_0x403a46(0x1d9)](Scene_Options);}else _0x403a46(0x1e8)===_0x403a46(0x165)?(_0xd2b43[_0x403a46(0xad)]['_refreshPauseSign'][_0x403a46(0x1b6)](this),this[_0x403a46(0x105)]()):this[_0x403a46(0x1b5)]();break;case _0x403a46(0x195):if(SceneManager[_0x403a46(0x19c)]())this[_0x403a46(0x83)](),SceneManager['push'](Scene_GameEnd);else{if(_0x403a46(0x14f)!=='Lxoyx')this[_0x403a46(0x1b5)]();else{const _0x4b5a78=this['_buttonConsoleSprites']['ImgDisabled'];_0x4b5a78[_0x403a46(0x1c0)]=this[_0x403a46(0x156)]()===_0x5bfd61['TEXT_COLOR_DISABLED'];}}break;case _0x403a46(0x131):Imported[_0x403a46(0xc7)]&&$gameTemp[_0x403a46(0x93)]();break;case _0x403a46(0xf4):case _0x403a46(0xda):Imported['VisuMZ_3_MessageLog']&&($gameSystem['isMainMenuMessageLogEnabled']()&&SceneManager[_0x403a46(0x19c)]()?(this['playOkSound'](),SceneManager['push'](Scene_MessageLog)):this[_0x403a46(0x1b5)]());break;}TouchInput['clear']();},Window_ButtonConsole[_0x5cbe56(0xad)][_0x5cbe56(0x10c)]=function(){const _0x3c4bf3=_0x5cbe56;Window_Scrollable['prototype']['update'][_0x3c4bf3(0x1b6)](this),this[_0x3c4bf3(0x1ee)](),this['updateColor'](),this['updateBackImageSpriteVisibility']();},Window_ButtonConsole[_0x5cbe56(0xad)]['updateConsoleVisibility']=function(){const _0x340589=_0x5cbe56;if(!this[_0x340589(0x132)])return;this[_0x340589(0x18a)]=this[_0x340589(0x132)]['openness'];},Window_ButtonConsole[_0x5cbe56(0xad)][_0x5cbe56(0xaa)]=function(){const _0x1c6d14=_0x5cbe56;if(this['_type']===_0x1c6d14(0xf1)){if(this[_0x1c6d14(0xd9)]!==Input[_0x1c6d14(0xac)](VisuMZ['MessageCore']['Settings']['General'][_0x1c6d14(0x1a7)])){if(_0x1c6d14(0xff)===_0x1c6d14(0xff))this[_0x1c6d14(0xd9)]=Input[_0x1c6d14(0xac)](VisuMZ['MessageCore'][_0x1c6d14(0x178)][_0x1c6d14(0x139)][_0x1c6d14(0x1a7)]),this['refresh']();else{this['_autoForwardCount']=this[_0x1c6d14(0xbf)]||0x0,this['_autoForwardCount']=_0x47e0bc['max'](this[_0x1c6d14(0xbf)],0x0);const _0x1feb6b=(_0x2778c7[_0x1c6d14(0x8b)]||'')[_0x1c6d14(0x129)];this[_0x1c6d14(0xbf)]+=_0x1feb6b*_0x572ca0[_0x1c6d14(0x1d1)];}}}},Window_ButtonConsole['prototype']['updateBackImageSpriteVisibility']=function(){const _0x1a9464=_0x5cbe56;if(!Window_ButtonConsole['USE_BACK_IMAGE_SPRITES'])return;if(this[_0x1a9464(0xbe)]['ImgDisabled']){if(_0x1a9464(0x1f1)!=='SvjDo'){const _0x47e6bd=this[_0x1a9464(0xbe)][_0x1a9464(0x14d)];_0x47e6bd[_0x1a9464(0x1c0)]=this[_0x1a9464(0x156)]()===Window_ButtonConsole[_0x1a9464(0x110)];}else return this[_0x1a9464(0x1f2)]('gameend'),![];}if(this[_0x1a9464(0xbe)]['ImgEnabled']){const _0x445a10=this['_buttonConsoleSprites']['ImgEnabled'];_0x445a10[_0x1a9464(0x1c0)]=this[_0x1a9464(0x156)]()===Window_ButtonConsole['TEXT_COLOR_NORMAL'];}if(this['_buttonConsoleSprites'][_0x1a9464(0xd7)]){if(_0x1a9464(0xc3)!==_0x1a9464(0xf9)){const _0x297b7c=this['_buttonConsoleSprites'][_0x1a9464(0xd7)];_0x297b7c[_0x1a9464(0x1c0)]=this[_0x1a9464(0x156)]()===Window_ButtonConsole[_0x1a9464(0x19f)];}else this[_0x1a9464(0xd1)][_0x1a9464(0x11c)]===_0x1a9464(0x19d)&&this[_0x1a9464(0xcf)](_0x42bfd9),_0x4efe3d[_0x1a9464(0x122)][_0x1a9464(0x146)][_0x1a9464(0x1b6)](this,_0x4d3b8b),this[_0x1a9464(0xd1)][_0x1a9464(0x11c)]===_0x1a9464(0x19d)&&this[_0x1a9464(0x9e)](_0x3a661b);}};