//=============================================================================
// Command_Align.js  2017/03/14
//=============================================================================

/*:
 * @plugindesc タイトル及びオプションの文字表示位置
 * @help No,plugincommand.
 * とりあえずオプションとタイトルの文字が中央揃えになる感じのやつ
 * オプションはそもそもdrawTextがあったからそこのalignを変えるだけ
 * タイトルの方はよくわかんねえからWindow_OptionsのdrawItemと同じ事
 * 書いただけ詳しくは中身見てみてください
 * ちなみに'center'で中央揃え、'left'で左揃え、'right'で右揃え
 */

(function(_global) {
		
Window_Options.prototype.drawItem = function(index) {
    var rect = this.itemRectForText(index);
    var statusWidth = this.statusWidth();
    var titleWidth = rect.width - statusWidth;
    this.resetTextColor();
    this.changePaintOpacity(this.isCommandEnabled(index));
    this.drawText(this.commandName(index), rect.x, rect.y, titleWidth, 'center');//←オプションの項目名の方
    this.drawText(this.statusText(index), titleWidth, rect.y, statusWidth, 'center');//←ONOFFとかの項目の方
};
	//追加したやつ
Window_TitleCommand.prototype.drawItem = function(index) {
    var rect = this.itemRectForText(index);
    this.resetTextColor();
    this.changePaintOpacity(this.isCommandEnabled(index));
    this.drawText(this.commandName(index), rect.x, rect.y, rect.width, 'center');//←タイトルの項目
};
	
})(this);