/*:
 * @plugindesc Allows you to customize all of the Window.png colors through Parameters.
 * @author SumRndmDde
 *
 * @param Default Color
 * @desc The color used if you attempt to use a blank Text Color or a Text Color ID that does not exist.
 * @default White
 *
 * @param Text Color 0
 * @desc Color of Text Color ID 0.
 * Can be JavaScript Color, Hex Code, or RGBA Code.
 * @default #ffffff
 *
 * @param Text Color 1
 * @desc Color of Text Color ID 1.
 * Can be JavaScript Color, Hex Code, or RGBA Code.
 * @default #20a0d6
 *
 * @param Text Color 2
 * @desc Color of Text Color ID 2.
 * Can be JavaScript Color, Hex Code, or RGBA Code.
 * @default #ff784c
 *
 * @param Text Color 3
 * @desc Color of Text Color ID 3.
 * Can be JavaScript Color, Hex Code, or RGBA Code.
 * @default #66cc40
 *
 * @param Text Color 4
 * @desc Color of Text Color ID 4.
 * Can be JavaScript Color, Hex Code, or RGBA Code.
 * @default #99ccff
 *
 * @param Text Color 5
 * @desc Color of Text Color ID 5.
 * Can be JavaScript Color, Hex Code, or RGBA Code.
 * @default #ccc0ff
 *
 * @param Text Color 6
 * @desc Color of Text Color ID 6.
 * Can be JavaScript Color, Hex Code, or RGBA Code.
 * @default #ffffa0
 *
 * @param Text Color 7
 * @desc Color of Text Color ID 7.
 * Can be JavaScript Color, Hex Code, or RGBA Code.
 * @default #808080
 *
 * @param Text Color 8
 * @desc Color of Text Color ID 8.
 * Can be JavaScript Color, Hex Code, or RGBA Code.
 * @default #c0c0c0
 *
 * @param Text Color 9
 * @desc Color of Text Color ID 9.
 * Can be JavaScript Color, Hex Code, or RGBA Code.
 * @default #2080cc
 *
 * @param Text Color 10
 * @desc Color of Text Color ID 10.
 * Can be JavaScript Color, Hex Code, or RGBA Code.
 * @default #ff3810
 *
 * @param Text Color 11
 * @desc Color of Text Color ID 11.
 * Can be JavaScript Color, Hex Code, or RGBA Code.
 * @default #00a010
 *
 * @param Text Color 12
 * @desc Color of Text Color ID 12.
 * Can be JavaScript Color, Hex Code, or RGBA Code.
 * @default #3e9ade
 *
 * @param Text Color 13
 * @desc Color of Text Color ID 13.
 * Can be JavaScript Color, Hex Code, or RGBA Code.
 * @default #a098ff
 *
 * @param Text Color 14
 * @desc Color of Text Color ID 14.
 * Can be JavaScript Color, Hex Code, or RGBA Code.
 * @default #ffcc20
 *
 * @param Text Color 15
 * @desc Color of Text Color ID 15.
 * Can be JavaScript Color, Hex Code, or RGBA Code.
 * @default #000000
 *
 * @param Text Color 16
 * @desc Color of Text Color ID 16.
 * Can be JavaScript Color, Hex Code, or RGBA Code.
 * @default #84aaff
 *
 * @param Text Color 17
 * @desc Color of Text Color ID 17.
 * Can be JavaScript Color, Hex Code, or RGBA Code.
 * @default #ffff40
 *
 * @param Text Color 18
 * @desc Color of Text Color ID 18.
 * Can be JavaScript Color, Hex Code, or RGBA Code.
 * @default #ff2020
 *
 * @param Text Color 19
 * @desc Color of Text Color ID 19.
 * Can be JavaScript Color, Hex Code, or RGBA Code.
 * @default #202040
 *
 * @param Text Color 20
 * @desc Color of Text Color ID 20.
 * Can be JavaScript Color, Hex Code, or RGBA Code.
 * @default #e08040
 *
 * @param Text Color 21
 * @desc Color of Text Color ID 21.
 * Can be JavaScript Color, Hex Code, or RGBA Code.
 * @default #f0c040
 *
 * @param Text Color 22
 * @desc Color of Text Color ID 22.
 * Can be JavaScript Color, Hex Code, or RGBA Code.
 * @default #4080c0
 *
 * @param Text Color 23
 * @desc Color of Text Color ID 23.
 * Can be JavaScript Color, Hex Code, or RGBA Code.
 * @default #40c0f0
 *
 * @param Text Color 24
 * @desc Color of Text Color ID 24.
 * Can be JavaScript Color, Hex Code, or RGBA Code.
 * @default #80ff80
 *
 * @param Text Color 25
 * @desc Color of Text Color ID 25.
 * Can be JavaScript Color, Hex Code, or RGBA Code.
 * @default #c08080
 *
 * @param Text Color 26
 * @desc Color of Text Color ID 26.
 * Can be JavaScript Color, Hex Code, or RGBA Code.
 * @default #8080ff
 *
 * @param Text Color 27
 * @desc Color of Text Color ID 27.
 * Can be JavaScript Color, Hex Code, or RGBA Code.
 * @default #ff80ff
 *
 * @param Text Color 28
 * @desc Color of Text Color ID 28.
 * Can be JavaScript Color, Hex Code, or RGBA Code.
 * @default #00a040
 *
 * @param Text Color 29
 * @desc Color of Text Color ID 29.
 * Can be JavaScript Color, Hex Code, or RGBA Code.
 * @default #00e060
 *
 * @param Text Color 30
 * @desc Color of Text Color ID 30.
 * Can be JavaScript Color, Hex Code, or RGBA Code.
 * @default #a060e0
 *
 * @param Text Color 31
 * @desc Color of Text Color ID 31.
 * Can be JavaScript Color, Hex Code, or RGBA Code.
 * @default #c080ff
 *
 * @param Text Color 32
 * @desc Color of Text Color ID 32.
 * Can be JavaScript Color, Hex Code, or RGBA Code.
 * @default
 *
 * @param Text Color 33
 * @desc Color of Text Color ID 33.
 * Can be JavaScript Color, Hex Code, or RGBA Code.
 * @default
 *
 * @param Text Color 34
 * @desc Color of Text Color ID 34.
 * Can be JavaScript Color, Hex Code, or RGBA Code.
 * @default
 *
 * @param Text Color 35
 * @desc Color of Text Color ID 35.
 * Can be JavaScript Color, Hex Code, or RGBA Code.
 * @default
 *
 * @param Text Color 36
 * @desc Color of Text Color ID 36.
 * Can be JavaScript Color, Hex Code, or RGBA Code.
 * @default
 *
 * @param Text Color 37
 * @desc Color of Text Color ID 37.
 * Can be JavaScript Color, Hex Code, or RGBA Code.
 * @default
 *
 * @param Text Color 38
 * @desc Color of Text Color ID 38.
 * Can be JavaScript Color, Hex Code, or RGBA Code.
 * @default
 *
 * @param Text Color 39
 * @desc Color of Text Color ID 39.
 * Can be JavaScript Color, Hex Code, or RGBA Code.
 * @default
 *
 * @param Text Color 40
 * @desc Color of Text Color ID 40.
 * Can be JavaScript Color, Hex Code, or RGBA Code.
 * @default
 *
 * @param Text Color 41
 * @desc Color of Text Color ID 41.
 * Can be JavaScript Color, Hex Code, or RGBA Code.
 * @default
 *
 * @param Text Color 42
 * @desc Color of Text Color ID 42.
 * Can be JavaScript Color, Hex Code, or RGBA Code.
 * @default
 *
 * @param Text Color 43
 * @desc Color of Text Color ID 43.
 * Can be JavaScript Color, Hex Code, or RGBA Code.
 * @default
 *
 * @param Text Color 44
 * @desc Color of Text Color ID 44.
 * Can be JavaScript Color, Hex Code, or RGBA Code.
 * @default
 *
 * @param Text Color 45
 * @desc Color of Text Color ID 45.
 * Can be JavaScript Color, Hex Code, or RGBA Code.
 * @default
 *
 * @param Text Color 46
 * @desc Color of Text Color ID 46.
 * Can be JavaScript Color, Hex Code, or RGBA Code.
 * @default
 *
 * @param Text Color 47
 * @desc Color of Text Color ID 47.
 * Can be JavaScript Color, Hex Code, or RGBA Code.
 * @default
 *
 * @param Text Color 48
 * @desc Color of Text Color ID 48.
 * Can be JavaScript Color, Hex Code, or RGBA Code.
 * @default
 *
 * @param Text Color 49
 * @desc Color of Text Color ID 49.
 * Can be JavaScript Color, Hex Code, or RGBA Code.
 * @default
 *
 * @param Text Color 50
 * @desc Color of Text Color ID 50.
 * Can be JavaScript Color, Hex Code, or RGBA Code.
 * @default
 *
 * @help
 *
 * Custom Colors
 * Version 1.00
 * SumRndmDde
 *
 * 
 * By default, the text colors used by your game are obtained
 * from the Window.png file.
 *
 * However, if someone wanted to manipulate the text color, they
 * would have to manipulate the source image file; at least,
 * that's what they would have to do without this Plugin.
 *
 * Using this Plugin, you can set the Window.png colors using
 * Parameters. You can use Hex Color Codes, JavaScript Colors,
 * or RGBA Color Codes.
 *
 *
 * FURTHERMORE!
 * You can also add more colors to be called upon using \c[#].
 *
 * 
 * ==========================================================================
 * Default Color Usage Reference
 * ==========================================================================
 *
 * By default, these are the Text Color IDs used for each color:
 *
 * NormalColor:    0
 * SystemColor:    16
 * CrisisColor:    17
 * DeathColor:     18
 * GaugeBackColor: 19
 * HpGaugeColor1:  20
 * HpGaugeColor2:  21
 * MpGaugeColor1:  22
 * MpGaugeColor2:  23
 * MpCostColor:    23
 * PowerUpColor:   24
 * PowerDownColor: 25
 * TpGaugeColor1:  28
 * TpGaugeColor2:  29
 * TpCostColor:    29
 *
 * These can be changed using other Plugins, though if you have not changed 
 * them, these are their general function.
 *
 *
 * ==========================================================================
 * How to Use
 * ==========================================================================
 *
 * For example, the default Text Color 1 is the second color
 * in the Window.png and has Hex Code of #20a0d6.
 *
 * If you wanted to change it, simply change the Parameter.
 *
 * The Parameters all support the various usable color codes usable in
 * JavaScript.
 * 
 *
 * ==========================================================================
 * Plugin Commands
 * ==========================================================================
 *
 * You can also use Plugin Commands to change a Text Color in the middle
 * of the game:
 *
 *  SetCustomColor ID COLOR
 *
 * Set ID to the Text Color ID you wish to manipulate.
 * Set COLOR to the new color you wish to use.
 *
 * Examples:
 *
 * SetCustomColor 0 #00ff00
 * SetCustomColor 25 rgba(30,60,90,255)
 * SetCustomColor 100 green
 *
 *
 * ==========================================================================
 * JavaScript Colors
 * ==========================================================================
 *
 * It can be a JavaScript Color:
 * http://www.w3schools.com/colors/colors_names.asp
 *
 * Examples:
 * Blue
 * White
 * Green
 *
 *
 * ==========================================================================
 * Hex Color Codes
 * ==========================================================================
 *
 * It can be a Hex Color Code:
 * http://www.w3schools.com/colors/colors_picker.asp
 *
 * Examples:
 * #302faa
 * #ffffff
 * #bbaaff
 * #000000
 *
 *
 * ==========================================================================
 * RGBA Color Codes
 * ==========================================================================
 *
 * It can be an RGBA Color Code:
 * http://www.w3schools.com/colors/colors_picker.asp
 *
 * Examples:
 * rbga(125, 125, 125, 255)
 * rbga(0, 255, 0, 255)
 * rbga(100, 100, 100, 150)
 *
 *
 * ==========================================================================
 *  End of Help File
 * ==========================================================================
 * 
 * Welcome to the bottom of the Help file.
 *
 *
 * Thanks for reading!
 * If you have questions, or if you enjoyed this Plugin, please check
 * out my YouTube channel!
 *
 * https://www.youtube.com/c/SumRndmDde
 *
 *
 * Until next time,
 *   ~ SumRndmDde
 */

var SRD = SRD || {};
SRD.CustomColors = SRD.CustomColors || {};

var Imported = Imported || {};
Imported["SumRndmDde Custom Colors"] = true;

(function(_) {
	
	_.default = String(PluginManager.parameters('SRD_CustomColors')['Default Color'] || "#ffffff");
	_.colors = [];
	for(var i = 0; i <= 50; i++) {
		_.colors[i] = String(PluginManager.parameters('SRD_CustomColors')['Text Color ' + i] || _.default);
	}

	var _Window_Base_textColor = Window_Base.prototype.textColor;
	Window_Base.prototype.textColor = function(n) {
	    if(n >= 0 && n <= _.colors.length) return _.colors[n];
	    else return _.default;
	};

	var _Game_Interpreter_pluginCommand = Game_Interpreter.prototype.pluginCommand;
	Game_Interpreter.prototype.pluginCommand = function(command, args) {
	    _Game_Interpreter_pluginCommand.call(this, command, args);
	    if(command.trim().toLowerCase() === 'setcustomcolor') {
	    	_.colors[parseInt(args[0])] = String(args[1]).trim().toLowerCase();
	    }
	};

})(SRD.CustomColors);