"use strict";

//=============================================================================
//  EISMonsterBox.js
//=============================================================================

/*:
* @author Kino
* @plugindesc Allows you to randomly choose from a list of monsters within a common event.
*
* @help
* Version 1.00
//=============================================================================
//  Introduction
//=============================================================================
*
* This plugin allows you to create boxes that spawn monsters, or just spawn
* monsters via common events. Instead of making branches for spawning monsters,
* do it in a single script call.
*
//=============================================================================
//  Script Calls
//=============================================================================
*
* $gameTemp.monsterBox(troopIDs, canEscape, canLose);
* This will setup a battle instantly on the game, where you can fight enemies.
*
* Example: $gameTemp.monsterBox([1, 2, 3, 4], true, true);
* This means that any troops from 1 - 4 will be chosen and the player team
* can escape and lose.
*
//=============================================================================
//  Contact Information
//=============================================================================
*
* Contact me via twitter: EISKino, or on the rpg maker forums.
* Username on forums: Kino.
*
* Forum Link: http://forums.rpgmakerweb.com/index.php?/profile/75879-kino/
* Twitter Link: https://twitter.com/EISKino
* Website: http://endlessillusoft.com/
* Patreon Link: https://www.patreon.com/EISKino
*
* Hope this plugin helps, and enjoy!
* --Kino
*/

(function () {

  function setup() {
    //=============================================================================
    //  Scene_Item
    //=============================================================================
    var _SceneItem_useItem = Scene_Item.prototype.useItem;
    Scene_Item.prototype.useItem = function () {
      _SceneItem_useItem.call(this);
      this.processMonsterBox(this.item());
    };

    Scene_Item.prototype.processMonsterBox = function (item) {
      if (DataManager.isItem(item) && item.consumable) {
        var info = /<\s*TroopList\s*:\s*([^<>]*)\s*>/ig.exec(item.note);
        if (info !== null) {
          var troopIDs = info[1].trim().split(",").map(function (id) {
            return Number(id.trim());
          });
          if (troopIDs.every(function (id) {
            return typeof id === 'number';
          })) $gameTemp.monsterBox(troopIDs);
        }
      }
    };
    //=============================================================================
    //  Game_Temp
    //=============================================================================
    Game_Temp.prototype.monsterBox = function (troopIDs, canEscape, canLose) {
      var id = troopIDs[Math.floor(Math.random() * (troopIDs.length - 1))];
      canEscape = canEscape === undefined ? false : canEscape;
      canLose = canLose === undefined ? false : canLose;
      BattleManager.setup(id, canEscape, canLose);
      $gamePlayer.makeEncounterCount();
      SceneManager.push(Scene_Battle);
    };
  }

  setup();
})();
//# sourceMappingURL=EISMonsterBox.js.map