//=============================================================================
/*:
 * @plugindesc Menu Alt
 * MENU ALTERATION
 * @version 1.0
 * @author LS
 *
 */
//=============================================================================
//=============================================================================


(() => {
    'use strict';

    let screenWidth = 960;
    let screenHeight = 540;
    let hPadding = 100;
    let vPadding = 100;

    //REGULAR TEXTBOX==============================================================
    //opacity fix
    Window_Base.prototype.updateBackOpacity = function() {
        this.backOpacity = 255;
    };

    //make thinner
    Window_Message.prototype.windowWidth = function() {
        return screenWidth-hPadding;
    };
    //make shorter
    Window_Message.prototype.numVisibleRows = function() {
        return 3;
    };

    //add padding
    Window_Message.prototype.updatePlacement = function() {
        this._positionType = $gameMessage.positionType();
        this.y = this._positionType * ((Graphics.boxHeight - this.height) - (20)) / 2;
        this._goldWindow.y = this.y > 0 ? 0 : Graphics.boxHeight - this._goldWindow.height;
    };

    //PAUSE MENU===================================================================
    Window_MenuCommand.prototype.makeCommandList = function() {

        //remove unneeded commands
        this.addMainCommands();


        //this.addFormationCommand();
        //this.addOriginalCommands();
        //this.addOptionsCommand();
        //this.addSaveCommand();
        //this.addGameEndCommand();

    };

    Window_MenuCommand.prototype.windowWidth = function() {
      //change width
        return 200;
    };

    Scene_Menu.prototype.createCommandWindow = function() {
      //change spawn location
        this._commandWindow = new Window_MenuCommand((screenWidth-200)/2, (screenHeight-200)/2);
        this._commandWindow.setHandler('item',      this.commandItem.bind(this));
        this._commandWindow.setHandler('skill',     this.commandPersonal.bind(this));
        this._commandWindow.setHandler('equip',     this.commandPersonal.bind(this));
        this._commandWindow.setHandler('status',    this.commandPersonal.bind(this));
        this._commandWindow.setHandler('formation', this.commandFormation.bind(this));
        this._commandWindow.setHandler('options',   this.commandOptions.bind(this));
        this._commandWindow.setHandler('save',      this.commandSave.bind(this));
        this._commandWindow.setHandler('gameEnd',   this.commandGameEnd.bind(this));
        this._commandWindow.setHandler('cancel',    this.popScene.bind(this));
        this.addWindow(this._commandWindow);
    };

    //alter wording on commands still used
    Window_MenuCommand.prototype.addMainCommands = function() {
        var enabled = this.areMainCommandsEnabled();
        if (this.needsCommand('item')) {
            this.addCommand('POCKETS', 'item', enabled);
        }
      };
        Window_MenuCommand.prototype.addGameEndCommand = function() {
            var enabled = this.isGameEndEnabled();
            this.addCommand('END', 'gameEnd', enabled);
        };


      //dummy out menu entirely actually
      // Open Menu Screen
      Scene_Map.prototype.callMenu = function() {
        SoundManager.playOk();
        SceneManager.push(Scene_Item);
        //Window_MenuCommand.initCommandPosition();
        $gameTemp.clearDestination();
        this._mapNameWindow.hide();
        this._waitCount = 2;
    };

        //REMOVE UNNEEDED RPGMAKER WINDOWS===============================================

        //hide gold and status window on refresh
        var _Scene_Menu_create = Scene_Menu.prototype.create;
        Scene_Menu.prototype.create = function() {
            _Scene_Menu_create.call(this);
            this._statusWindow.x = -100000;
            this._statusWindow.y = -10000;
            this._goldWindow.x = -10000;
        };

        //hide gold window on creation
        Scene_Menu.prototype.createGoldWindow = function() {
            this._goldWindow = new Window_Gold(0, 0);
            this._goldWindow.x = -1000;
            this._goldWindow.y = -1000;
            this.addWindow(this._goldWindow);
        };

        //hide status window on creation
        Scene_Menu.prototype.createStatusWindow = function() {
            this._statusWindow = new Window_MenuStatus(-1000, -1000);
            this._statusWindow.reserveFaceImages();
            this.addWindow(this._statusWindow);
        };



      //ITEM Menu===================================================================
      //only 2 types of items
      Window_ItemCategory.prototype.maxCols = function() {
          return 1;
      };

      //dummy out item categories we don't use & rephrase them
      Window_ItemCategory.prototype.makeCommandList = function() {
          this.addCommand('EFFECTS',    'item');
          this.addCommand('INVENTORY', 'keyItem');
      };



      //FIX ALIGNMENT FOR COLS
      Window_HorzCommand.prototype.itemTextAlign = function() {
          return 'left';
      };

      //remove quantities
      Window_ItemList.prototype.drawItemNumber = function(item, x, y, width) {
          if (this.needsNumber()) {
              //this.drawText(':', x, y, width - this.textWidth('00'), 'right');
              //this.drawText($gameParty.numItems(item), x, y, width, 'right');
          }
      };

      //change box layout---------------------

      //item listing
      Scene_Item.prototype.createItemWindow = function() {

          var wy = this._categoryWindow.y + this._categoryWindow.height;
          var wh = 250;
          this._itemWindow = new Window_ItemList(hPadding/2, wy, screenWidth - hPadding, wh);
          this._itemWindow.setHelpWindow(this._helpWindow);
          this._itemWindow.setHandler('ok',     this.onItemOk.bind(this));
          this._itemWindow.setHandler('cancel', this.onItemCancel.bind(this));
          this.addWindow(this._itemWindow);
          this._categoryWindow.setItemWindow(this._itemWindow);
      };

      //commands---------------------------------
      Scene_Item.prototype.createCategoryWindow = function() {
          this._categoryWindow = new Window_ItemCategory();
          this._categoryWindow.setHelpWindow(this._helpWindow);
          this._categoryWindow.y = vPadding/2;
          this._categoryWindow.x = hPadding/2;
          this._categoryWindow.width = screenWidth - hPadding;
          this._categoryWindow.setHandler('ok',     this.onCategoryOk.bind(this));
          this._categoryWindow.setHandler('cancel', this.popScene.bind(this));
          this.addWindow(this._categoryWindow);

          //help window
          this._helpWindow.x = hPadding/2;
          this._helpWindow.width = screenWidth - hPadding;
          this._helpWindow.y = (screenHeight - this._helpWindow.height) -50;
      };



      //SELECTION COLOR FOR ITEMS===================================================================





})();
