var Imported = Imported || {};
Imported.DTE_Utilities = true;

var DTE_Utilities = DTE_Utilities || {};
DTE_Utilities.fun = DTE_Utilities.fun || {};


//=============================================================================
/*:
 * @plugindesc DTE Utilities
 * Various DTE functions to make my life not hell.
 * @version 1.0
 * @author LS
 *
 */
//=============================================================================
//=============================================================================


(function() {


  ///////////////////////////////////////////////////////////////////////////

  //random Utilities
  //RANDOM NUMBER GEN////////////////////////////////////////////
  function randomNumber(min, max) {

      let rand = Math.floor(Math.random()*(max-min+1)+min);
      return rand;
  };
  ////

  DTE_Utilities.fun.randomNum = function(min, max){
    return randomNumber(min, max);

  };





  //MOOD CALCULATION//////////////////////////////////////////////////////////////
  DTE_Utilities.fun.moodCalc = function(){
    /* MOOD BOARD

      *32+ -> gooder
      *16 through 32 -> good
      *16 through +16 -> neutral
      *-16 through -32 -> bad
      *-32 -> badder

      variable 1: initial dream mood :: the mood at the start of the dream
      variable 21: active dream mood ::  the variable that tracks mood throughout the dream
      variable 25: mood difference :: the difference between the initial mood and the mood at the end of the dream.

    */
    var moodAverage = 0;
    var moodDiff = $gameVariables.value(21) - $gameVariables.value(1);
    moodDiff = Math.abs(moodDiff);
    var moodMutation = 3;
    var moodMod = 0;

    //buffs & debuffs
    var tvOff = true;
    var didMakeup = false;
    var didWork = false;
    var sawHim = false;
    var sawElaine = false;
    var badPhone = false;

    if ($gameSwitches.value(50) == true) {
      tvOff = false;
    }
    if ($gameSwitches.value(53) == true) {
      didMakeup = true;
    }
    if ($gameSwitches.value(54) == true) {
      didWork = true;
    }
    if ($gameSwitches.value(55) == true) {
      sawHim = true;
    }
    if ($gameSwitches.value(56) == true) {
      sawElaine = true;
    }
    if ($gameSwitches.value(58) == true) {
      badPhone = true;
    }

    //get the average of the last mood to be our baseline
    moodAverage = ($gameVariables.value(21) + $gameVariables.value(1)) / 2;

    //get a mutator depending on how different our dream was from last dream
        if (moodDiff >= 15){
          moodMutation = 6;
        } else if (moodDiff >= 10){
          moodMutation = 5;
        } else if (moodDiff >= 5){
          moodMutation = 4;
        }

    //calculate buffs and debuffs
    if (tvOff == false){
      moodMod += 1;
    }
    if (didMakeup == true){
      moodMod -= 1;
    }
    if (didWork == true){
      moodMod -= 1;
    }
    if (sawHim == true){
      moodMod -= 1;
    }
    if (sawElaine == true){
      moodMod += 3;
    }
    if (badPhone == true){
      moodMod -= 1;
    }

    //calculate buffs and mutations:
    var newMood = moodAverage;

    //if our dreams were better, add the mutator as a positive, if they were worse, add them as a negative
    if ($gameVariables.value(21) > $gameVariables.value(1)){
      newMood += randomNumber(0,moodMutation);
    } else if ($gameVariables.value(21) < $gameVariables.value(1)) {
      newMood -= randomNumber(0,moodMutation);
    } else {
      //if our dreams were the same flip a coin
      var coinflip = randomNumber(0,1);
      if (coinflip == 1){
        newMood += randomNumber(0,moodMutation);
      } else {
        newMood -= randomNumber(0,moodMutation);
      }
    }

    //add those buffs
    newMood += moodMod;

    //chekc to make sure the scores aren't stupid out of hand.
    if (newMood >= 99) {
      newMood = 50
    } else if (newMood <= -99){
      newMood = -50;
    }

    //set the mood in game
    $gameVariables.setValue(1,newMood);
    $gameVariables.setValue(21,newMood);

  };
  /////////////////////////////////////////////////////////////

  //FRIDGE SPAWNER FOR FRIDGE WORLD/////////////////////////////
  DTE_Utilities.fun.fridgeSpawn = function (floor){
    //get fridge listing from floor
    var xy = [];
    //I know this switch statement is cringe. Get off my back.
    switch(floor){
      case 1:
      //floor 1
      xy[0] = [7,4];
      xy[1] =  [12,4];
      break;
      case 2:
      //floor 2
      xy[0] = [7,2];
      xy[1] = [9,2];
      xy[2] = [11,2];
      xy[3] = [13,2];
      xy[4] = [5,7];
      xy[5] = [11,7];
      xy[6] = [13,7];
      break;
      case 3:
      //floor 3
      xy[0] = [3,2];
      xy[1] = [5,2];
      xy[2] = [12,2];
      xy[3] = [14,2];
      xy[4] = [16,2];
      xy[5] = [3,7];
      xy[6] = [5,7];
      xy[7] = [7,7];
      xy[8] = [12,7];
      xy[9] = [14,7];
      xy[10] = [3,12];
      xy[11] = [5,12];
      xy[12] = [7,12];
      xy[13] = [12,12];
      xy[14] = [14,12];
      xy[15] = [16,12];
      break;
      case 4:
      //floor 4
      xy[0] = [2,4];
      xy[1] = [6,4];
      xy[2] = [8,4];
      xy[3] = [10,4];
      xy[4] = [12,4];
      xy[5] = [14,4];
      xy[6] = [16,4];
      xy[7] = [18,4];
      xy[8] = [20,4];
      xy[9] = [22,4];
      xy[10] = [24,4];
      break;
      case 5:
      //floor 5
      xy[0] = [5,2];
      xy[1] = [7,2];
      xy[2] = [9,2];
      xy[3] = [11,2];
      xy[4] = [7,7];
      xy[5] = [9,7];
      xy[6] = [11,7];
      xy[7] = [13,7];
      break;
      case 6:
      //floor 6
      xy[0] = [3,2];
      xy[1] = [7,2];
      xy[2] = [10,4];
      xy[3] = [12,4];
      xy[4] = [14,4];
      xy[5] = [16,4];
      xy[6] = [3,7];
      xy[7] = [5,7];
      xy[8] = [7,7];
      xy[9] = [3,12];
      xy[10] = [5,12];
      xy[11] = [10,14];
      xy[12] = [12,14];
      xy[13] = [14,14];
      break;
      case 7:
      //floor 7
      xy[0] = [2,3];
      xy[1] = [4,3];
      xy[2] = [6,3];
      xy[3] = [8,3];
      xy[4] = [10,3];
      xy[5] = [12,3];
      xy[6] = [14,3];
      xy[7] = [16,3];
      xy[8] = [4,9];
      xy[9] = [6,9];
      xy[10] = [8,9];
      xy[11] = [12,9];
      xy[12] = [14,9];
      xy[13] = [16,9];
      xy[14] = [3,14];
      xy[15] = [7,14];
      xy[16] = [9,14];
      xy[17] = [11,14];
      xy[18] = [13,14];
      xy[19] = [15,14];
      break;
      case 8:
      xy[0] = [5,2];
      xy[1] = [7,2];
      xy[2] = [9,2];
      xy[3] = [11,2];
      xy[4] = [13,2];
      xy[5] = [15,2];
      xy[6] = [3,8];
      xy[7] = [5,8];
      xy[8] = [7,8];
      xy[9] = [12,8];
      xy[10] = [14,8];
      xy[11] = [16,8];
      xy[12] = [3,15];
      xy[13] = [5,15];
      xy[14] = [7,15];
      xy[15] = [14,15];
      xy[16] = [16,15];
      xy[17] = [3,20];
      xy[18] = [5,20];
      xy[19] = [7,20];
      xy[20] = [12,20];
      xy[21] = [14,20];
      xy[22] = [16,20];
      break;
    }


    //RANDOMIZER SETUP
    var random = Math.random();
    var max = 9;
    var minId = 21;
    var badMax = 20;
    var badMinId = 18;
    var badnessChance = 16;
    var headEvent = false;

    var mood = "";
    var moodScore = $gameVariables.value(21);
    //determine mood through active mood
    if ($gameSwitches.value(135) == true){
      headEvent = true;
    } else {
      if (moodScore >= 32){
        //goodest
        badnessChance = 31;
      } else if (moodScore >= 16){
        //good
        badnessChance = 15;
      } else if (moodScore <= -32){
        //worst
        badnessChance = 0;
      } else if (moodScore <= -16){
        //badder
        badnessChance = 2;
      } else if (moodScore <= -8){
        //bad
        badnessChance = 3;
      }
    }



    //LOOP THROUGH ALL POSITIONS IN THE ARRAY
    for (let i = 0; i < xy.length; i++) {

      //check our badness chance to see if we should spawn a bad and naughty fridge.
      var badnessRandomizer = randomNumber(0, badnessChance);

      //check our head event to see if we're doing head event instead.
      if (headEvent == true){
        //time for heads!
        var event = 20;
        Galv.SPAWN.event(event,xy[i][0],xy[i][1]);

      } else {
        if (badnessRandomizer == 0){
          //spawn a bad fridge.
          random = randomNumber(18, 20)
          var steakHandler = randomNumber(0, 6)
          var event = 0;
          switch (steakHandler){
            case 6:
            event = 21;
            break;
            case 5:
            event = 29;
            break;
            default:
            event = random;
            break;
          }

          Galv.SPAWN.event(event,xy[i][0],xy[i][1]);

        } else {
          //spawn a normal fridge.
          var event = randomNumber(21, 30);
          Galv.SPAWN.event(event,xy[i][0],xy[i][1]);
        }
      }
    }
  };
    //end fridge event////////////////////////////////////



    //FRIDGE SPAWNER FOR FRIDGE WORLD/////////////////////////////
    DTE_Utilities.fun.loadImages = function (){
      //why is rpgmaker so bad at loading the assets it needs?

      //basic
      ImageManager.loadCharacter('!$kitty_0');
      ImageManager.loadCharacter('!$kitty_0_makeup');
      ImageManager.loadCharacter('!$kitty_0_work_nomake');
      ImageManager.loadCharacter('!$kitty_merm');
      ImageManager.loadCharacter('!$kitty_merm_swim');
      ImageManager.loadCharacter('!$kitty_paperbag');
      ImageManager.loadCharacter('!$kitty_zebra');
      ImageManager.loadCharacter('!$kitty_neon');
      ImageManager.loadCharacter('!$kitty_cig');
      ImageManager.loadCharacter('!$kitty_cig_onfire');
      ImageManager.loadCharacter('!$kitty_flamingo');




      //misc
      ImageManager.loadCharacter('!$kitty_0_makeup_pose');
      ImageManager.loadCharacter('!$kitty_0_sleep');

      //head shake
      var shake = ["0", "paperbag", "zebra","neon","cig_onfire","showgirl"];
      for (let i = 0; i < shake.length; i++) {
              ImageManager.loadCharacter('!$kitty_'+ shake[i] + '_shake');
      }



      //pinch
      ImageManager.loadCharacter('!$kitty_0_pinch');
      var pinch = ["0", "paperbag", "tiger", "zebra","neon","cig_onfire","showgirl"];
      for (let i = 0; i < pinch.length; i++) {
              ImageManager.loadCharacter('!$kitty_'+ pinch[i] + '_pinch');
      }

      //effect abilities
      ImageManager.loadCharacter('!$kitty_0_sit1');
      ImageManager.loadCharacter('!$kitty_0_sit2');
      ImageManager.loadCharacter('!$kitty_tiger_swipe1');
      ImageManager.loadCharacter('!$kitty_tiger_swipe2');
      ImageManager.loadCharacter('!$kitty_tiger_swipe3');
      ImageManager.loadCharacter('!$kitty_merm_hop');
      ImageManager.loadCharacter('!$kitty_flamingo_flap');

      //other important characters who don't like to loading
      ImageManager.loadCharacter('!$cameraman');
      ImageManager.loadCharacter('!$cameraman_engaging');
      ImageManager.loadCharacter('!$cameraman_engaged');

      

    };
    //end load images////////////////////////////////////



   //////////////////////////////////////////////////////////////////////
})();
