/*:
 * @plugindesc CGMV Splash Screen
 * @author Casper Gaming
 * @help
 * ==============================================================================
 * For terms and conditions using this plugin in your game please visit:
 * http://caspergaming.com/dev/terms_of_use/
 * ==============================================================================
 * Become a Patron to get access to a demo for this plugin as well as beta plugins
 * https://www.patreon.com/CasperGamingRPGM
 * ==============================================================================
 * Version: 1.1
 * ------------------------------------------------------------------------------
 * Compatibility: Only tested with my CGMV plugins.
 * Made for RPG Maker MV 1.6.0
 * ------------------------------------------------------------------------------
 * Description: This plugin creates a splash screen for your game. It can handle
 * multiple splashes.
 * ------------------------------------------------------------------------------
 * Documentation:
 * Display Time is amount of time to display an image for in frames.
 * 60 frames = 1 second
 *
 * Fade Speed is the amount of opacity to add/subtract for each frame of fade
 * in/out.
 *
 * Version History:
 * 1.0 - Initial Release
 *
 * 1.1:
 * - Fixed bug causing battle test to not work with this plugin.
 * 
 * @param Display Time
 * @type number
 * @min 1
 * @desc Determines amount of time splash is shown for.
 * @default 360
 * 
 * @param Fade Speed
 * @type number
 * @min 1
 * @max 255
 * @desc Determines how fast each splash fades
 * @default 2
 *
 * @param Images
 * @type file[]
 * @dir img/
 * @default []
*/
var Imported = Imported || {};
Imported.CGMV_SplashScreen = true;
var CGMV = CGMV || {};
CGMV.SplashScreen = CGMV.SplashScreen || {};
CGMV.SplashScreen.version = 1.1;
CGMV.SplashScreen.parameters = PluginManager.parameters('CGMV_SplashScreen');
CGMV.SplashScreen.DisplayTime = Number(CGMV.SplashScreen.parameters["Display Time"]) || 480;
CGMV.SplashScreen.FadeSpeed = Number(CGMV.SplashScreen.parameters["Fade Speed"]) || 2;
CGMV.SplashScreen.Images = JSON.parse(CGMV.SplashScreen.parameters["Images"]);
//=============================================================================
// CGMV_Scene_SplashScreen
//-----------------------------------------------------------------------------
// Scene to show splash images and then transfer to title scene.
//=============================================================================
function CGMV_Scene_SplashScreen() {
    this.initialize.apply(this, arguments);
}
CGMV_Scene_SplashScreen.prototype = Object.create(Scene_Base.prototype);
CGMV_Scene_SplashScreen.prototype.constructor = CGMV_Scene_SplashScreen;
//-----------------------------------------------------------------------------
// Initialize
//-----------------------------------------------------------------------------
CGMV_Scene_SplashScreen.prototype.initialize = function() {
    Scene_Base.prototype.initialize.call(this);
	this._timer = 0;
	this._fadeMode = 'none';
	this._fastFade = false;
	this._isReady = true;
	this._image = null;
	this._index = 0;
};
//-----------------------------------------------------------------------------
// Create splash scene assets
//-----------------------------------------------------------------------------
CGMV_Scene_SplashScreen.prototype.create = function() {
    Scene_Base.prototype.create.call(this);
    this.createImage();
};
//-----------------------------------------------------------------------------
// Create splash images
//-----------------------------------------------------------------------------
CGMV_Scene_SplashScreen.prototype.createImage = function() {
	this.removeChild(this._image);
	var imageLoc = this.getImageLocation(this._index);
    this._image = new Sprite(ImageManager.loadBitmap(imageLoc[0], imageLoc[1], 0, true));
	this._image.opacity = 0;
	this.addChild(this._image);
};
//-----------------------------------------------------------------------------
// Use regex to get image location information
//-----------------------------------------------------------------------------
CGMV_Scene_SplashScreen.prototype.getImageLocation = function(index) {
	var imageData = CGMV.SplashScreen.Images[index];
	var separator = imageData.lastIndexOf("/");
	var filename = imageData.slice(separator+1);
	var folder = "img/" + imageData.slice(0, separator+1);
	return [folder, filename];
};
//-----------------------------------------------------------------------------
// Update
//-----------------------------------------------------------------------------
CGMV_Scene_SplashScreen.prototype.update = function() {
    Scene_Base.prototype.update.call(this);
    if(this._timer == 0) {
		if(this._isReady == true) {
			if(this._index >= CGMV.SplashScreen.Images.length) {
				SceneManager.goto(Scene_Title);
				Window_TitleCommand.initCommandPosition();
			}
			else {
				this.createImage();
				this._isReady = false;
				this._index++;
			}
		}
		if(ImageManager.isReady()) {
			this._fadeMode = 'in';
			this._timer++;
		}
	}
	else {
		if(this._fadeMode === 'in') {
			if(this._image.opacity < 255) {
				this._image.opacity += CGMV.SplashScreen.FadeSpeed;
			}
			this._timer++;
			if(this._timer >= CGMV.SplashScreen.DisplayTime) {
				this._fadeMode = 'out';
			}
		}
		else if(this._fadeMode ==='out') {
			this._image.opacity -= CGMV.SplashScreen.FadeSpeed;
			if(this._fastFade) {
				this._image.opacity -= CGMV.SplashScreen.FadeSpeed*3;
			}
			if(this._image.opacity <= 0) {
				this._timer = 0;
				this._fadeMode = 'none';
				this._isReady = true;
				this._fastFade = false;
			}
		}
	}
	if(Input.isTriggered('ok') || TouchInput.isPressed()) {
		this._fadeMode = 'out';
		this._fastFade = true;
	}
};
//-----------------------------------------------------------------------------
// Center Sprite
//-----------------------------------------------------------------------------
CGMV_Scene_SplashScreen.prototype.centerSprite = function(sprite) {
    sprite.x = Graphics.width / 2;
    sprite.y = Graphics.height / 2;
    sprite.anchor.x = 0.5;
    sprite.anchor.y = 0.5;
};
//=============================================================================
// Scene_Boot
//-----------------------------------------------------------------------------
// Change which scene begins the game
//=============================================================================
//-----------------------------------------------------------------------------
// Alias: Change first scene unless event or battle test.
//-----------------------------------------------------------------------------
var alias_CGMV_SplashScreen_SceneBoot_start = Scene_Boot.prototype.start;
Scene_Boot.prototype.start = function() {
	if(DataManager.isBattleTest() || DataManager.isEventTest()) {
		alias_CGMV_SplashScreen_SceneBoot_start.call(this);
	}
	else {
		Scene_Base.prototype.start.call(this);
		SoundManager.preloadImportantSounds();
		this.checkPlayerLocation();
		DataManager.setupNewGame();
		SceneManager.goto(CGMV_Scene_SplashScreen);
		this.updateDocumentTitle();
	}
};