var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
/** /*:
 * @author William Ramsey
 * @plugindesc Beautiful, HD reflections and water!
 *
 *
 * @param Textures
 * @param wtextre
 * @text Water Texture (Terrain tag 2)
 * @type file
 * @dir img/textures
 * @default un_water
 * @parent Textures
 *
 * @param wltextre
 * @text Wall Textures
 * @type file[]
 * @dir img/textures
 * @default ["un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall","un_wall"]
 * @desc The number on the left represents the region ID!
 * @parent Textures
 *
 * @param Config
 * @param dfwc
 * @text Default Water Color
 * @default 4a4468
 * @parent Config
 * @desc Hex color for the water
 *
 * @param dfrc
 * @text Default Reflective Surface Color
 * @default 444e68
 * @parent Config
 * @desc Hex color for reflective walls.
 *
 * @param remshad
 * @text Remove Shadow
 * @type boolean
 * @default true
 * @parent Config
 * @desc Removes the boxy-shadow from the maps.
 *
 * @param hdrain
 * @text HD Rain
 * @default true
 * @type boolean
 * @desc Enables the HD rain effect.
 * @parent Config
 *
 * @help
 *
 * 【【Un】Hydro Max】
 * Behold one of the best looking water filters for MV out there.
 * Period.
 *
 * Basically, edit your tilesets tiles so that they match what it is
 * you're trying to do. For windows, mirrors or reflective floors paint
 * them with the "Default Reflective Surface Color" value. Default to
 * 444e68.
 *
 * For water, just paint your tile the water color, defaulted to
 * 4a4468.
 *
 * You can apply different textures to reflective surfaces by editing
 * the value "Wall Textures" The number will represent the region
 * ID. See help.html for more info.
 *
 * +------------------------------------------------------+
 * |                      HOW TO USE                      |
 * +------------------------------------------------------+
 * | [WATER]                                              |
 * | To use the water effect, you'll need to give your    |
 * | ground, paths and water tiles the terrain tag        |
 * | 2. This will allow the sprites to reflect off        |
 * | the water properly when near the water. Make sure    |
 * | your water has the color specified in the param      |
 * | setting. Included with this plugin, there's an       |
 * | example water tile you can use.                      |
 * |                                                      |
 * | [MIRROR]                                             |
 * | To use the mirror effect, use region IDs. Region     |
 * | ID 1 basically makes a perfectly smooth reflection.  |
 * | Go higher to experience more corrupt/scattered       |
 * | levels of reflection. You'll want to surround the    |
 * | tile that has the wall color with the region ID.     |
 * | Included with this plugin, there's an example        |
 * | screenshot. This works on walls -AND- floor tiles.   |
 * | To make a sprite not mirror its direction when       |
 * | reflecting (mostly used for large, single-direction  |
 * | sprites like the large monsters MV comes with by     |
 * | default), add "(NM)" to the file name. To completely |
 * | stop a sprite/actor from reflecting, add (NR) to the |
 * | file name.                                           |
 * |                                                      |
 * | [RAIN]                                               |
 * | To use the rain effect, simply toggle your rain/     |
 * | storm weather effects like you normally would.       |
 * +------------------------------------------------------+
 */
(function () {
    //GLOBAL FUNCTIONS///////////////////////
    /**
     * @const {Function} hex2rgbas
     * Converts a hex color into something readable
     * for shaders.
     * @param c
     */
    var hex2rgbas = function (c) {
        var rgbArray = [];
        var color;
        color = PIXI.utils.hex2rgb(parseInt(c, 16));
        if (color.length < 4) {
            color.push(1.0);
        }
        for (var i = 0; i < color.length; i++) {
            rgbArray.push(color[i]);
        }
        return rgbArray;
    };
    var params = PluginManager.parameters('unHydroMax');
    var stm_ov = ShaderTilemap.prototype._drawShadow;
    ShaderTilemap.prototype._drawShadow = function (layer, shadowBits, dx, dy) {
        if (params['remshad'] != 'true')
            stm_ov.call(this, layer, shadowBits, dx, dy);
    };
    ImageManager.loadTexture = function (filename, hue) {
        return this.loadBitmap('img/textures/', filename, hue, true);
    };
    var wallsp = JSON.parse(params['wltextre']);
    var walltmp = [];
    for (var i = 0; i < wallsp.length; i++) {
        walltmp.push(ImageManager.loadTexture("" + wallsp[i]));
    }
    //TEXTURES////////////////////////////////
    var TEXTURE = {
        water: ImageManager.loadTexture("" + params['wtextre']),
        walls: walltmp
    };
    //COLORS/////////////////////////////////
    var COLORS = {
        water: hex2rgbas(params['dfwc'].replace(/[^0-9a-fA-F]/g, '')),
        wall: hex2rgbas(params['dfrc'].replace(/[^0-9a-fA-F]/g, ''))
    };
    //SHADERS/////////////////////////
    /**
     * @var {Object} SHADER_FUNCTIONS
     * A list of functions that may be used in more
     * than 1 shader.
     */
    var SHADER_FUNCTIONS = {
        /**
         * @property {String} sat_control
         * Saturation Control.
         */
        sat_control: "vec3 gs(vec3 inputColor)\n        {\n            float gray = (inputColor.r + inputColor.g + inputColor.b) / 3.0;\n            return vec3(gray, gray, gray);\n        }\n\n        vec4 desat(inout vec4 inputColor, float amount)\n        {\n            inputColor.rgb = mix(inputColor.rgb, gs(inputColor.rgb), amount);\n            return inputColor;\n        }"
    };
    /**
     * @var {Object} SHADER
     * A list of fragment and vector shaders.
     */
    var SHADER = {
        frag: {
            miniWaveFilter: "varying vec2 vTextureCoord;\n            varying vec2 vFilterCoord;\n            \n            uniform sampler2D uSampler;\n            uniform sampler2D filterSampler;\n\n            uniform vec2 cam;\n            uniform vec2 res;\n            uniform float delta;\n\n            " + SHADER_FUNCTIONS.sat_control + "\n            \n            void main(void) {\n                vec2 camPosition = vec2(cam[0], cam[1] / res[1]);\n                vec4 color = texture2D(uSampler, vec2(vTextureCoord.x+(cos(delta+camPosition[0]+(gl_FragCoord.x)) / (res[0] / 2.0))+(sin(delta+camPosition[1]+(gl_FragCoord.y)) / (res[1] / 2.0)), vTextureCoord.y-0.005));\n                \n                gl_FragColor = color;\n            }",
            charWaveFilter: "varying vec2 vTextureCoord;\n            varying vec2 vFilterCoord;\n            \n            uniform sampler2D uSampler;\n            uniform sampler2D filterSampler;\n\n            uniform vec2 cam;\n            uniform vec2 res;\n            uniform float delta;\n            uniform vec4 waterColor;\n            uniform vec4 wallColor;\n            uniform bool isReflecting;\n            uniform float intensity;\n\n            " + SHADER_FUNCTIONS.sat_control + "\n            \n            void main(void) {\n                vec2 camPosition = vec2(cam[0], cam[1] / res[1]);\n                if(isReflecting == false) {\n                    vec4 color = texture2D(uSampler, vec2(vTextureCoord.x+(cos(delta+camPosition[0]+(gl_FragCoord.x *1.3)) / 28.0), vTextureCoord.y-0.005+(sin(delta+camPosition[1]+(gl_FragCoord.y *1.3)) / 28.0)));\n                    \n                    vec4 color2 = vec4(0.0,0.0,0.0,0.0);\n                    vec4 resultingColor = mix(color, color2, 0.5);\n                \n                    gl_FragColor = resultingColor;\n                } else {\n                    if(intensity>1.0) {\n                        gl_FragColor = texture2D(uSampler, vec2(vTextureCoord.x+(cos(camPosition[0]+(gl_FragCoord.x *(1.0+intensity))) / (48.0-intensity)), vTextureCoord.y+(sin(camPosition[1]+(gl_FragCoord.y *(1.0+intensity))) / (48.0-intensity))));\n                    } else {\n                        gl_FragColor = texture2D(uSampler, vTextureCoord);\n                    }\n                }\n            }",
            mapColorFilter: "varying vec2 vTextureCoord;\n            varying vec2 vFilterCoord;\n            \n            uniform sampler2D uSampler;\n            uniform sampler2D filterSampler;\n\n            uniform vec2 cam;\n            uniform vec2 res;\n            uniform bool isRaining;\n            uniform float delta;\n            uniform vec4 waterColor;\n            uniform vec4 wallColor;\n\n            " + SHADER_FUNCTIONS.sat_control + "\n            \n            void main(void) {\n                vec4 color = texture2D(uSampler, vTextureCoord);\n                vec4 color2 = texture2D(uSampler, vTextureCoord);\n\n                vec2 camPosition = vec2(cam[0], cam[1] / res[1]);\n                if(color == waterColor) {\n                    color = texture2D(uSampler, vec2(vTextureCoord.x+(cos(delta-camPosition[0]+(gl_FragCoord.x)) / (res[0] / 2.0)), vTextureCoord.y-(4.0/res[1])+(sin(delta+camPosition[1]+(gl_FragCoord.y)) / (res[1] / 2.0))));\n                    color2 = texture2D(uSampler, vec2(vTextureCoord.x+(cos(delta-camPosition[0]+(gl_FragCoord.x)) / (res[0] / 2.0)), vTextureCoord.y-(4.0/res[1])-(sin(delta+camPosition[1]+(gl_FragCoord.y)) / (res[1] / 2.0))));\n                    \n                    if(color == waterColor) {\n                        color = vec4(0.0, 0.0, 0.0, 0.0);\n                    } else {\n                        color /= 2.0;\n                        \n                    }\n                    if(color2 == waterColor) {\n                        color2 = vec4(0.0, 0.0, 0.0, 0.0);\n                    } else {\n                        color2 /= 2.0;\n                    }\n                }\n                if(color == waterColor / 2.0) {\n                    color = vec4(0.0, 0.0, 0.0, 0.0);\n                }\n                if(color2 == waterColor / 2.0) {\n                    color2 = vec4(0.0, 0.0, 0.0, 0.0);\n                }\n\n                if(color.r == wallColor.r && color.g == wallColor.g && color.b == wallColor.b) {\n                    color = texture2D(uSampler, vec2(vTextureCoord.x, vTextureCoord.y+0.01)) / 2.0;\n                    color2 = texture2D(uSampler, vec2(vTextureCoord.x, vTextureCoord.y-0.01)) / 2.0;\n                    \n                    if(color.r == wallColor.r && color.g == wallColor.g && color.b == wallColor.b) {\n                        color = vec4(0.0, 0.0, 0.0, 0.0);\n                    } else {\n                        color /= 2.0;\n                        \n                    }\n                    if(color2.r == wallColor.r && color2.g == wallColor.g && color2.b == wallColor.b) {\n                        color2 = vec4(0.0, 0.0, 0.0, 0.0);\n                    } else {\n                        color2 /= 2.0;\n                    }\n                }\n                if(color.r == wallColor.r && color.g == wallColor.g && color.b == wallColor.b) {\n                    color = vec4(0.0, 0.0, 0.0, 0.0);\n                }\n                if(color2.r == wallColor.r && color2.g == wallColor.g && color2.b == wallColor.b) {\n                    color2 = vec4(0.0, 0.0, 0.0, 0.0);\n                }\n                \n                gl_FragColor = mix(color, color2, 0.5);\n            }",
            /**@property {String} frag.colorRemove
             * Removes colors based on the defined list.
             */
            colorRemove: "varying vec2 vTextureCoord;\n            varying vec2 vFilterCoord;\n            \n            uniform sampler2D uSampler;\n            uniform sampler2D filterSampler;\n\n            uniform vec4 colorx;\n\n            " + SHADER_FUNCTIONS.sat_control + "\n            \n            void main(void) {\n                vec4 color = texture2D(uSampler, vTextureCoord);\n                vec4 color2 = texture2D(uSampler, vec2(vTextureCoord.x, vTextureCoord.y+0.01));\n                vec4 color3 = texture2D(uSampler, vec2(vTextureCoord.x, vTextureCoord.y-0.005));\n                vec4 erased = vec4(0.0,0.0,0.0,0.0);\n                if(color2 == colorx) {\n                    color2 = vec4(0.0,0.0,0.0,0.0);\n                }\n                if(color3 == colorx) {\n                    color3 = vec4(0.0,0.0,0.0,0.0);\n                }\n                if(color == colorx) {\n                    color = vec4(0.0,0.0,0.0,0.0);\n                }\n                gl_FragColor = color;\n            }",
            /**@property {String} frag.tintControl
             * Controls screen tinting.
             */
            tintControl: "varying vec2 vTextureCoord;\n            varying vec2 vFilterCoord;\n            \n            uniform sampler2D uSampler;\n            uniform sampler2D filterSampler;\n\n            uniform vec4 tone;\n\n            " + SHADER_FUNCTIONS.sat_control + "\n            \n            void main(void) {\n                vec4 color = texture2D(uSampler, vTextureCoord);\n\n                vec4 _tone = tone / 255.0;\n                \n                color.r += _tone[0];\n                color.g += _tone[1];\n                color.b += _tone[2];\n\n                color = desat(color, _tone[3]);\n                gl_FragColor = color;\n            }",
            rainShader: "varying vec2 vTextureCoord;\n            uniform sampler2D uSampler;\n            uniform float delta;\n            uniform vec2 cam;\n            uniform vec2 res;\n\n            uniform float intensity;\n        \n            " + SHADER_FUNCTIONS.sat_control + "\n        \n            void main(void) {\n                vec4 norm = texture2D(uSampler, vTextureCoord);\n                float PI = 3.1415926538;\n                float PID = PI*2.0;\n                float PIH = PI/2.0;\n                vec4 color = texture2D(uSampler, vTextureCoord);\n                vec4 color2 = texture2D(uSampler, vTextureCoord);\n                vec4 color3 = texture2D(uSampler, vTextureCoord);\n\n                vec2 camPosition = vec2(cam[0], cam[1]);\n        \n                    color2 = texture2D(uSampler, vec2(vTextureCoord.s + (cos((delta + cos(gl_FragCoord.x+camPosition[0]))-(gl_FragCoord.x+camPosition[0])) / res[0]), -0.002+vTextureCoord.t - (sin((-delta + sin(gl_FragCoord.x+camPosition[0]))*2.0+(gl_FragCoord.y + camPosition[1])) / res[1]))) / 2.0;\n                    color3 = texture2D(uSampler, vec2(vTextureCoord.s - (cos((delta + cos(gl_FragCoord.x+camPosition[0]))-(gl_FragCoord.x+camPosition[0])) / res[0]), -0.002+vTextureCoord.t - (sin((-delta + sin(gl_FragCoord.x+camPosition[0]))*2.0+(gl_FragCoord.y + camPosition[1])) / res[1]))) / 2.0;\n        \n                    color2 = desat(color2, 0.5);\n                    color3 = desat(color2, 0.5);\n        \n                    color2.r /=2.0;\n                    color3.g /= 1.25;\n        \n                    color2 = mix(color2, color3, 0.5);\n                    color = mix(color, color2, 0.5);\n                    \n                    \n                color /= 1.0+(cos((delta + cos(gl_FragCoord.x))-(gl_FragCoord.x + camPosition[0])) / res[0]);\n        \n                gl_FragColor = mix(color, norm, intensity);\n            }"
        },
        vert: {
            /**
             * @property {String} default
             * Default PIXI shader.
             */
            "default": "\n            attribute vec2 aVertexPosition;\n            attribute vec2 aTextureCoord;\n        \n            uniform mat3 projectionMatrix;\n            uniform mat3 filterMatrix;\n        \n            varying vec2 vTextureCoord;\n            varying vec2 vFilterCoord;\n        \n            void main(void){\n                gl_Position = vec4((projectionMatrix * vec3(aVertexPosition, 1.0)).xy, 0.0, 1.0);\n                vFilterCoord = ( filterMatrix * vec3( aTextureCoord, 1.0)  ).xy;\n                vTextureCoord = aTextureCoord;\n            }"
        }
    };
    /**
     * @var FILTER_CLASSES
     * A list of classes that contain the filters.
     */
    var FILTER_CLASSES = {
        c_miniWaveFilter: /** @class */ (function (_super) {
            __extends(class_1, _super);
            function class_1() {
                var _this = _super.call(this, SHADER.vert["default"], SHADER.frag.miniWaveFilter, {
                    delta: { type: 'f', value: 0 },
                    cam: { type: '2fv', value: [0, 0] },
                    res: { type: '2fv', value: [0, 0] }
                }) || this;
                _this.autoFit = true;
                return _this;
            }
            return class_1;
        }(PIXI.Filter)),
        c_rainFilter: /** @class */ (function (_super) {
            __extends(class_2, _super);
            function class_2() {
                var _this = _super.call(this, SHADER.vert["default"], SHADER.frag.rainShader, {
                    delta: { type: 'f', value: 0 },
                    cam: { type: '2fv', value: [0, 0] },
                    res: { type: '2fv', value: [0, 0] },
                    intensity: { type: 'f', value: 1.0 }
                }) || this;
                _this.autoFit = true;
                return _this;
            }
            return class_2;
        }(PIXI.Filter)),
        c_charWaveFilter: /** @class */ (function (_super) {
            __extends(class_3, _super);
            function class_3() {
                var _this = _super.call(this, SHADER.vert["default"], SHADER.frag.charWaveFilter, {
                    delta: { type: 'f', value: 0 },
                    cam: { type: '2fv', value: [0, 0] },
                    res: { type: '2fv', value: [0, 0] },
                    waterColor: { type: '4fv', value: COLORS.water },
                    wallColor: { type: '4fv', value: COLORS.wall },
                    isReflecting: { type: 'b', value: true },
                    intensity: { type: 'f', value: 1.0 }
                }) || this;
                _this.autoFit = true;
                return _this;
            }
            return class_3;
        }(PIXI.Filter)),
        c_mapColorFilter: /** @class */ (function (_super) {
            __extends(class_4, _super);
            function class_4() {
                var _this = _super.call(this, SHADER.vert["default"], SHADER.frag.mapColorFilter, {
                    delta: { type: 'f', value: 0 },
                    cam: { type: '2fv', value: [0, 0] },
                    res: { type: '2fv', value: [0, 0] },
                    isRaining: { type: 'b', value: false },
                    waterColor: { type: '4fv', value: COLORS.water },
                    wallColor: { type: '4fv', value: COLORS.wall }
                }) || this;
                _this.autoFit = true;
                return _this;
            }
            return class_4;
        }(PIXI.Filter)),
        /**
         * @property {Class} c_tint
         * Color tint filter.
         */
        c_tint: /** @class */ (function (_super) {
            __extends(class_5, _super);
            function class_5() {
                return _super.call(this, SHADER.vert["default"], SHADER.frag.tintControl, {
                    tone: { type: '4fv', value: [0, 0, 0, 0] }
                }) || this;
            }
            /**
             * @method setTone
             * Sets the tone of the screen.
             * @param tone
             */
            class_5.prototype.setTone = function (tone) {
                this.uniforms.tone = tone;
            };
            return class_5;
        }(PIXI.Filter)),
        /**
         * @property {Class} c_clearColor
         * Erases a specific color.
         */
        c_clearColor: /** @class */ (function (_super) {
            __extends(class_6, _super);
            function class_6() {
                var _this = _super.call(this, SHADER.vert["default"], SHADER.frag.colorRemove, {
                    colorx: { type: '4fv', value: hex2rgbas('285d8c') }
                }) || this;
                _this.autoFit = true;
                return _this;
            }
            return class_6;
        }(PIXI.Filter))
    };
    /**
     * @var FILTERS
     * A list of classes that contain the filters.
     */
    var FILTERS = {
        miniWaveFilter: new FILTER_CLASSES.c_miniWaveFilter(),
        mapColorFilter: new FILTER_CLASSES.c_mapColorFilter(),
        tint: new FILTER_CLASSES.c_tint(),
        clearColor: new FILTER_CLASSES.c_clearColor(),
        rainFilter: new FILTER_CLASSES.c_rainFilter()
    };
    //CLASSES//////////////////////////
    /**
     * Used for later.
     */
    var unSprite = /** @class */ (function (_super) {
        __extends(unSprite, _super);
        function unSprite() {
            return _super.call(this, new PIXI.Texture(new PIXI.BaseTexture())) || this;
        }
        return unSprite;
    }(PIXI.Sprite));
    /**
     * @class Sprite_Character_clone
     * Used for mirror effects.
     */
    var Sprite_Character_clone = /** @class */ (function (_super) {
        __extends(Sprite_Character_clone, _super);
        function Sprite_Character_clone(character) {
            var _this = _super.call(this, character) || this;
            _this.rzy = 0;
            _this.oldUpdate = _this.update;
            _this.filters = [new FILTER_CLASSES.c_charWaveFilter()];
            return _this;
        }
        /**
         * Set the characters bitmap and trigger the _isReflection variable.
         */
        Sprite_Character_clone.prototype.setCharacterBitmap = function () {
            this.bitmap = ImageManager.loadCharacter(this._characterName);
            this._isBigCharacter = ImageManager.isBigCharacter(this._characterName);
            this._isReflection = true;
        };
        /**
         * Set the character sprite and its parent.
         * @param character
         */
        Sprite_Character_clone.prototype.setCharacter = function (character) {
            this._character = Object.create(character);
            this._character._isReflection = true;
            this._character.zy = this.zy;
            this._charParent = character;
            this.scale.x = -1;
            this.scale.y = 1;
            this.ignoreFlip = false;
        };
        /**
         * Update the sprite data.
         */
        Sprite_Character_clone.prototype.update = function () {
            Sprite_Base.prototype.update.call(this);
            this.updateBitmap();
            this.updateFrame();
            this.updatePosition();
            this.updateAnimation();
            this.updateBalloon();
            this.updateOther();
            this.filters[0].uniforms.delta += Math.PI / 60;
            this.filters[0].uniforms.cam = [0, 0];
            this.filters[0].uniforms.res = [Graphics.boxWidth, Graphics.boxHeight];
            this.filters[0].uniforms.intensity = $gameMap.regionId(this._charParent.x, this._charParent.y - 1);
            /**If the sprite doesn't support all directions. */
            if (!this._character._characterName.includes('(NM)') && this.ignoreFlip == false) {
                this._character._direction = 10 - this._charParent._direction;
            }
            else {
                this._character._direction = this._charParent._direction;
            }
            if (this._character._characterName.includes('(NR)')) {
                this.visible = false;
            }
            this.rzy = this.zy + this.y;
        };
        /**
         * Update the sprites position.
         */
        Sprite_Character_clone.prototype.updatePosition = function () {
            var ybump = 0;
            var tid = $gameMap.terrainTag(this._charParent.x, this._charParent.y - 1);
            switch (tid) {
                default:
                    this.scale.x = -1;
                    ybump = ($gameMap.tileHeight() / 1.3);
                    this.scale.x = -1;
                    this.scale.y = 1;
                    this.ignoreFlip = false;
                    this.filters[0].uniforms.isReflecting = true;
                    break;
                case 2:
                    ybump = ($gameMap.tileHeight() / 8);
                    this.scale.x = 1;
                    this.scale.y = -1;
                    this.ignoreFlip = true;
                    this.opacity = 0.1;
                    this.filters[0].uniforms.isReflecting = false;
                    break;
            }
            tid = $gameMap.regionId(this._charParent.x, this._charParent.y - 1);
            if (tid > 0) {
                ybump = ($gameMap.tileHeight() / 1.3);
                this.scale.x = -1;
                this.scale.y = 1;
                this.ignoreFlip = false;
                this.filters[0].uniforms.isReflecting = true;
            }
            else {
                ybump = ($gameMap.tileHeight() / 8);
                this.scale.x = 1;
                this.scale.y = -1;
                this.ignoreFlip = true;
                this.opacity = 0.1;
                this.filters[0].uniforms.isReflecting = false;
            }
            this.x = this._character.screenX();
            this.y = this._character.screenY() - ybump;
            this.z = this._character.screenZ();
        };
        return Sprite_Character_clone;
    }(Sprite_Character));
    //ALIAS OVERRIDES/////////////////
    var sbi = Scene_Base.prototype.initialize;
    Scene_Base.prototype.initialize = function () {
        sbi.call(this);
    };
    ShaderTilemap.prototype.refreshTileset = function () {
        var bitmaps = this.bitmaps.map(function (x) { return x._baseTexture ? new PIXI.Texture(x._baseTexture) : x; });
        this.lowerLayer.setBitmaps(bitmaps);
        this.upperLayer.setBitmaps(bitmaps);
    };
    /**
     * Override the original Scene_Map initialize function
     * to include our tint filter.
     */
    var smi = Scene_Map.prototype.initialize;
    Scene_Map.prototype.initialize = function () {
        this.includeMainShaders = true;
        smi.call(this);
        this._toneCopy = [];
    };
    /**
     * Override Scene_Map Update to transfer tint data
     * to the shader.
     */
    var smu = Scene_Map.prototype.update;
    Scene_Map.prototype.update = function () {
        smu.call(this);
        if (params['hdrain'] == 'true') {
            if ($gameScreen._weatherType === 'rain' || $gameScreen._weatherType === 'storm') {
                FILTERS.rainFilter.enabled = true;
                FILTERS.mapColorFilter.uniforms.isRaining = true;
            }
            else {
                FILTERS.rainFilter.enabled = false;
                FILTERS.mapColorFilter.uniforms.isRaining = false;
            }
        }
        else {
            FILTERS.rainFilter.enabled = false;
        }
        FILTERS.rainFilter.uniforms.intensity = 1 - ($gameScreen._weatherPower / 9);
        if (this.toneCopy != $gameScreen._tone) {
            this.toneCopy = $gameScreen._tone;
            FILTERS.tint.setTone($gameScreen._tone);
        }
        FILTERS.mapColorFilter.uniforms.delta += Math.PI / 60;
        FILTERS.mapColorFilter.uniforms.cam = [-($gameMap.displayX() * $gameMap.tileWidth()), ($gameMap.displayY() * $gameMap.tileHeight())];
        FILTERS.mapColorFilter.uniforms.res = [Graphics.boxWidth, Graphics.boxHeight];
        FILTERS.miniWaveFilter.uniforms.delta += Math.PI / 60;
        FILTERS.miniWaveFilter.uniforms.cam = [($gameMap.displayX() * $gameMap.tileWidth()), ($gameMap.displayY() * $gameMap.tileHeight())];
        FILTERS.miniWaveFilter.uniforms.res = [Graphics.boxWidth, Graphics.boxHeight];
        FILTERS.rainFilter.uniforms.delta -= Math.PI / 60;
        FILTERS.rainFilter.uniforms.cam = [($gameMap.displayX() * $gameMap.tileWidth()), -($gameMap.displayY() * $gameMap.tileHeight())];
        FILTERS.rainFilter.uniforms.res = [Graphics.boxWidth, Graphics.boxHeight];
    };
    /**
     * Override the original Scene_Map function
     * to include our tint filter.
     */
    var sms = Scene_Map.prototype.start;
    Scene_Map.prototype.start = function () {
        sms.call(this);
        var oldFilters = (this._spriteset._tilemap.filters) ? this._spriteset._tilemap.filters : [];
        var filter_rect = new PIXI.Rectangle(0, 0, this._spriteset._tilemap.width, this._spriteset._tilemap.height);
        this._spriteset._tilemap.filterArea = filter_rect;
        FILTERS.clearColor.autoFit = false;
        oldFilters.push(FILTERS.tint);
        this._spriteset._tilemap.filters = oldFilters;
        var oldFilters2 = (this.filters) ? this.filters : [];
        FILTERS.clearColor.autoFit = false;
        oldFilters2.push(FILTERS.rainFilter);
        this.filters = oldFilters2;
    };
    /**
     * Override the original tone filter.
     * Same thing, except removing the part that applies
     * the default.
     */
    ToneFilter.prototype.adjustTone = function (r, g, b) {
        r = (r || 0).clamp(-255, 255) / 255;
        g = (g || 0).clamp(-255, 255) / 255;
        b = (b || 0).clamp(-255, 255) / 255;
        if (r !== 0 || g !== 0 || b !== 0) {
            var matrix = [
                1, 0, 0, r, 0,
                0, 1, 0, g, 0,
                0, 0, 1, b, 0,
                0, 0, 0, 1, 0
            ];
        }
    };
    ToneFilter.prototype.adjustSaturation = function (value) {
        value = (value || 0).clamp(-255, 255) / 255;
    };
    /**
     * Override sprites so that there are reflection clone versions.
     */
    Spriteset_Map.prototype.createTilemap = function () {
        if (Graphics.isWebGL()) {
            this._tilemap = new ShaderTilemap();
            this._tilemapClone = new Sprite();
            this._tilemapClone.tmpTextureMap = new Sprite(new Bitmap($gameMap.width() * $gameMap.tileWidth(), $gameMap.height() * $gameMap.tileHeight()));
            this._tilemap.filters = [FILTERS.mapColorFilter];
            this._tilemapClone.tmpTextureMap.filters = [FILTERS.miniWaveFilter];
            this._tilemapClone.tmpTextureMapWalls = new Sprite(new Bitmap($gameMap.width() * $gameMap.tileWidth(), $gameMap.height() * $gameMap.tileHeight()));
            for (var i = 0; i < $gameMap.width(); i++) {
                for (var j = 0; j < $gameMap.height(); j++) {
                    var x = i * $gameMap.tileWidth();
                    var y = j * $gameMap.tileHeight();
                    if ($gameMap.terrainTag(i, j) == 2) {
                        //this._tilemapClone.this._tilemapClone.tmpTextureMap.bitmap;
                        this._tilemapClone.tmpTextureMap.bitmap.blt(TEXTURE.water, 0, 0, 96, 96, x, y, $gameMap.tileWidth(), $gameMap.tileHeight());
                    }
                    if ($gameMap.terrainTag(i, j) != 2) {
                        //this._tilemapClone.this._tilemapClone.tmpTextureMap.bitmap;
                        var texture = TEXTURE.walls[$gameMap.regionId(i, j) - 1];
                        if (texture)
                            this._tilemapClone.tmpTextureMapWalls.bitmap.blt(texture, 0, 0, 96, 96, x, y, $gameMap.tileWidth(), $gameMap.tileHeight());
                    }
                }
            }
            this._tilemapClone.addChild(this._tilemapClone.tmpTextureMap);
            this._tilemapClone.addChild(this._tilemapClone.tmpTextureMapWalls);
            //this._tilemap.mask = this._tilemapClone;
        }
        else {
            this._tilemap = new Tilemap();
        }
        this._tilemap.tileWidth = $gameMap.tileWidth();
        this._tilemap.tileHeight = $gameMap.tileHeight();
        this._tilemap.setData($gameMap.width(), $gameMap.height(), $gameMap.data());
        this._tilemap.horizontalWrap = $gameMap.isLoopHorizontal();
        this._tilemap.verticalWrap = $gameMap.isLoopVertical();
        this.loadTileset();
        this._baseSprite.addChild(this._tilemapClone);
        this._baseSprite.addChild(this._tilemap);
    };
    Spriteset_Map.prototype.updateTilemap = function () {
        this._tilemap.origin.x = $gameMap.displayX() * $gameMap.tileWidth();
        this._tilemap.origin.y = $gameMap.displayY() * $gameMap.tileHeight();
        this._tilemapClone.tmpTextureMap.x = -($gameMap.displayX() * $gameMap.tileWidth());
        this._tilemapClone.tmpTextureMap.y = -($gameMap.displayY() * $gameMap.tileHeight());
        this._tilemapClone.tmpTextureMapWalls.x = -($gameMap.displayX() * $gameMap.tileWidth());
        this._tilemapClone.tmpTextureMapWalls.y = -($gameMap.displayY() * $gameMap.tileHeight());
    };
    Spriteset_Map.prototype.createCharacters = function () {
        this._characterSprites = [];
        this._cloneSprites = [];
        $gameMap.events().forEach(function (event) {
            this._characterSprites.push(new Sprite_Character(event));
            this._cloneSprites.push(new Sprite_Character_clone(event));
        }, this);
        $gameMap.vehicles().forEach(function (vehicle) {
            this._characterSprites.push(new Sprite_Character(vehicle));
            this._cloneSprites.push(new Sprite_Character_clone(vehicle));
        }, this);
        $gamePlayer.followers().reverseEach(function (follower) {
            this._characterSprites.push(new Sprite_Character(follower));
            this._cloneSprites.push(new Sprite_Character_clone(follower));
        }, this);
        this._characterSprites.push(new Sprite_Character($gamePlayer));
        this._cloneSprites.push(new Sprite_Character_clone($gamePlayer));
        for (var i = 0; i < this._characterSprites.length; i++) {
            this._tilemap.addChild(this._characterSprites[i]);
        }
        for (var i = 0; i < this._cloneSprites.length; i++) {
            this._cloneSprites[i].zy = -i;
            this._tilemapClone.addChild(this._cloneSprites[i]);
        }
    };
})();
