//=============================================================================
// MRP_BattleLogSkillTarget.js
//=============================================================================
/*:
 * @plugindesc Skills can now display target names using %2
 * @author Magnus0808
 */
 
(function() {
   
    Window_BattleLog.prototype.displayAction = function(subject, item) {
        var numMethods = this._methods.length;
        var targets = BattleManager._targets;
       
        if (DataManager.isSkill(item)) {
            var targets_string = "";
            // Checks if there is a target
            if (targets && targets.length > 0) {
                targets_string += targets[0].name();
                // Checks if there is more than a single target
                if (targets.length > 1) {
                    for (var i = 1; i < targets.length-1; i++) {
                        targets_string += ", " + targets[i].name();
                    }
                    targets_string += " and " + targets[targets.length-1].name();
                }
            }
            if (item.message1) {
                this.push('addText', subject.name() + item.message1.format(item.name, targets_string));
            }
            if (item.message2) {
                this.push('addText', item.message2.format(item.name, targets_string));
            }
        } else {
            this.push('addText', TextManager.useItem.format(subject.name(), item.name));
        }
        if (this._methods.length === numMethods) {
            this.push('wait');
        }
    };
})();