/*:
 * @plugindesc Fix for restoreMoveRoute bug present in default code.
 * @author Caethyril
 *
 * @help Bug description: when an original move route is restored, one command always
 *                  gets skipped.
 * Confirmed in versions 1.5.2 and 1.6.2.
 *
 * Bug explanation: updateRoutineMove: processMoveCommand, advanceMoveRouteIndex
 *                  processMoveCommand: processRouteEnd: restoreMoveRoute
 *                  restoreMoveRoute: resets move route index to original value
 *                  advanceMoveRouteIndex: always +1 to move route index
 *                   --> result: one move command gets skipped on restore.
 *
 * Implemented fix: decrease move route index by 1 immediately after restore.
 */

(function() {

	var _Game_Character_restoreMoveRoute = Game_Character.prototype.restoreMoveRoute;
	Game_Character.prototype.restoreMoveRoute = function() {
		_Game_Character_restoreMoveRoute.call(this);
		this._moveRouteIndex--;
	};

})();