//=============================================================================
// ItemChoiceHelpWindow_1.0.0.js 
//=============================================================================

/*:
 * @plugindesc 아이템 선택의 처리시 도움말창이 표시됩니다.
 * @author 습작(習作, Etude87)
 */

(function() {
	//=============================================================================
	// Window_Message
	//=============================================================================
	var alias_Window_Message_createSubWindows = Window_Message.prototype.createSubWindows;
	Window_Message.prototype.createSubWindows = function() {
		alias_Window_Message_createSubWindows.call(this);
		this._helpWindow = new Window_Help();
		this._helpWindow.openness = 0;
		this._helpWindow.deactivate();
		this._itemWindow.setHelpWindow(this._helpWindow);
	};
	//-----------------------------------------------------------------------------
	Window_Message.prototype.subWindows = function() {
		return [this._goldWindow, this._choiceWindow,
				this._numberWindow, this._itemWindow, this._helpWindow];
	};
	//-----------------------------------------------------------------------------
	Window_Message.prototype.isAnySubWindowActive = function() {
		return (this._choiceWindow.active ||
				this._numberWindow.active ||
				this._itemWindow.active ||
				this._helpWindow.active);
	};
	//=============================================================================
	// Window_EventItem
	//=============================================================================
	var alias_Window_EventItem_start = Window_EventItem.prototype.start;
	Window_EventItem.prototype.start = function() {
		alias_Window_EventItem_start.call(this);
		this._helpWindow.open();
		this._helpWindow.activate();
	};
	//-----------------------------------------------------------------------------
	var alias_Window_EventItem_updatePlacement = Window_EventItem.prototype.updatePlacement;
	Window_EventItem.prototype.updatePlacement = function() {
		alias_Window_EventItem_updatePlacement.call(this);
		if (this._messageWindow.y >= Graphics.boxHeight / 2) {
			this.y = 225;
		}
		this._helpWindow.y = 100;
		this._helpWindow.opacity=0;
	};
	//-----------------------------------------------------------------------------
	var alias_Window_EventItem_onOk = Window_EventItem.prototype.onOk;
	Window_EventItem.prototype.onOk = function() {
		alias_Window_EventItem_onOk.call(this);
		this._helpWindow.close();
		this._helpWindow.deactivate();
	};
	//-----------------------------------------------------------------------------
	var alias_Window_EventItem_onCancel = Window_EventItem.prototype.onCancel;
	Window_EventItem.prototype.onCancel = function() {
		alias_Window_EventItem_onCancel.call(this);
		this._helpWindow.close();
		this._helpWindow.deactivate();
	};
	//=============================================================================
})();