Window_Base.prototype.contentsHeight = function() {
    //return this.height - this.standardPadding() * 2;
	return this.height - (this.standardPadding() + 2) * 2;
};

Window_Base.prototype.fittingHeight = function(numLines) {
    //return numLines * this.lineHeight() + this.standardPadding() * 2;
	return numLines * this.lineHeight() + (this.standardPadding() + 2) * 2;
};

Window_Base.prototype.drawText = function(text, x, y, maxWidth, align) {
    this.contents.drawText(text, x, y+6, maxWidth, this.lineHeight(), align);
};

Window_Command.prototype.windowHeight = function() {
    return this.fittingHeight(this.numVisibleRows()) + 4;
};

Window_Help.prototype.initialize = function(numLines) {
    var width = Graphics.boxWidth;
    //var height = this.fittingHeight(numLines || 2);
	var height = 32
    Window_Base.prototype.initialize.call(this, 0, 0, width, height);
    this._text = '';
};

Window_Help.prototype.refresh = function() {
    this.contents.clear();
    this.drawTextEx(this._text, this.textPadding(), 6);
};

Window_Gold.prototype.windowHeight = function() {
    return this.fittingHeight(1) + 4;
};

Window_ItemList.prototype.spacing = function() {
    return 9;
};

Window_Options.prototype.windowWidth = function() {
    return 320;
};

Window_Options.prototype.windowHeight = function() {
    return this.fittingHeight(Math.min(this.numVisibleRows(), 12)) + 4;
};

Window_Base.prototype.drawActorHp = function(actor, x, y, width) {
    //width = width || 186;
	width = 64
    var color1 = this.hpGaugeColor1();
    var color2 = this.hpGaugeColor2();
    this.drawGauge(x, y, width, actor.hpRate(), color1, color2);
    this.changeTextColor(this.systemColor());
    this.drawText(TextManager.hpA, x, y, 44);
    this.drawCurrentAndMax(actor.hp, actor.mhp, x, y, width,
                           this.hpColor(actor), this.normalColor());
};

Window_Base.prototype.drawActorMp = function(actor, x, y, width) {
    //width = width || 186;
	width = 64
    var color1 = this.mpGaugeColor1();
    var color2 = this.mpGaugeColor2();
    this.drawGauge(x, y, width, actor.mpRate(), color1, color2);
    this.changeTextColor(this.systemColor());
    this.drawText(TextManager.mpA, x, y, 44);
    this.drawCurrentAndMax(actor.mp, actor.mmp, x, y, width,
                           this.mpColor(actor), this.normalColor());
};

Window_Base.prototype.drawActorSimpleStatus = function(actor, x, y, width) {
    var lineHeight = this.lineHeight();
    var xpad = Window_Base._faceWidth + (2 * Yanfly.Param.TextPadding);
	//var x2 = x + xpad;
	var x2 = x + xpad +40;
    var width2 = Math.max(180, width - xpad - this.textPadding());
    this.drawActorName(actor, x+21, y-3);
    this.drawActorLevel(actor, x+21, y-3 + lineHeight * 1);
    this.drawActorIcons(actor, x-1, y-1 + lineHeight * 2);
    this.drawActorClass(actor, x2, y-3, width2);
    this.drawActorHp(actor, x2+6, y-3 + lineHeight * 1, width2);
    this.drawActorMp(actor, x2+6, y-3 + lineHeight * 2, width2);
    if (Yanfly.Param.MenuTpGauge) {
      this.drawActorTp(actor, x2, y + lineHeight * 3, width2);
    }
};

Window_Base.prototype.drawItemName = function(item, x, y, width) {
    width = width || 312;
    if (item) {
        //var iconBoxWidth = Window_Base._iconWidth + 4;
        this.resetTextColor();
        //this.drawIcon(item.iconIndex, x + 2, y + 2);
        //this.drawText(item.name, x + iconBoxWidth, y, width - iconBoxWidth);
		this.drawText(item.name, x+4, y, width);
    }
};

Window_Selectable.prototype.hitTest = function(x, y) {
    if (this.isContentsArea(x, y)) {
        var cx = x - this.padding;
        var cy = y - this.padding;
        var topIndex = this.topIndex();
        for (var i = 0; i < this.maxPageItems(); i++) {
            var index = topIndex + i;
            if (index < this.maxItems()) {
                var rect = this.itemRect(index);
                var right = rect.x + rect.width;
                var bottom = rect.y+4 + rect.height;
                if (cx >= rect.x && cy >= rect.y+4 && cx < right && cy < bottom) {
                    return index;
                }
            }
        }
    }
    return -1;
};

Window_Selectable.prototype.updateCursor = function() {
    if (this._cursorAll) {
        var allRowsHeight = this.maxRows() * this.itemHeight();
        this.setCursorRect(0, 0, this.contents.width, allRowsHeight);
        this.setTopRow(0);
    } else if (this.isCursorVisible()) {
        var rect = this.itemRect(this.index());
        this.setCursorRect(rect.x, rect.y+4, rect.width, rect.height);
    } else {
        this.setCursorRect(0, 0, 0, 0);
    }
};

Window_Message.prototype.needsNewPage = function(textState) {
    //return (!this.isEndOfText(textState) &&
            //textState.y + textState.height > this.contents.height);
};

Window_Message.prototype.windowHeight = function() {
    //return this.fittingHeight(this.numVisibleRows());
	//return 80
	return ((this.numVisibleRows() * 16) + 16)
};

Window_Message.prototype.newPage = function(textState) {
    this.contents.clear();
    this.resetFontSettings();
    this.clearFlags();
    this.loadMessageFace();
    textState.x = this.newLineX();
    textState.y = 6;
    textState.left = this.newLineX();
    textState.height = this.calcTextHeight(textState, false);
};

Window_Message.prototype.drawMessageFace = function() {
    this.drawFace($gameMessage.faceName(), $gameMessage.faceIndex(), 12, 12);
    ImageManager.releaseReservation(this._imageReservationId);
};

Window_Message.prototype.newLineX = function() {
    return $gameMessage.faceName() === '' ? 4 : 76;
};