//=============================================================================
// Change_Message_Line_Height
//-----------------------------------------------------------------------------
// This plugin allows specify a line height value for message windows.
// number of lines.
//=============================================================================

/*:
 @plugindesc This plugin allows specify a line height value for message windows.
 @author King Gerar
 
 @param lineHeight
 @text Line height of the message window.
 @default 36
 @min 0
 @type number
 
 @help
 ------------------------------------------------------------------------------
 Added Functions:
 
 Overwritten Functions:
	 Window_Message.lineHeight
	 Window_Message.processNewLine
	 
 Aliased Functions:

*/
	
(function() {
	'use strict';
	
	window.Imported = window.Imported || {};
	
	Imported.Change_Message_Line_Height = true;
	
	var Change_Message_Line_Height = {
		lineHeight: Number(PluginManager.parameters('Change_Message_Line_Height')['lineHeight'])
	};
	
	Window_Message.prototype.lineHeight = function() {
    return Change_Message_Line_Height.lineHeight;
	};
	
	Window_Base.prototype.processNewLine = function(textState) {
		this._lineShowFast = false;
    textState.x = textState.left;
    textState.y += this.lineHeight();
    textState.height = this.calcTextHeight(textState, false);
    textState.index++;
		if (this.needsNewPage(textState)) {
			this.startPause();
		};
	};

}());	





